/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtStatement;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6097
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Lowercase 'L' at the end of a long literal can be mistaken for '1'.").setLevel(WarningLevel.LEVEL_3).setSastId("CERT-DCL50-J").build();
    private static final Set<Long> EXCLUDES = new HashSet<Long>(Arrays.asList(0L, 24L, 256L, 1024L));

    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        long countLiterals;
        Object value = literal.getValue();
        if (!(value instanceof Long)) {
            return;
        }
        if (EXCLUDES.contains(value)) {
            return;
        }
        String string = literal.toString();
        if (string.endsWith("00L") || string.matches("\\d0L")) {
            return;
        }
        if (this.isAnnotated("Test")) {
            return;
        }
        CtClass ctClass = (CtClass)literal.getParent((Filter)new TypeFilter(CtClass.class));
        if (ctClass != null && (ctClass.getSimpleName().startsWith("Test") || ctClass.getSimpleName().endsWith("Test"))) {
            return;
        }
        SourcePosition position = literal.getPosition();
        if (!position.isValidPosition()) {
            return;
        }
        String text = position.getCompilationUnit().getOriginalSourceCode();
        String literalSourceCode = text.substring(position.getSourceStart(), position.getSourceEnd() + 1);
        if (!literalSourceCode.endsWith("l")) {
            return;
        }
        CtField field = (CtField)literal.getParent((Filter)new TypeFilter(CtField.class));
        if (field != null && field.getSimpleName().equals("serialVersionUID")) {
            return;
        }
        CtField parentLiteral = field;
        if (parentLiteral == null) {
            parentLiteral = literal.getParent((Filter)new TypeFilter(CtStatement.class));
        }
        if (parentLiteral != null && (countLiterals = parentLiteral.getElements((Filter)new TypeFilter(CtLiteral.class)).stream().filter(l -> l.toString().endsWith("L")).count()) > 3L) {
            return;
        }
        this.rule.add((CtElement)literal, new Object[0]);
    }
}

