/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.Equality;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningLevel;
import com.pvsstudio.warnings.WarningPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public class V6096
extends PvsStudioRule {
    PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("An odd precise comparison. Consider using a comparison with defined precision: Math.abs(A - B) %s Epsilon.").setLevel(WarningLevel.LEVEL_3).setCwe(682).build();
    private final List<String> doubleFieldNames = Arrays.asList("java.lang.Double#NaN", "java.lang.Double#POSITIVE_INFINITY", "java.lang.Double#NEGATIVE_INFINITY", "sun.misc.DoubleConsts#NaN", "sun.misc.DoubleConsts#POSITIVE_INFINITY", "sun.misc.DoubleConsts#NEGATIVE_INFINITY");
    private final List<String> floatFieldNames = Arrays.asList("java.lang.Float#NaN", "java.lang.Float#POSITIVE_INFINITY", "java.lang.Float#NEGATIVE_INFINITY", "sun.misc.FloatConsts#NaN", "sun.misc.FloatConsts#POSITIVE_INFINITY", "sun.misc.FloatConsts#NEGATIVE_INFINITY");

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        BinaryOperatorKind kind = operator.getKind();
        if (kind != BinaryOperatorKind.EQ && kind != BinaryOperatorKind.NE) {
            return;
        }
        CtExpression leftOperand = operator.getLeftHandOperand();
        CtExpression rightOperand = operator.getRightHandOperand();
        if (!this.isRealType(leftOperand) && !this.isRealType(rightOperand) || this.isNotPrimitiveNumericType(leftOperand) && this.isNotPrimitiveNumericType(rightOperand) || this.isAnnotated("Test") || this.isInTestOrAssertMethod() || this.isArgumentOfTestOrAssertMethod(operator) || this.isZeroLiteral(leftOperand) && this.isIntType(rightOperand) || this.isIntType(leftOperand) && this.isZeroLiteral(rightOperand) || this.isIntegerNumberCheck(operator) || RulesUtils.equals((CtElement)leftOperand, (CtElement)rightOperand) || this.isMultiplyInfinityCheck(operator) || this.isSameExpressionWithIntRealCast(operator) || this.isNanOrInfinityCheck(operator) || this.isUseMathRoundingMethods(operator) || this.isEqualToSignedLiteral(operator) || this.isComparingWithFinalVariable(operator)) {
            return;
        }
        this.addOrMergeWarnings(operator);
    }

    private void addOrMergeWarnings(@NotNull CtBinaryOperator<?> operator) {
        WarningPosition position = RulesUtils.getPosition(operator, this.getModule());
        if (position != WarningPosition.INVALID_POSITION) {
            Set V6096WarningsAddedOnSameLine = this.getAnalyzer().getWarnings().stream().filter(warning -> warning.code.equals(this.getName())).filter(warning -> warning.getFirstPosition().isPresent()).filter(warning -> warning.getFirstPosition().get().isOnSameLine(position)).collect(Collectors.toSet());
            if (V6096WarningsAddedOnSameLine.size() != 1) {
                this.rule.add((CtElement)operator, operator.getKind() == BinaryOperatorKind.EQ ? "<" : ">");
            } else {
                new WarningAdapter((Warning)new ArrayList(V6096WarningsAddedOnSameLine).get(0)).addSourcePosition((CtElement)operator, this.getModule());
            }
        }
    }

    private boolean isMultiplyInfinityCheck(CtBinaryOperator<?> operatorEquality) {
        boolean leftMultiplyOperandIsLiteral;
        boolean isRightMultiply;
        CtExpression leftOperandEquality = operatorEquality.getLeftHandOperand();
        CtExpression rightOperandEquality = operatorEquality.getRightHandOperand();
        boolean isLeftMultiply = leftOperandEquality instanceof CtBinaryOperator && ((CtBinaryOperator)leftOperandEquality).getKind() == BinaryOperatorKind.MUL;
        boolean bl = isRightMultiply = rightOperandEquality instanceof CtBinaryOperator && ((CtBinaryOperator)rightOperandEquality).getKind() == BinaryOperatorKind.MUL;
        if (!isLeftMultiply && !isRightMultiply) {
            return false;
        }
        CtBinaryOperator multiplyOperator = (CtBinaryOperator)(isLeftMultiply ? leftOperandEquality : rightOperandEquality);
        CtExpression multiplyLeftOperand = multiplyOperator.getLeftHandOperand();
        CtExpression multiplyRightOperand = multiplyOperator.getRightHandOperand();
        if (multiplyLeftOperand instanceof CtLiteral && ((CtLiteral)multiplyLeftOperand).getValue() instanceof Number) {
            leftMultiplyOperandIsLiteral = true;
        } else if (multiplyRightOperand instanceof CtLiteral && ((CtLiteral)multiplyRightOperand).getValue() instanceof Number) {
            leftMultiplyOperandIsLiteral = false;
        } else {
            return false;
        }
        CtExpression multipliedExpression = leftMultiplyOperandIsLiteral ? multiplyRightOperand : multiplyLeftOperand;
        CtExpression expressionWithoutMultiplied = multiplyOperator == leftOperandEquality ? rightOperandEquality : leftOperandEquality;
        return RulesUtils.equals((CtElement)multipliedExpression, (CtElement)expressionWithoutMultiplied);
    }

    private boolean isSameExpressionWithIntRealCast(CtBinaryOperator<?> operator) {
        boolean rightOperandHaveTwoOrMoreCast;
        CtExpression leftHandOperand = operator.getLeftHandOperand();
        CtExpression rightHandOperand = operator.getRightHandOperand();
        boolean leftOperandHaveTwoOrMoreCast = leftHandOperand.getTypeCasts().size() >= 2;
        boolean bl = rightOperandHaveTwoOrMoreCast = rightHandOperand.getTypeCasts().size() >= 2;
        if (!leftOperandHaveTwoOrMoreCast && !rightOperandHaveTwoOrMoreCast) {
            return false;
        }
        CtTypeReference leftLastCast = null;
        CtTypeReference leftPreviousLastCast = null;
        if (leftOperandHaveTwoOrMoreCast) {
            leftLastCast = (CtTypeReference)leftHandOperand.getTypeCasts().get(0);
            leftPreviousLastCast = (CtTypeReference)leftHandOperand.getTypeCasts().get(1);
        }
        CtTypeReference rightLastCast = null;
        CtTypeReference rightPreviousLastCast = null;
        if (rightOperandHaveTwoOrMoreCast) {
            rightLastCast = (CtTypeReference)rightHandOperand.getTypeCasts().get(0);
            rightPreviousLastCast = (CtTypeReference)rightHandOperand.getTypeCasts().get(1);
        }
        return (this.isRealType(leftLastCast) && this.isIntType(leftPreviousLastCast) || this.isRealType(rightLastCast) && this.isIntType(rightPreviousLastCast)) && RulesUtils.equals((CtElement)leftHandOperand, (CtElement)rightHandOperand, Equality.IGNORE_CASTS, new Equality[0]);
    }

    private boolean isNanOrInfinityCheck(CtBinaryOperator<?> operator) {
        return this.isNanOrInfinity(operator.getLeftHandOperand()) || this.isNanOrInfinity(operator.getRightHandOperand());
    }

    private boolean isNanOrInfinity(@Nullable CtExpression<?> expr) {
        if (expr instanceof CtFieldRead) {
            CtFieldRead field = (CtFieldRead)expr;
            String fieldName = field.getVariable().getQualifiedName();
            return this.doubleFieldNames.stream().anyMatch(name -> name.equals(fieldName)) || this.floatFieldNames.stream().anyMatch(name -> name.equals(fieldName));
        }
        return false;
    }

    private boolean isUseMathRoundingMethods(@NotNull CtBinaryOperator<?> operator) {
        CtExpression leftOperand = operator.getLeftHandOperand();
        CtExpression rightOperand = operator.getRightHandOperand();
        return leftOperand instanceof CtInvocation && this.isMathRoundingMethod((CtInvocation)leftOperand) || rightOperand instanceof CtInvocation && this.isMathRoundingMethod((CtInvocation)rightOperand);
    }

    private boolean isMathRoundingMethod(@NotNull CtInvocation<?> invocation) {
        CtExecutableReference executable = invocation.getExecutable();
        if (executable == null) {
            return false;
        }
        CtTypeReference declaringType = executable.getDeclaringType();
        if (declaringType == null) {
            return false;
        }
        String methodName = executable.getSimpleName();
        return declaringType.getQualifiedName().equals("java.lang.Math") && (methodName.equals("round") || methodName.equals("floor") || methodName.equals("rint") || methodName.equals("ceil"));
    }

    private boolean isEqualToSignedLiteral(@NotNull CtBinaryOperator<?> operator) {
        Double variableReadOperandNumber;
        Double numberLiteralValue;
        CtVariable variableReadOperandDeclaration;
        CtExpression leftHandOperand = operator.getLeftHandOperand();
        CtExpression rightHandOperand = operator.getRightHandOperand();
        MutableBoolean literalOperandIsMinusSigned = new MutableBoolean(false);
        if (leftHandOperand instanceof CtVariableRead) {
            variableReadOperandDeclaration = ((CtVariableRead)leftHandOperand).getVariable().getDeclaration();
            numberLiteralValue = this.getNumberLiteralValue(rightHandOperand, literalOperandIsMinusSigned);
        } else if (rightHandOperand instanceof CtVariableRead) {
            variableReadOperandDeclaration = ((CtVariableRead)rightHandOperand).getVariable().getDeclaration();
            numberLiteralValue = this.getNumberLiteralValue(leftHandOperand, literalOperandIsMinusSigned);
        } else {
            return false;
        }
        if (numberLiteralValue == null || variableReadOperandDeclaration == null) {
            return false;
        }
        CtExpression defaultExpression = variableReadOperandDeclaration.getDefaultExpression();
        MutableBoolean variableOperandIsMinusSigned = new MutableBoolean(false);
        CtTypeReference variableReadOperandType = variableReadOperandDeclaration.getType();
        if (defaultExpression != null) {
            variableReadOperandNumber = this.getNumberLiteralValue(defaultExpression, variableOperandIsMinusSigned);
        } else if (variableReadOperandDeclaration instanceof CtField && !variableReadOperandDeclaration.isFinal() && (this.isRealType(variableReadOperandType) || this.isBoxedRealType(variableReadOperandType))) {
            variableReadOperandNumber = 0.0;
        } else {
            return false;
        }
        if (variableReadOperandNumber == null) {
            return false;
        }
        return literalOperandIsMinusSigned.getValue() == variableOperandIsMinusSigned.getValue() && variableReadOperandNumber.equals(numberLiteralValue);
    }

    private boolean isComparingWithFinalVariable(@NotNull CtBinaryOperator<?> operator) {
        CtExpression leftHandOperand = operator.getLeftHandOperand();
        CtExpression rightHandOperand = operator.getRightHandOperand();
        if (!(leftHandOperand instanceof CtVariableRead) || !(rightHandOperand instanceof CtVariableRead)) {
            return false;
        }
        CtVariable leftOperatorVariable = ((CtVariableRead)leftHandOperand).getVariable().getDeclaration();
        CtVariable rightOperatorVariable = ((CtVariableRead)rightHandOperand).getVariable().getDeclaration();
        if (leftOperatorVariable == null || rightOperatorVariable == null || !leftOperatorVariable.isFinal() && !rightOperatorVariable.isFinal()) {
            return false;
        }
        CtExpression leftOperatorVariableDefaultExpression = leftOperatorVariable.getDefaultExpression();
        CtExpression rightOperatorVariableDefaultExpression = rightOperatorVariable.getDefaultExpression();
        return leftOperatorVariableDefaultExpression instanceof CtVariableRead && RulesUtils.equals((CtElement)rightHandOperand, (CtElement)leftOperatorVariableDefaultExpression) || rightOperatorVariableDefaultExpression instanceof CtVariableRead && RulesUtils.equals((CtElement)leftHandOperand, (CtElement)rightOperatorVariableDefaultExpression);
    }

    private boolean isIntegerNumberCheck(@NotNull CtBinaryOperator<?> operator) {
        CtExpression leftHandOperand = operator.getLeftHandOperand();
        CtExpression rightHandOperand = operator.getRightHandOperand();
        List leftTypeCasts = leftHandOperand.getTypeCasts();
        List rightTypeCasts = rightHandOperand.getTypeCasts();
        boolean isIntegerNumberCheckInLeftOperand = leftTypeCasts.size() == 1 && this.isIntType((CtTypeReference)leftTypeCasts.get(0)) && rightTypeCasts.isEmpty() && this.isRealType(rightHandOperand);
        boolean isIntegerNumberCheckInRightOperand = rightTypeCasts.size() == 1 && this.isIntType((CtTypeReference)rightTypeCasts.get(0)) && leftTypeCasts.isEmpty() && this.isRealType(leftHandOperand);
        return (isIntegerNumberCheckInLeftOperand || isIntegerNumberCheckInRightOperand) && RulesUtils.equals((CtElement)leftHandOperand, (CtElement)rightHandOperand, Equality.IGNORE_CASTS, new Equality[0]);
    }

    @Nullable
    private Double getNumberLiteralValue(@Nullable CtExpression<?> expression, @NotNull MutableBoolean isMinusSign) {
        if (expression instanceof CtLiteral) {
            Object literalValue = ((CtLiteral)expression).getValue();
            return literalValue instanceof Number ? Double.valueOf(((Number)literalValue).doubleValue()) : null;
        }
        if (expression instanceof CtUnaryOperator) {
            UnaryOperatorKind kind = ((CtUnaryOperator)expression).getKind();
            CtExpression operand = ((CtUnaryOperator)expression).getOperand();
            if (kind != UnaryOperatorKind.NEG && kind != UnaryOperatorKind.POS || !(operand instanceof CtLiteral)) {
                return null;
            }
            isMinusSign.setValue(kind == UnaryOperatorKind.NEG);
            Object literalValue = ((CtLiteral)operand).getValue();
            return literalValue instanceof Number ? Double.valueOf(((Number)literalValue).doubleValue()) : null;
        }
        return null;
    }

    @Nullable
    private Double getRealTypeLiteralValue(@NotNull CtLiteral<?> literal) {
        Object literalValue = literal.getValue();
        if (literalValue instanceof Double || literalValue instanceof Float) {
            return ((Number)literalValue).doubleValue();
        }
        return null;
    }

    private boolean isZeroLiteral(@Nullable CtExpression<?> expression) {
        if (expression instanceof CtLiteral) {
            Object literalValue = ((CtLiteral)expression).getValue();
            Number expressionValue = literalValue instanceof Number ? (Number)((Number)literalValue) : (Number)null;
            return expressionValue != null && Double.compare(0.0, expressionValue.doubleValue()) == 0;
        }
        return false;
    }

    private boolean isRealType(@Nullable CtExpression<?> expr) {
        return RulesUtils.isRealType(expr) || RulesUtils.isBoxedRealType(expr);
    }

    private boolean isRealType(@Nullable CtTypeReference<?> type) {
        String typeName = RulesUtils.getTypeName(type);
        return typeName.equals("double") || typeName.equals("float");
    }

    private boolean isBoxedRealType(@Nullable CtTypeReference<?> type) {
        String typeName = RulesUtils.getTypeName(type);
        return typeName.equals("java.lang.Double") || typeName.equals("java.lang.Float");
    }

    private boolean isIntType(@Nullable CtTypeReference<?> type) {
        String typeName = RulesUtils.getTypeName(type);
        return typeName.equals("byte") || typeName.equals("short") || typeName.equals("char") || typeName.equals("int") || typeName.equals("long");
    }

    private boolean isIntType(@Nullable CtExpression<?> expr) {
        return RulesUtils.isIntegerType(expr) || RulesUtils.isBoxedIntegerType(expr);
    }

    private boolean isNotPrimitiveNumericType(@Nullable CtExpression<?> expr) {
        return !RulesUtils.isRealType(expr) && !RulesUtils.isIntegerType(expr);
    }

    private boolean isArgumentOfTestOrAssertMethod(@NotNull CtBinaryOperator<?> operator) {
        CtInvocation parentInvocation = RulesUtils.getParentBounded(operator, this.getCurrentMethod(), CtInvocation.class);
        if (parentInvocation == null) {
            return false;
        }
        CtExecutableReference executable = parentInvocation.getExecutable();
        return executable != null && this.isTestMethodName(executable.getSimpleName());
    }

    private boolean isInTestOrAssertMethod() {
        CtExecutable<?> currentMethod = this.getCurrentMethod();
        return currentMethod != null && this.isTestMethodName(currentMethod.getSimpleName());
    }

    private boolean isTestMethodName(@NotNull String methodName) {
        return methodName.startsWith("test") || methodName.contains("Test") || methodName.toLowerCase().contains("assert");
    }
}

