/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6095
extends PvsStudioRule {
    private final PvsStudioRule.Pattern sleepPattern = new PvsStudioRule.PatternBuilder(this).setMessage("'Thread.sleep()' inside synchronized %s may cause decreased performance.").setCwe(821).setSastId("CERT-LCK09-J").setSecId("SEC-SYNCHRONIZATION").build();

    public void visitCtSynchronized(CtSynchronized synchro) {
        CtBlock block = synchro.getBlock();
        if (block == null) {
            return;
        }
        List invocations = block.getElements((Filter)new TypeFilter(CtInvocation.class));
        CtElement bound = synchro.getParent((Filter)new TypeFilter(CtMethod.class));
        CtMethod method = RulesUtils.getParentBounded(synchro.getParent(), bound, CtMethod.class);
        if (method != null && method.hasModifier(ModifierKind.SYNCHRONIZED)) {
            return;
        }
        CtSynchronized ctSynchronized = RulesUtils.getParentBounded(synchro.getParent(), bound, CtSynchronized.class);
        if (ctSynchronized == null) {
            this.applyRule(invocations, (CtElement)synchro, false);
        }
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        for (CtMethod method : ctClass.getMethods()) {
            CtBlock methodBody;
            if (!method.hasModifier(ModifierKind.SYNCHRONIZED) || (methodBody = method.getBody()) == null) continue;
            List invocations = methodBody.getElements((Filter)new TypeFilter(CtInvocation.class));
            this.applyRule(invocations, (CtElement)method, true);
        }
    }

    private void applyRule(List<CtInvocation<?>> invocations, CtElement bound, boolean isMethod) {
        LinkedList sleepInvocations = new LinkedList();
        WarningLevel level = WarningLevel.LEVEL_3;
        for (CtInvocation<?> invocation : invocations) {
            if (!this.isThreadSleep(invocation) || this.isInLambdaOrNewClass((CtElement)invocation, bound)) continue;
            if (level != WarningLevel.LEVEL_2 && RulesUtils.getParentBounded(invocation, bound, CtLoop.class) != null) {
                sleepInvocations.addFirst(invocation);
                level = WarningLevel.LEVEL_2;
                continue;
            }
            sleepInvocations.add(invocation);
        }
        if (sleepInvocations.size() >= 1) {
            WarningAdapter warning = this.sleepPattern.add((CtElement)sleepInvocations.removeFirst(), isMethod ? "method" : "block").setLevel(level);
            for (CtInvocation ctInvocation : sleepInvocations) {
                warning.addSourcePosition((CtElement)ctInvocation, this.getModule());
            }
        }
    }

    private boolean isThreadSleep(CtInvocation<?> ctInvocation) {
        CtExecutableReference executable = ctInvocation.getExecutable();
        if (!Objects.equals(executable.getSimpleName(), "sleep")) {
            return false;
        }
        if (executable.getDeclaringType() == null) {
            return false;
        }
        return Objects.equals(executable.getDeclaringType().getQualifiedName(), "java.lang.Thread");
    }

    private boolean isInLambdaOrNewClass(CtElement element, CtElement bound) {
        CtElement ctLambda = (CtElement)RulesUtils.getParentBounded(element, bound, CtLambda.class);
        CtElement ctInlineClass = (CtElement)RulesUtils.getParentBounded(element, bound, CtNewClass.class);
        return ctLambda != null || ctInlineClass != null;
    }
}

