/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtTypeReference;

public class V6094
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("The expression was implicitly cast from '%s' type to '%s' type. Consider utilizing an explicit type cast to avoid the loss of a fractional part. An example: double A = (double)(X) / Y;.").setLevel(WarningLevel.LEVEL_1).setCwe(682).build();

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (operator.getKind() != BinaryOperatorKind.DIV) {
            return;
        }
        CtExpression leftOperand = operator.getLeftHandOperand();
        CtExpression rightOperand = operator.getRightHandOperand();
        if (this.isNonInteger(leftOperand) || this.isNonInteger(rightOperand)) {
            return;
        }
        CtElement parent = this.getRequiredParent(operator);
        if (!(parent instanceof CtArrayAccess) && !(parent instanceof CtNewArray)) {
            CtAssignment ctAssignment;
            CtTypeReference assignedVariableType;
            if (parent instanceof CtBinaryOperator) {
                String toType;
                CtBinaryOperator binaryOperator = (CtBinaryOperator)parent;
                CtExpression leftHandOperand = binaryOperator.getLeftHandOperand();
                CtExpression rightHandOperand = binaryOperator.getRightHandOperand();
                if (this.isRealType(leftHandOperand)) {
                    toType = RulesUtils.getTypeName(leftHandOperand);
                } else if (this.isRealType(rightHandOperand)) {
                    toType = RulesUtils.getTypeName(rightHandOperand);
                } else {
                    return;
                }
                CtExpression expressionWithDivOperator = leftHandOperand;
                if (leftHandOperand.getElements(e -> e == operator).isEmpty()) {
                    expressionWithDivOperator = rightHandOperand;
                }
                if (!toType.isEmpty()) {
                    this.addWarning(operator, expressionWithDivOperator, toType);
                }
            } else if (parent instanceof CtInvocation) {
                CtInvocation invocation = (CtInvocation)parent;
                List arguments = invocation.getArguments();
                int divOperatorIndex = IntStream.range(0, arguments.size()).filter(i -> !((CtExpression)arguments.get(i)).getElements(e -> e == operator).isEmpty()).findFirst().orElse(-1);
                if (divOperatorIndex == -1) {
                    return;
                }
                CtExecutable methodDeclaration = invocation.getExecutable().getDeclaration();
                if (methodDeclaration == null && (methodDeclaration = invocation.getExecutable().getExecutableDeclaration()) == null) {
                    return;
                }
                List methodParameters = methodDeclaration.getParameters();
                if (methodParameters.isEmpty()) {
                    return;
                }
                CtTypeReference methodParameterType = divOperatorIndex >= methodParameters.size() && ((CtParameter)methodParameters.get(methodParameters.size() - 1)).isVarArgs() ? ((CtParameter)methodParameters.get(methodParameters.size() - 1)).getType() : ((CtParameter)methodParameters.get(divOperatorIndex)).getType();
                if (this.isRealType(methodParameterType)) {
                    WarningAdapter warning = this.addWarning(operator, (CtExpression)arguments.get(divOperatorIndex), RulesUtils.getTypeName(methodParameterType));
                    if (methodDeclaration.getSimpleName().equals("floor") && invocation.getExecutable().getDeclaringType().getQualifiedName().equals("java.lang.Math")) {
                        warning.setLevel(WarningLevel.LEVEL_3);
                    }
                }
            } else if (parent instanceof CtVariable) {
                CtVariable variable = (CtVariable)parent;
                CtTypeReference variableType = variable.getType();
                if (this.isRealType(variableType)) {
                    this.addWarning(operator, variable.getDefaultExpression(), RulesUtils.getTypeName(variableType));
                }
            } else if (parent instanceof CtReturn) {
                CtTypeReference<?> returnType;
                CtReturn ctReturn = (CtReturn)parent;
                CtExecutable<?> currentMethod = this.getCurrentMethod();
                CtMethod method = RulesUtils.getParentBounded((CtElement)ctReturn, currentMethod, CtMethod.class);
                CtLambda lambda = RulesUtils.getParentBounded((CtElement)ctReturn, currentMethod, CtLambda.class);
                if (method != null) {
                    returnType = method.getType();
                } else if (lambda != null) {
                    returnType = this.getLambdaReturnType(lambda);
                } else {
                    return;
                }
                if (this.isRealType(returnType)) {
                    this.addWarning(operator, ctReturn.getReturnedExpression(), RulesUtils.getTypeName(returnType));
                }
            } else if (parent instanceof CtLambda) {
                CtLambda lambda = (CtLambda)parent;
                CtTypeReference<?> lambdaReturnType = this.getLambdaReturnType(lambda);
                if (this.isRealType(lambdaReturnType)) {
                    this.addWarning(operator, lambda.getExpression(), RulesUtils.getTypeName(lambdaReturnType));
                }
            } else if (parent instanceof CtAssignment && this.isRealType(assignedVariableType = (ctAssignment = (CtAssignment)parent).getAssigned().getType())) {
                this.addWarning(operator, ctAssignment.getAssignment(), RulesUtils.getTypeName(assignedVariableType));
            }
        }
    }

    @Nullable
    private CtTypeReference<?> getLambdaReturnType(@NotNull CtLambda<?> lambda) {
        CtTypeReference type = ((CtTypedElement)lambda.getParent()).getType();
        CtType functionalInterface = type.getTypeDeclaration();
        Optional<CtMethod> lambdaMethod = functionalInterface.getMethods().stream().filter(m -> !m.isFinal() && !m.isStatic() && !m.isDefaultMethod()).findFirst();
        if (!lambdaMethod.isPresent()) {
            return null;
        }
        String lambdaReturnTypeName = lambdaMethod.get().getType().getQualifiedName();
        List interfaceParameters = functionalInterface.getFormalCtTypeParameters();
        int lambdaReturnTypeIndex = IntStream.range(0, interfaceParameters.size()).filter(i -> ((CtTypeParameter)interfaceParameters.get(i)).getQualifiedName().equals(lambdaReturnTypeName)).findFirst().orElse(-1);
        if (lambdaReturnTypeIndex != -1) {
            return (CtTypeReference)type.getActualTypeArguments().get(lambdaReturnTypeIndex);
        }
        return null;
    }

    private WarningAdapter addWarning(@NotNull CtBinaryOperator<?> operator, @NotNull CtExpression<?> expression, @NotNull String toType) {
        String fromType = RulesUtils.getTypeName(operator.getType());
        if (operator == expression) {
            return this.rule.add((CtElement)operator, fromType, toType);
        }
        return this.rule.add((CtElement)expression, fromType, toType).addSourcePosition((CtElement)operator, this.getModule());
    }

    @Nullable
    private CtElement getRequiredParent(@NotNull CtBinaryOperator<?> element) {
        for (CtElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof CtArrayAccess) && !(parent instanceof CtNewArray) && !(parent instanceof CtInvocation) && !(parent instanceof CtVariable) && !(parent instanceof CtReturn) && !(parent instanceof CtLambda) && !this.isAssignment(parent) && !this.isBinaryOperator(parent)) continue;
            return parent;
        }
        return null;
    }

    private boolean isAssignment(CtElement parent) {
        if (!(parent instanceof CtAssignment)) {
            return false;
        }
        if (parent instanceof CtOperatorAssignment) {
            BinaryOperatorKind kind = ((CtOperatorAssignment)parent).getKind();
            return kind == BinaryOperatorKind.PLUS || kind == BinaryOperatorKind.MINUS || kind == BinaryOperatorKind.MUL || kind == BinaryOperatorKind.DIV;
        }
        return true;
    }

    private boolean isBinaryOperator(CtElement parent) {
        if (!(parent instanceof CtBinaryOperator)) {
            return false;
        }
        BinaryOperatorKind kind = ((CtBinaryOperator)parent).getKind();
        return kind == BinaryOperatorKind.LT || kind == BinaryOperatorKind.LE || kind == BinaryOperatorKind.GT || kind == BinaryOperatorKind.GE || kind == BinaryOperatorKind.EQ || kind == BinaryOperatorKind.NE;
    }

    private boolean isNonInteger(@Nullable CtExpression<?> expr) {
        return !RulesUtils.isIntegerType(expr) && !RulesUtils.isBoxedIntegerType(expr);
    }

    private boolean isRealType(@Nullable CtTypeReference<?> type) {
        String typeName = RulesUtils.getTypeName(type);
        return typeName.equals("double") || typeName.equals("float") || typeName.equals("java.lang.Double") || typeName.equals("java.lang.Float");
    }

    private boolean isRealType(@Nullable CtExpression<?> expr) {
        return RulesUtils.isRealType(expr) || RulesUtils.isBoxedRealType(expr);
    }
}

