/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.PointerVirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;

public class V6093
extends PvsStudioRule {
    private static final TypeFactory TYPE_FACTORY = new TypeFactory();
    private final PvsStudioRule.Pattern variablePattern = new PvsStudioRule.PatternBuilder(this).setMessage("Automatic unboxing of the '%s' variable %s cause NullPointerException.").setCwe(476).setSastId("CERT-EXP01-J").setSecId("SEC-NULL").build();
    private final PvsStudioRule.Pattern literalPattern = new PvsStudioRule.PatternBuilder(this).setMessage("Automatic unboxing of 'null' literal will cause NullPointerException.").setLevel(WarningLevel.LEVEL_1).setSastId("CERT-EXP01-J").setSecId("SEC-NULL").build();

    private void warn(PointerVirtualValue value, CtVariableAccess<?> variableAccess) {
        String strength = value.isNullPointer() ? "will" : "may";
        this.variablePattern.add((CtElement)variableAccess, variableAccess.getVariable().getSimpleName(), strength).setLevel(value.isNullPointer() ? WarningLevel.LEVEL_1 : WarningLevel.LEVEL_3);
    }

    private CtExpression<?> extractCondition(CtElement element) {
        if (element instanceof CtIf) {
            return ((CtIf)element).getCondition();
        }
        if (element instanceof CtConditional) {
            return ((CtConditional)element).getCondition();
        }
        if (element instanceof CtWhile) {
            return ((CtWhile)element).getLoopingExpression();
        }
        if (element instanceof CtFor) {
            return ((CtFor)element).getExpression();
        }
        if (element instanceof CtDo) {
            return ((CtDo)element).getLoopingExpression();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean willBeUnboxed(CtExpression<?> expression) {
        CtElement parent = expression.getParent();
        CtTypeReference targetType = null;
        if (expression.getRoleInParent() == CtRole.DIMENSION) {
            targetType = V6093.TYPE_FACTORY.INTEGER_PRIMITIVE;
        } else if (parent instanceof CtBinaryOperator) {
            CtBinaryOperator operator = (CtBinaryOperator)parent;
            BinaryOperatorKind kind = operator.getKind();
            if (kind == BinaryOperatorKind.INSTANCEOF) {
                return false;
            }
            if (kind == BinaryOperatorKind.EQ || kind == BinaryOperatorKind.NE) {
                CtExpression otherOperand;
                CtExpression ctExpression = otherOperand = operator.getLeftHandOperand() == expression ? operator.getRightHandOperand() : operator.getLeftHandOperand();
                if (!otherOperand.getType().isPrimitive()) {
                    return false;
                }
            }
            targetType = operator.getType();
        } else if (parent instanceof CtAbstractInvocation) {
            CtAbstractInvocation invocation = (CtAbstractInvocation)parent;
            List parameters = invocation.getExecutable().getParameters();
            if (parameters.isEmpty()) {
                return false;
            }
            int index = invocation.getArguments().indexOf(expression);
            if (index < 0) {
                return false;
            }
            if (index >= parameters.size()) {
                index = parameters.size() - 1;
                targetType = (CtTypeReference)parameters.get(index);
                if (!(targetType instanceof CtArrayTypeReference)) return false;
                targetType = ((CtArrayTypeReference)targetType).getArrayType();
            } else {
                targetType = (CtTypeReference)parameters.get(index);
            }
        } else if (parent instanceof CtReturn) {
            targetType = ((CtExecutable)parent.getParent(CtExecutable.class)).getType();
        } else if (parent instanceof CtTypedElement) {
            targetType = ((CtTypedElement)parent).getType();
        }
        if (targetType == null) return false;
        if (!targetType.isPrimitive()) return false;
        return true;
    }

    public <R> void visitCtBlock(CtBlock<R> block) {
        if (block.getRoleInParent() != CtRole.BODY || !(block.getParent() instanceof CtExecutable)) {
            return;
        }
        new CtScanner(){
            private final Set<CtVariable<?>> visitedVariables = Collections.newSetFromMap(new IdentityHashMap());

            public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
                super.visitCtVariableRead(variableRead);
                PointerVirtualValue value = V6093.this.getValue((CtElement)variableRead).toPointer();
                if (value == null || !value.isNullPointer() && !value.isPotentialNullPointer()) {
                    return;
                }
                CtElement parent = variableRead.getParent();
                if (parent instanceof CtUnaryOperator || V6093.this.extractCondition(parent) == variableRead) {
                    if (this.visitedVariables.add(variableRead.getVariable().getDeclaration())) {
                        V6093.this.warn(value, (CtVariableAccess<?>)variableRead);
                    }
                    return;
                }
                if (variableRead.getType() == null || variableRead.getType().unbox() == variableRead.getType()) {
                    return;
                }
                if (V6093.this.willBeUnboxed((CtExpression<?>)variableRead) && this.visitedVariables.add(variableRead.getVariable().getDeclaration())) {
                    V6093.this.warn(value, (CtVariableAccess<?>)variableRead);
                }
            }
        }.scan(block);
    }

    public <T> void visitCtConditional(CtConditional<T> conditional) {
        CtExpression nullExpression = conditional.getThenExpression();
        if (!RulesUtils.isNullLiteral((CtElement)nullExpression) && !RulesUtils.isNullLiteral((CtElement)(nullExpression = conditional.getElseExpression()))) {
            return;
        }
        if (!this.willBeUnboxed((CtExpression<?>)conditional)) {
            return;
        }
        this.literalPattern.add((CtElement)nullExpression, new Object[0]);
    }
}

