/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.Box;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.HashSet;
import java.util.List;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6092
extends PvsStudioRule {
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder(this).setMessage("The resource is returned from try-with-resources statement. It will be closed before the method exits.").setLevel(WarningLevel.LEVEL_1).build();

    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        List resources = tryWithResource.getResources();
        if (resources.isEmpty()) {
            return;
        }
        CtBlock block = tryWithResource.getBody();
        HashSet<CtVariable> leakedResources = new HashSet<CtVariable>();
        for (CtReturn returnStatement : block.getElements((Filter)new TypeFilter(CtReturn.class))) {
            Box<CtLocalVariable> variable = Box.ofNullable(returnStatement.getReturnedExpression()).safeCast(CtVariableRead.class).map(CtVariableAccess::getVariable).map(CtVariableReference::getDeclaration).safeCast(CtLocalVariable.class).filter(it -> resources.contains(it) && !leakedResources.contains(it));
            if (!variable.isPresent() || RulesUtils.getParentBounded((CtElement)returnStatement, (CtElement)block, CtLambda.class) != null || RulesUtils.getParentBounded((CtElement)returnStatement, (CtElement)block, CtNewClass.class) != null) continue;
            leakedResources.add((CtVariable)variable.get());
            this.pattern.add((CtElement)returnStatement, new Object[0]).addSourcePosition((CtElement)variable.get(), this.getModule());
        }
    }
}

