/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.Box;
import com.pvsstudio.Lazy;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;

public class V6091
extends PvsStudioRule {
    private final PvsStudioRule.Pattern suspiciousGetter = new PvsStudioRule.PatternBuilder().setMessage("Suspicious getter implementation. The '%s' field should probably be returned instead.").build();
    private final PvsStudioRule.Pattern suspiciousSetter = new PvsStudioRule.PatternBuilder().setMessage("Suspicious setter implementation. The '%s' field should probably be assigned instead.").build();

    private Map<String, CtField<?>> extractFields(CtClass<?> ctClass) {
        return ctClass.getFields().stream().filter(it -> !it.isStatic()).filter(it -> !RulesUtils.isAnnotated((CtElement)it, "java.lang.Deprecated")).collect(Collectors.toMap(CtNamedElement::getSimpleName, Function.identity()));
    }

    private boolean equalsIgnoringCapitalization(String first, String second) {
        if (first.isEmpty() && second.isEmpty()) {
            return true;
        }
        return first.length() == second.length() && Character.toLowerCase(first.charAt(0)) == Character.toLowerCase(second.charAt(0)) && first.regionMatches(1, second, 1, first.length() - 1);
    }

    private boolean isSameField(String targetField, String referencedField) {
        return this.equalsIgnoringCapitalization(targetField, referencedField) || StringUtils.startsWithIgnoreCase((CharSequence)referencedField, (CharSequence)targetField) || StringUtils.endsWithIgnoreCase((CharSequence)referencedField, (CharSequence)targetField);
    }

    private CtField<?> findFieldByName(Map<String, CtField<?>> cache, String name) {
        CtField<?> field = cache.get(StringUtils.uncapitalize((String)name));
        if (field == null) {
            field = cache.get(StringUtils.capitalize((String)name));
        }
        if (field == null) {
            field = cache.get("m_" + StringUtils.uncapitalize((String)name));
        }
        if (field == null) {
            field = cache.get("m" + StringUtils.capitalize((String)name));
        }
        return field;
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        Lazy<Map> lazyFields = new Lazy<Map>(() -> this.extractFields(ctClass));
        HashMap<CtMethod, MethodToken> methods = new HashMap<CtMethod, MethodToken>();
        HashMap<CtField, Set> getters = new HashMap<CtField, Set>();
        HashMap setters = new HashMap();
        for (CtMethod ctMethod : ctClass.getMethods()) {
            Box<CtField> referencedField;
            Box<CtFieldAccess> fieldAccess;
            List statements;
            if (ctMethod.isStatic() || ctMethod.getBody() == null || (statements = ctMethod.getBody().getStatements()).size() != 1) continue;
            String methodName = ctMethod.getSimpleName();
            boolean isGetter = StringUtils.startsWithIgnoreCase((CharSequence)methodName, (CharSequence)"get");
            if (isGetter || StringUtils.startsWithIgnoreCase((CharSequence)methodName, (CharSequence)"set")) {
                methodName = methodName.substring(3);
            } else {
                if (!StringUtils.startsWithIgnoreCase((CharSequence)methodName, (CharSequence)"is")) continue;
                isGetter = true;
                methodName = methodName.substring(2);
            }
            if (methodName.isEmpty()) continue;
            if (isGetter) {
                if (!ctMethod.getParameters().isEmpty()) continue;
                fieldAccess = Box.of((CtStatement)statements.get(0)).safeCast(CtReturn.class).map(CtReturn::getReturnedExpression).safeCast(CtFieldRead.class).map(it -> it);
            } else {
                if (ctMethod.getParameters().size() != 1) continue;
                fieldAccess = Box.of((CtStatement)statements.get(0)).safeCast(CtAssignment.class).map(CtAssignment::getAssigned).safeCast(CtFieldWrite.class).map(it -> it);
            }
            if (!(referencedField = fieldAccess.filter(it -> it.getTarget() instanceof CtThisAccess).map(CtFieldAccess::getVariable).map(CtFieldReference::getFieldDeclaration)).isPresent()) continue;
            MethodToken token = new MethodToken();
            token.field = referencedField.get();
            token.isGetter = isGetter;
            token.rawTargetName = methodName;
            methods.put(ctMethod, token);
            HashMap<CtField, Set> category = isGetter ? getters : setters;
            category.computeIfAbsent(token.field, it -> new HashSet()).add(ctMethod);
        }
        for (Map.Entry entry : methods.entrySet()) {
            HashMap otherCategory;
            CtTypeReference parameterType;
            CtMethod method = (CtMethod)entry.getKey();
            MethodToken token = (MethodToken)entry.getValue();
            String targetFieldName = token.rawTargetName;
            String referencedFieldName = token.field.getSimpleName();
            if (this.isSameField(targetFieldName, referencedFieldName)) continue;
            CtField targetField = this.findFieldByName(lazyFields.get(), targetFieldName);
            if (targetField == null) {
                if (method.getSimpleName().startsWith("is")) {
                    targetField = (CtField)lazyFields.get().get(method.getSimpleName());
                }
                if (targetField == null) continue;
            }
            if (token.isGetter ? !targetField.getType().isSubtypeOf(method.getType()) : targetField.isFinal() || !(parameterType = ((CtParameter)method.getParameters().get(0)).getType()).isSubtypeOf(targetField.getType())) continue;
            WarningLevel level = WarningLevel.LEVEL_2;
            HashMap<CtField, Set> currentCategory = token.isGetter ? getters : setters;
            HashMap<Object, Object> hashMap = otherCategory = token.isGetter ? setters : getters;
            if (((Set)currentCategory.get(token.field)).size() > 1) {
                level = level.increase();
            } else {
                Optional<MethodToken> inverseMethod = otherCategory.values().stream().flatMap(Collection::stream).map(methods::get).filter(it -> Objects.equals(it.rawTargetName, token.rawTargetName)).findAny();
                if (inverseMethod.isPresent()) {
                    level = inverseMethod.get().field == token.field ? level.decrease() : level.increase();
                }
            }
            PvsStudioRule.Pattern pattern = token.isGetter ? this.suspiciousGetter : this.suspiciousSetter;
            pattern.add((CtElement)method, targetField.getSimpleName()).addSourcePosition((CtElement)targetField, this.getModule()).setLevel(level);
        }
    }

    private static class MethodToken {
        public CtField<?> field;
        public boolean isGetter;
        public String rawTargetName;

        private MethodToken() {
        }
    }
}

