/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.Box;
import com.pvsstudio.Lazy;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtType;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6090
extends PvsStudioRule {
    private static final Set<String> NON_SUPPRESSED_ANNOTATIONS = new HashSet<String>(Arrays.asList("org.springframework.beans.factory.annotation.Autowired", "java.lang.Deprecated", "java.lang.SuppressWarnings", "javax.inject.Inject"));
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder(this).setMessage("Field '%s' is being used before it was initialized.").setCwe(665).build();

    private boolean suppressFieldByAnnotations(List<CtAnnotation<?>> annotations) {
        return !annotations.isEmpty() && annotations.stream().map(it -> it.getAnnotationType().getQualifiedName()).anyMatch(it -> !NON_SUPPRESSED_ANNOTATIONS.contains(it));
    }

    private Set<CtField<?>> getPossiblyInitializedBySuperConstructorFields(CtClass<?> ctClass) {
        return ctClass.getMethods().stream().filter(it -> !it.isPrivate() && !it.getTopDefinitions().isEmpty()).flatMap(it -> it.getElements((Filter)new TypeFilter(CtFieldWrite.class)).stream()).map(it -> it.getVariable().getFieldDeclaration()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void processConstructor(CtConstructor<?> constructor, final Function<CtField<?>, Boolean> fieldFilter) {
        final CtType currentType = constructor.getDeclaringType();
        if (currentType == null || constructor.getBody() == null) {
            return;
        }
        List children = constructor.getBody().getDirectChildren();
        if (children.size() <= 1) {
            return;
        }
        boolean thisConstructorCall = Box.of((CtElement)children.get(0)).safeCast(CtInvocation.class).map(CtAbstractInvocation::getExecutable).filter(it -> Objects.equals(it.getSimpleName(), "<init>")).map(CtExecutableReference::getDeclaringType).map(CtTypeReference::getTypeDeclaration).filter(it -> it == currentType).isPresent();
        if (thisConstructorCall) {
            return;
        }
        new EarlyTerminatingScanner<Void>(){
            private final Set<CtField<?>> processedFields = new HashSet();
            private int nestedLoopCounter = 0;

            public void visitCtFor(CtFor forLoop) {
                ++this.nestedLoopCounter;
                super.visitCtFor(forLoop);
                --this.nestedLoopCounter;
            }

            public void visitCtForEach(CtForEach foreach) {
                ++this.nestedLoopCounter;
                super.visitCtForEach(foreach);
                --this.nestedLoopCounter;
            }

            public void visitCtWhile(CtWhile whileLoop) {
                ++this.nestedLoopCounter;
                super.visitCtWhile(whileLoop);
                --this.nestedLoopCounter;
            }

            public void visitCtDo(CtDo doLoop) {
                ++this.nestedLoopCounter;
                this.enter((CtElement)doLoop);
                this.scan(CtRole.ANNOTATION, doLoop.getAnnotations());
                this.scan(CtRole.BODY, (CtElement)doLoop.getBody());
                this.scan(CtRole.EXPRESSION, (CtElement)doLoop.getLoopingExpression());
                this.scan(CtRole.COMMENT, doLoop.getComments());
                this.exit((CtElement)doLoop);
                --this.nestedLoopCounter;
            }

            public <R> void visitCtNewClass(CtNewClass<R> newClass) {
            }

            public <R> void visitCtLambda(CtLambda<R> lambda) {
            }

            public <R> void visitCtFieldRead(CtFieldRead<R> fieldRead) {
                super.visitCtFieldRead(fieldRead);
                CtField field = fieldRead.getVariable().getFieldDeclaration();
                if (field == null || !this.processedFields.add(field)) {
                    return;
                }
                if (field.getType().isPrimitive() || field.isStatic() || field.getDeclaringType() != currentType || field.getDefaultExpression() != null || !(fieldRead.getTarget() instanceof CtThisAccess) || V6090.this.suppressFieldByAnnotations(field.getAnnotations())) {
                    return;
                }
                WarningLevel level = WarningLevel.LEVEL_1;
                boolean isComparisonOperand = Box.of(fieldRead.getParent()).safeCast(CtBinaryOperator.class).map(CtBinaryOperator::getKind).filter(it -> it == BinaryOperatorKind.EQ || it == BinaryOperatorKind.NE).isPresent();
                if (isComparisonOperand) {
                    if (this.nestedLoopCounter > 0) {
                        return;
                    }
                    level = WarningLevel.LEVEL_2;
                }
                if (!((Boolean)fieldFilter.apply(field)).booleanValue()) {
                    level = WarningLevel.LEVEL_3;
                }
                V6090.this.pattern.add((CtElement)fieldRead, field.getSimpleName()).setLevel(level);
            }

            public <R> void visitCtFieldWrite(CtFieldWrite<R> fieldWrite) {
                super.visitCtFieldWrite(fieldWrite);
                this.processedFields.add(fieldWrite.getVariable().getFieldDeclaration());
            }

            public <R> void visitCtInvocation(CtInvocation<R> invocation) {
                block5: {
                    block4: {
                        super.visitCtInvocation(invocation);
                        if (V6090.this.getMethodAnnotation((CtAbstractInvocation<?>)invocation).getPure()) {
                            return;
                        }
                        if (invocation.getTarget() instanceof CtThisAccess) break block4;
                        if (!invocation.getArguments().stream().anyMatch(CtThisAccess.class::isInstance)) break block5;
                    }
                    this.terminate();
                }
            }
        }.scan(constructor);
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        Lazy<Collection> possiblyInitializedFields = new Lazy<Collection>(() -> this.getPossiblyInitializedBySuperConstructorFields(ctClass));
        for (CtConstructor constructor : ctClass.getConstructors()) {
            this.processConstructor(constructor, it -> !((Collection)possiblyInitializedFields.get()).contains(it));
        }
    }
}

