/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.Box;
import com.pvsstudio.rules.PvsStudioRule;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;

public class V6089
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("It's possible that the line was commented out improperly, thus altering the program's operation logics.").setCwe(670).setSastId("CERT-EXP52-J").build();

    public void visitCtIf(CtIf ctIf) {
        int line2;
        int column2;
        Box<CtStatement> suspiciousStmt = Box.of(ctIf).filter(it -> it.getElseStatement() == null).map(CtIf::getThenStatement).safeCast(CtStatementList.class).filter(CtElement::isImplicit).filter(it -> it.getStatements().size() == 1).map(CtStatementList::getLastStatement);
        if (suspiciousStmt.isEmpty()) {
            return;
        }
        SourcePosition posIf = ctIf.getPosition();
        SourcePosition posCondition = ctIf.getCondition().getPosition();
        SourcePosition posSuspiciousElement = suspiciousStmt.get().getPosition();
        if (!(posCondition.isValidPosition() && posSuspiciousElement.isValidPosition() && posIf.isValidPosition())) {
            return;
        }
        int column1 = posIf.getColumn();
        if (column1 != (column2 = posSuspiciousElement.getColumn())) {
            return;
        }
        int line1 = posCondition.getEndLine();
        if (line1 == (line2 = posSuspiciousElement.getLine()) || line1 + 1 == line2) {
            return;
        }
        List<String> comments = this.getModule().getLines(posCondition.getFile(), line1 + 1, line2 - 1);
        boolean commentStarted = false;
        for (String line : comments) {
            if (StringUtils.indexOfAny((CharSequence)line, (CharSequence[])new CharSequence[]{"//", "/*"}) != -1) {
                commentStarted = true;
            }
            if (!commentStarted || StringUtils.indexOfAny((CharSequence)line, (CharSequence[])new CharSequence[]{";", "(", "=", "{"}) == -1) continue;
            this.rule.add((CtElement)ctIf, new Object[0]);
            return;
        }
    }
}

