/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Objects;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtReturn;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;

public class V6088
extends PvsStudioRule {
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder(this).setMessage("Result of this expression will be implicitly cast to '%s'. Check if program logic handles it correctly.").setLevel(WarningLevel.LEVEL_2).build();

    private String getNumberType(CtExpression<?> expression) {
        CtType<?> type = this.getType(expression);
        if (type == null) {
            return null;
        }
        CtTypeReference typeReference = type.getReference().box();
        switch (typeReference.getQualifiedName()) {
            case "java.lang.Byte": 
            case "java.lang.Character": 
            case "java.lang.Short": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Float": 
            case "java.lang.Double": {
                return typeReference.getQualifiedName();
            }
        }
        return null;
    }

    public <T> void visitCtConditional(CtConditional<T> conditional) {
        if (this.getNumberType((CtExpression<?>)conditional) == null) {
            return;
        }
        String thenType = this.getNumberType(conditional.getThenExpression());
        if (thenType == null) {
            return;
        }
        String elseType = this.getNumberType(conditional.getElseExpression());
        if (elseType == null) {
            return;
        }
        if (Objects.equals(thenType, elseType)) {
            return;
        }
        CtTypeReference targetType = null;
        CtElement parent = conditional.getParent();
        if (conditional.getRoleInParent() == CtRole.ARGUMENT) {
            CtExecutable declaration;
            CtAbstractInvocation invocation = (CtAbstractInvocation)conditional.getParent(CtAbstractInvocation.class);
            List arguments = invocation.getArguments();
            int index = -1;
            for (int i = 0; i < arguments.size(); ++i) {
                if (arguments.get(i) != conditional) continue;
                index = i;
                break;
            }
            if ((declaration = invocation.getExecutable().getExecutableDeclaration()) == null) {
                return;
            }
            List parameters = declaration.getParameters();
            CtParameter parameter = index >= parameters.size() ? (CtParameter)parameters.get(parameters.size() - 1) : (CtParameter)parameters.get(index);
            targetType = parameter.getType();
        } else if (parent instanceof CtReturn) {
            targetType = ((CtExecutable)parent.getParent(CtExecutable.class)).getType();
        } else if (parent instanceof CtLocalVariable) {
            targetType = ((CtLocalVariable)parent).getType();
        } else if (parent instanceof CtAssignment) {
            targetType = ((CtAssignment)parent).getAssigned().getType();
        }
        if (targetType == null) {
            return;
        }
        String fullName = targetType.getQualifiedName();
        if (!Objects.equals(fullName, "java.lang.Object") && !Objects.equals(fullName, "java.lang.Number")) {
            return;
        }
        this.pattern.add((CtElement)conditional, RulesUtils.getTypeName(conditional));
    }
}

