/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtTypeReference;

public class V6087
extends PvsStudioRule {
    private final PvsStudioRule.Pattern ruleExternalizable = new PvsStudioRule.PatternBuilder().setMessage("InvalidClassException may occur during deserialization. Externalizable class '%s' is missing a public no-arg constructor.").build();
    private final PvsStudioRule.Pattern ruleSerializable = new PvsStudioRule.PatternBuilder().setMessage("InvalidClassException may occur during deserialization. Non-serializable ancestor '%s' is missing an accessible no-arg constructor.").build();
    private static final CtTypeReference<?> EXTERNALIZABLE_REFERENCE = new TypeFactory().createReference("java.io.Externalizable");
    private static final CtTypeReference<?> SERIALIZABLE_REFERENCE = new TypeFactory().createReference("java.io.Serializable");
    private static final int VIEWING_DEPTH = 5;

    @Nullable
    private WarningLevel applyRuleForExternalizable(@NotNull CtClass<?> ctClass, int depth) {
        CtType type;
        if (ctClass.getSuperInterfaces().stream().anyMatch(i -> i.getQualifiedName().equals("java.io.Externalizable"))) {
            return this.getLevelForDepth(depth);
        }
        if (depth > 5) {
            return null;
        }
        CtType ctType = type = ctClass.getSuperclass() != null ? ctClass.getSuperclass().getTypeDeclaration() : null;
        if (!(type instanceof CtClass)) {
            return null;
        }
        return this.applyRuleForExternalizable((CtClass)type, depth + 1);
    }

    @Nullable
    private Pair<CtType<?>, WarningLevel> applyRuleForSerializable(@NotNull CtClass<?> clazz, int depth) {
        if (clazz.getSuperclass() == null) {
            return null;
        }
        if (clazz.getSuperInterfaces().stream().noneMatch(i -> i.getQualifiedName().equals("java.io.Serializable"))) {
            if (depth > 5) {
                return null;
            }
            CtType type = clazz.getSuperclass().getTypeDeclaration();
            if (!(type instanceof CtClass)) {
                return null;
            }
            return this.applyRuleForSerializable((CtClass)type, depth + 1);
        }
        List<CtTypeReference<?>> allSuperClasses = this.getTypes().getAllExtendedClasses(clazz.getReference());
        for (CtClass ctClass : allSuperClasses.stream().filter(reference -> reference.getTypeDeclaration() instanceof CtClass).map(reference -> (CtClass)reference.getTypeDeclaration()).collect(Collectors.toList())) {
            if (ctClass.getConstructors().stream().filter(ctr -> ctr.getParameters().isEmpty()).anyMatch(ctr -> !ctr.isPrivate())) continue;
            if (ctClass.isSubtypeOf(SERIALIZABLE_REFERENCE)) {
                return null;
            }
            return Pair.of((Object)ctClass, (Object)((Object)this.getLevelForDepth(depth)));
        }
        return null;
    }

    private WarningLevel getLevelForDepth(int depth) {
        switch (depth) {
            case 1: {
                return WarningLevel.LEVEL_1;
            }
            case 2: 
            case 3: {
                return WarningLevel.LEVEL_2;
            }
        }
        return WarningLevel.LEVEL_3;
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        WarningLevel level;
        if (ctClass.isAnonymous()) {
            return;
        }
        if (ctClass.getConstructors().stream().noneMatch(arg -> arg.isPublic() && arg.getParameters().isEmpty()) && (level = this.applyRuleForExternalizable(ctClass, 1)) != null) {
            this.ruleExternalizable.add((CtElement)ctClass, ctClass.getSimpleName()).setLevel(level);
            return;
        }
        if (ctClass.getSuperclass() == null) {
            return;
        }
        Pair<CtType<?>, WarningLevel> nonSerializableSuperClass = this.applyRuleForSerializable(ctClass, 1);
        if (nonSerializableSuperClass != null) {
            if (ctClass.isSubtypeOf(EXTERNALIZABLE_REFERENCE)) {
                return;
            }
            WarningAdapter warning = this.ruleSerializable.add((CtElement)ctClass, ((CtType)nonSerializableSuperClass.getLeft()).getSimpleName()).setLevel((WarningLevel)((Object)nonSerializableSuperClass.getRight()));
            if (((CtType)nonSerializableSuperClass.getLeft()).getPosition().isValidPosition()) {
                warning.addSourcePosition((CtElement)nonSerializableSuperClass.getLeft(), this.getModule());
            }
        }
    }
}

