/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;

public class V6086
extends PvsStudioRule {
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder(this).setMessage("Suspicious code formatting. 'else' keyword is probably missing.").setCwe(670).build();

    public void visitCtIf(CtIf ifStatement) {
        if (!(ifStatement.getParent() instanceof CtBlock)) {
            return;
        }
        SourcePosition currentPosition = ifStatement.getPosition();
        if (!currentPosition.isValidPosition()) {
            return;
        }
        List statements = ((CtBlock)ifStatement.getParent()).getStatements();
        int index = -1;
        for (int i = 0; i < statements.size(); ++i) {
            if (statements.get(i) != ifStatement) continue;
            index = i;
            break;
        }
        if (index < 1) {
            return;
        }
        CtStatement previousStatement = (CtStatement)statements.get(index - 1);
        if (!(previousStatement instanceof CtIf)) {
            return;
        }
        SourcePosition previousStatementPosition = previousStatement.getPosition();
        if (!previousStatementPosition.isValidPosition() || currentPosition.getLine() != previousStatementPosition.getEndLine()) {
            return;
        }
        CtIf nestedIfStatement = (CtIf)previousStatement;
        boolean breaksControlFlow = true;
        while (true) {
            breaksControlFlow = breaksControlFlow && RulesUtils.endsWithFlowControl(nestedIfStatement.getThenStatement());
            CtBlock elseStatementBlock = (CtBlock)nestedIfStatement.getElseStatement();
            if (elseStatementBlock == null) break;
            if (!elseStatementBlock.isImplicit()) {
                return;
            }
            if (elseStatementBlock.getStatements().size() != 1 || !(elseStatementBlock.getLastStatement() instanceof CtIf)) {
                return;
            }
            nestedIfStatement = (CtIf)elseStatementBlock.getLastStatement();
        }
        WarningLevel level = WarningLevel.LEVEL_1;
        if (breaksControlFlow) {
            level = WarningLevel.LEVEL_2;
        }
        this.pattern.add((CtElement)ifStatement, new Object[0]).setLevel(level);
    }
}

