/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;

public class V6085
extends PvsStudioRule {
    PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("An abnormality within similar comparisons. It is possible that a typo is present inside the expression: %s.").setCwe(697).build();

    private boolean isAbnormal(String longStr, String shortStr, BiFunction<String, String, Boolean> fun) {
        assert (longStr.length() > shortStr.length());
        return fun.apply(longStr.toLowerCase(), shortStr.toLowerCase()) == false;
    }

    private boolean apply(List<CtExpression<?>> left, List<CtExpression<?>> right) {
        if (left.size() != right.size() || left.size() < 3) {
            return false;
        }
        if (left.get(0) instanceof CtFieldAccess && right.get(0) instanceof CtFieldAccess) {
            return false;
        }
        String[] ls = new String[left.size()];
        String[] rs = new String[right.size()];
        ls[0] = left.get(0).toString();
        rs[0] = right.get(0).toString();
        if (ls[0].length() == rs[0].length()) {
            return false;
        }
        boolean isLeftComplicated = ls[0].length() > rs[0].length();
        for (int i = 0; i < left.size(); ++i) {
            ls[i] = left.get(i).toString();
            rs[i] = right.get(i).toString();
            if (ls[i].length() == rs[i].length()) {
                return false;
            }
            if (isLeftComplicated == ls[i].length() > rs[i].length()) continue;
            return false;
        }
        int abnormalIndex = -1;
        List<BiFunction> functions = Arrays.asList(String::endsWith, String::startsWith);
        for (BiFunction fun : functions) {
            for (int i = 0; i < left.size(); ++i) {
                boolean isAbnormal;
                String l = ls[i];
                String r = rs[i];
                boolean bl = isAbnormal = isLeftComplicated ? this.isAbnormal(l, r, fun) : this.isAbnormal(r, l, fun);
                if (!isAbnormal) continue;
                if (abnormalIndex == -1) {
                    abnormalIndex = i;
                    continue;
                }
                abnormalIndex = -1;
                break;
            }
            if (abnormalIndex == -1) continue;
            break;
        }
        if (abnormalIndex == -1) {
            return false;
        }
        String leftAbnormal = ls[abnormalIndex];
        String rightAbnormal = rs[abnormalIndex];
        boolean isCopy = false;
        for (int i = 0; !isCopy && i < left.size(); ++i) {
            if (i == abnormalIndex) continue;
            isCopy = Objects.equals(leftAbnormal, ls[i]) || Objects.equals(rightAbnormal, rs[i]);
        }
        if (!isCopy) {
            return false;
        }
        boolean allEqualL = true;
        boolean allEqualR = true;
        for (int i = 1; i < left.size(); ++i) {
            allEqualL = allEqualL && Objects.equals(ls[0], ls[i]);
            allEqualR = allEqualR && Objects.equals(rs[0], rs[i]);
        }
        if (allEqualL || allEqualR) {
            return false;
        }
        CtElement upTo = left.get(abnormalIndex).getParent();
        this.rule.add(upTo, upTo);
        return true;
    }

    private boolean isEqualsFunction(CtInvocation<?> invocation, List<CtExpression<?>> left, List<CtExpression<?>> right) {
        if (invocation.getExecutable().getSimpleName().equals("equals")) {
            if (invocation.getTarget() != null && invocation.getArguments().size() == 1) {
                left.add(invocation.getTarget());
                right.add((CtExpression)invocation.getArguments().get(0));
                return true;
            }
            if (invocation.getExecutable().getDeclaringType() != null && invocation.getExecutable().getDeclaringType().getQualifiedName().equals("java.util.Objects") && invocation.getArguments().size() == 2) {
                left.add((CtExpression)invocation.getArguments().get(0));
                right.add((CtExpression)invocation.getArguments().get(1));
                return true;
            }
        }
        return false;
    }

    private boolean collectComparisons(CtExpression<?> expression, List<CtExpression<?>> left, List<CtExpression<?>> right, BinaryOperatorKind logicOp, BinaryOperatorKind cmpOp) {
        if (expression instanceof CtBinaryOperator) {
            CtBinaryOperator binaryOperator = (CtBinaryOperator)expression;
            if (binaryOperator.getKind() == cmpOp) {
                left.add(binaryOperator.getLeftHandOperand());
                right.add(binaryOperator.getRightHandOperand());
                return true;
            }
            if (binaryOperator.getKind() == logicOp) {
                return this.collectComparisons(binaryOperator.getLeftHandOperand(), left, right, logicOp, cmpOp) && this.collectComparisons(binaryOperator.getRightHandOperand(), left, right, logicOp, cmpOp);
            }
            return false;
        }
        if (expression instanceof CtUnaryOperator) {
            CtUnaryOperator ctUnaryOperator = (CtUnaryOperator)expression;
            if (ctUnaryOperator.getKind() == UnaryOperatorKind.NOT && ctUnaryOperator.getOperand() instanceof CtInvocation && cmpOp == BinaryOperatorKind.NE) {
                return this.isEqualsFunction((CtInvocation)ctUnaryOperator.getOperand(), left, right);
            }
            return false;
        }
        if (expression instanceof CtInvocation) {
            if (cmpOp == BinaryOperatorKind.EQ) {
                return this.isEqualsFunction((CtInvocation)expression, left, right);
            }
            return false;
        }
        return false;
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (operator.getParent() instanceof CtBinaryOperator) {
            return;
        }
        ArrayList<Object> left = new ArrayList();
        ArrayList<Object> right = new ArrayList();
        if (this.collectComparisons((CtExpression<?>)operator, (List<CtExpression<?>>)left, (List<CtExpression<?>>)right, BinaryOperatorKind.AND, BinaryOperatorKind.EQ) && this.apply(left, right)) {
            return;
        }
        left = new ArrayList();
        right = new ArrayList();
        if (this.collectComparisons((CtExpression<?>)operator, (List<CtExpression<?>>)left, (List<CtExpression<?>>)right, BinaryOperatorKind.OR, BinaryOperatorKind.NE)) {
            this.apply(left, right);
        }
    }
}

