/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.Box;
import com.pvsstudio.core.FunctionClassification;
import com.pvsstudio.core.Tribool;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6084
extends PvsStudioRule {
    private static final TypeFactory TYPE_FACTORY = new TypeFactory();
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder(this).setMessage("Collection '%s' is always returned empty. Consider checking for elements that were forgotten to be added.").build();

    private boolean isEmptyInitializer(CtExpression<?> initializer) {
        return Box.ofNullable(initializer).safeCast(CtConstructorCall.class).map(it -> it).map(CtConstructorCall::getActualTypeArguments).filter(it -> it.size() <= 1 && it.stream().allMatch(arg -> arg.isSubtypeOf(V6084.TYPE_FACTORY.INTEGER))).isPresent();
    }

    private Box<CtVariable<?>> getReturnedVariable(CtReturn<?> returnStatement) {
        return Box.of(returnStatement).map(CtReturn::getReturnedExpression).safeCast(CtVariableRead.class).map(it -> it.getVariable()).map(CtVariableReference::getDeclaration);
    }

    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        Tribool isEmpty = this.getValue((CtElement)returnStatement.getReturnedExpression()).getVirtualValue().toContainer().isEmptyContainer();
        if (isEmpty != Tribool.True) {
            return;
        }
        Box<CtVariable> variable = this.getReturnedVariable(returnStatement).filter(CtLocalVariable.class::isInstance).filter(it -> it.getType().isSubtypeOf(V6084.TYPE_FACTORY.COLLECTION) || it.getType().isSubtypeOf(V6084.TYPE_FACTORY.MAP));
        if (variable.isEmpty() || !this.isEmptyInitializer(variable.get().getDefaultExpression())) {
            return;
        }
        CtBlock containingBlock = (CtBlock)variable.get().getParent(CtBlock.class);
        if (containingBlock.getStatements().size() <= 2) {
            return;
        }
        for (CtReturn otherReturn : containingBlock.getElements((Filter)new TypeFilter(CtReturn.class))) {
            if (otherReturn == returnStatement || !this.getReturnedVariable(otherReturn).filter(it -> it == variable.get()).isPresent()) continue;
            return;
        }
        for (CtVariableAccess variableAccess : containingBlock.getElements((Filter)new TypeFilter(CtVariableAccess.class))) {
            boolean hasFieldModifications;
            Box<CtVariableAccess> variableAccessBox = Box.of(variableAccess);
            if (variableAccess instanceof CtVariableRead) {
                Box<CtVariableRead> variableRead = variableAccessBox.map(it -> (CtVariableRead)it).filter(it -> it.getVariable().getDeclaration() == variable.get());
                boolean isArgumentForImpureFunction = variableRead.filter(it -> it.getRoleInParent() == CtRole.ARGUMENT).map(CtElement::getParent).safeCast(CtInvocation.class).map(this::getMethodAnnotation).filter(it -> !it.getPure()).isPresent();
                boolean isAssignedToAnotherVariable = variableRead.map(CtElement::getParent).filter(CtAssignment.class::isInstance).isPresent();
                boolean isUsedInMethodReferences = variableRead.map(CtElement::getParent).filter(CtExecutableReferenceExpression.class::isInstance).map(CtExecutableReferenceExpression.class::cast).map(reference -> this.getDataFlow().getMethodAnnotation(reference)).filter(annotation -> annotation.getAnnotation().is(FunctionClassification.ModifiesObject)).isPresent();
                if (!isArgumentForImpureFunction && !isAssignedToAnotherVariable && !isUsedInMethodReferences) continue;
                return;
            }
            if (!(variableAccess instanceof CtVariableWrite) || !(hasFieldModifications = variableAccessBox.safeCast(CtTargetedExpression.class).map(CtTargetedExpression::getTarget).safeCast(CtVariableRead.class).filter(it -> it.getVariable().getDeclaration() == variable.get()).isPresent())) continue;
            return;
        }
        WarningLevel level = WarningLevel.LEVEL_2;
        Box<CtTypeReference> collectionType = variable.map(it -> it.getType()).map(CtActualTypeContainer::getActualTypeArguments).filter(it -> !it.isEmpty()).map(it -> (CtTypeReference)it.get(it.size() - 1)).map(it -> it instanceof CtWildcardReference ? ((CtWildcardReference)it).getBoundingType() : it);
        if (collectionType.isPresent() && containingBlock.getElements((Filter)new TypeFilter(CtLocalVariable.class)).stream().map(it -> it.getType()).anyMatch(it -> it.isSubtypeOf((CtTypeReference)collectionType.get()))) {
            level = WarningLevel.LEVEL_1;
        }
        this.pattern.add((CtElement)returnStatement, variable.get().getSimpleName()).addSourcePosition((CtElement)variable.get(), this.getModule()).setLevel(level);
    }
}

