/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6083
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Serialization order of fields should be preserved during deserialization.").build();
    private final PvsStudioRule.Pattern ruleAdditional = new PvsStudioRule.PatternBuilder().setMessage("Serialization order of fields should be preserved during deserialization. Consider inspecting the field: %s.").build();

    @Nullable
    private CtMethod<?> getSpecificMethod(@NotNull Set<CtMethod<?>> methods, String invocationName, String qualifiedTypeArgument) {
        List filteredMethods = methods.stream().filter(arg -> arg.getSimpleName().equals(invocationName)).collect(Collectors.toList());
        if (filteredMethods.size() != 1) {
            return null;
        }
        List parameters = ((CtMethod)filteredMethods.get(0)).getParameters();
        if (parameters.size() != 1) {
            return null;
        }
        if (!((CtParameter)parameters.get(0)).getType().getQualifiedName().equals(qualifiedTypeArgument)) {
            return null;
        }
        return (CtMethod)filteredMethods.get(0);
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        CtTypeReference serializableType;
        CtMethod<?> methodWriteExternal = this.getSpecificMethod(ctClass.getMethods(), "writeExternal", "java.io.ObjectOutput");
        if (methodWriteExternal == null) {
            return;
        }
        CtMethod<?> methodReadExternal = this.getSpecificMethod(ctClass.getMethods(), "readExternal", "java.io.ObjectInput");
        if (methodReadExternal == null) {
            return;
        }
        if (ctClass.getSuperInterfaces().stream().noneMatch(i -> i.getQualifiedName().equals("java.io.Externalizable")) && !ctClass.isSubtypeOf(serializableType = new TypeFactory().createReference("java.io.Externalizable"))) {
            return;
        }
        List<CtField<?>> allFields = ctClass.getAllFields().stream().map(CtFieldReference::getFieldDeclaration).collect(Collectors.toList());
        List<CtField<?>> write = this.parseMethod(methodWriteExternal, allFields, "write");
        if (write == null || write.isEmpty()) {
            return;
        }
        List<CtField<?>> read = this.parseMethod(methodReadExternal, allFields, "read");
        if (read == null || read.isEmpty()) {
            return;
        }
        this.removeSequenceItems(write);
        this.removeSequenceItems(read);
        if (write.size() != read.size()) {
            this.rule.add((CtElement)methodReadExternal, new Object[0]).addSourcePosition((CtElement)methodWriteExternal, this.getModule());
        } else {
            IntStream.range(0, write.size()).filter(i -> write.get(i) != read.get(i)).findFirst().ifPresent(i -> this.ruleAdditional.add((CtElement)methodReadExternal, ((CtField)write.get(i)).getSimpleName()).addSourcePosition((CtElement)methodWriteExternal, this.getModule()));
        }
    }

    private void removeSequenceItems(@NotNull List<CtField<?>> list) {
        if (list.size() < 2) {
            return;
        }
        ArrayList indexes = new ArrayList();
        IntStream.range(1, list.size()).filter(i -> list.get(i) == list.get(i - 1)).forEach(indexes::add);
        Collections.reverse(indexes);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int i2 = (Integer)iterator.next();
            list.remove(i2);
        }
    }

    @Nullable
    private List<CtField<?>> parseMethod(CtMethod<?> method, List<CtField<?>> fields, String prefix) {
        ArrayList usedFields = new ArrayList();
        List invocationsByPrefix = method.getBody().getElements((Filter)new TypeFilter(CtInvocation.class)).stream().filter(inv -> inv.getExecutable().getSimpleName().startsWith(prefix)).collect(Collectors.toList());
        Iterator iterator = invocationsByPrefix.iterator();
        while (iterator.hasNext()) {
            CtInvocation invocation;
            CtInvocation parent = invocation = (CtInvocation)iterator.next();
            while (parent.getRoleInParent() != CtRole.STATEMENT || parent.getParent() != method.getBody()) {
                parent = parent.getParent();
            }
            List fieldsInStatement = parent.getElements((Filter)new TypeFilter(CtFieldAccess.class)).stream().map(CtFieldAccess::getVariable).map(CtFieldReference::getFieldDeclaration).filter(Objects::nonNull).filter(fields::contains).distinct().collect(Collectors.toList());
            if (fieldsInStatement.isEmpty()) continue;
            if (fieldsInStatement.size() > 1) {
                return null;
            }
            usedFields.add((CtField)fieldsInStatement.get(0));
        }
        return usedFields;
    }
}

