/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.Box;
import com.pvsstudio.dataflow.MethodAnnotation;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.V5304;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.visitors.StatementWalker;
import com.pvsstudio.warnings.WarningLevel;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTry;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6082
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder(this).setCwe(609).setSastId("CERT-LCK10-J").setSecId("SEC-SYNCHRONIZATION");
    private final PvsStudioRule.Pattern nonVolatilePattern = this.ruleBuilder.setMessage("Unsafe double-checked locking. The field should be declared as volatile.").setLevel(WarningLevel.LEVEL_1).build();
    private final PvsStudioRule.Pattern nonAtomicPattern = this.ruleBuilder.setMessage("Unsafe double-checked locking. Object was assigned to the field before it was initialized.").build();
    private final PvsStudioRule.Pattern reassignNonNullPattern = this.ruleBuilder.setMessage("Unsafe double-checked locking. A previously assigned object may be replaced by another object.").setLevel(WarningLevel.LEVEL_2).build();
    private final PvsStudioRule.LinkedRule<V5304> owaspRule = new PvsStudioRule.LinkedRule<V5304>(this, V5304.class);

    private Box<CtField<?>> getNullCheckedField(Box<CtIf> ifBlock) {
        return ifBlock.map(CtIf::getCondition).safeCast(CtBinaryOperator.class).filter(it -> it.getKind() == BinaryOperatorKind.EQ || it.getKind() == BinaryOperatorKind.NE).filter(it -> RulesUtils.isNullLiteral((CtElement)it.getLeftHandOperand()) || RulesUtils.isNullLiteral((CtElement)it.getRightHandOperand())).map(it -> RulesUtils.isNullLiteral((CtElement)it.getLeftHandOperand()) ? it.getRightHandOperand() : it.getLeftHandOperand()).safeCast(CtFieldRead.class).map(it -> it.getVariable()).map(CtFieldReference::getFieldDeclaration);
    }

    private WarningLevel getModificationWarningLevel(CtElement element) {
        block3: {
            CtElement currentParent = element;
            while (true) {
                element = currentParent;
                if ((currentParent = currentParent.getParent()) instanceof CtFieldWrite) {
                    return WarningLevel.LEVEL_1;
                }
                if (currentParent instanceof CtFieldRead) continue;
                if (!(currentParent instanceof CtInvocation)) break block3;
                if (element.getRoleInParent() == CtRole.ARGUMENT) {
                    Box<CtTypeReference> nonPrimitiveFieldType = Box.of(element).safeCast(CtFieldRead.class).map(it -> it.getType()).filter(it -> !it.isPrimitive());
                    return nonPrimitiveFieldType.isPresent() ? WarningLevel.LEVEL_3 : null;
                }
                MethodAnnotation annotation = this.getDataFlow().getMethodAnnotation((CtInvocation)currentParent);
                if (annotation == null || !annotation.getAnnotation().getPure()) break;
            }
            return WarningLevel.LEVEL_2;
        }
        return null;
    }

    private boolean isNull(CtVariable<?> field, StatementWalker.Path path, StatementWalker.Path root) {
        StatementWalker.Path previousPath = null;
        for (StatementWalker.Path currentPath = path; currentPath != null && currentPath != root; currentPath = currentPath.getParent()) {
            Box<CtIf> ifOperator = Box.ofNullable(currentPath.getStatement()).safeCast(CtIf.class);
            if (previousPath != null && this.getNullCheckedField(ifOperator).filter(it -> it == field).isPresent()) {
                Box<BinaryOperatorKind> operator = ifOperator.map(CtIf::getCondition).safeCast(CtBinaryOperator.class).map(it -> it.getKind());
                if (previousPath.getStatement() == ifOperator.get().getThenStatement() && operator.filter(it -> it == BinaryOperatorKind.EQ).isPresent() || previousPath.getStatement() == ifOperator.get().getElseStatement() && operator.filter(it -> it == BinaryOperatorKind.NE).isPresent()) {
                    return true;
                }
            }
            previousPath = currentPath;
        }
        return false;
    }

    private boolean areSiblings(StatementWalker.Path first, StatementWalker.Path second) {
        StatementWalker.Path previousPath = null;
        for (StatementWalker.Path currentPath = first; currentPath != null; currentPath = currentPath.getParent()) {
            if (previousPath != null && (currentPath.getStatement() instanceof CtIf || currentPath.getStatement() instanceof CtTry || currentPath.getStatement() instanceof CtSwitch) && second.isInsideOf(currentPath)) {
                return !second.isInsideOf(previousPath);
            }
            previousPath = currentPath;
        }
        return false;
    }

    public void visitCtSynchronized(CtSynchronized synchro) {
        Box<CtBlock> singleMethodCallBody;
        final Box checkedField = Box.ofNullable(synchro.getParent()).map(it -> it instanceof CtBlock ? it.getParent() : it).safeCast(CtIf.class).swap(this::getNullCheckedField);
        if (checkedField.isEmpty()) {
            return;
        }
        Box<Object> branchToCheck = Box.empty();
        for (CtStatement statement : synchro.getBlock()) {
            Box<CtIf> ifStatement = Box.of(statement).safeCast(CtIf.class);
            Box currentCheckedField = ifStatement.swap(this::getNullCheckedField);
            if (currentCheckedField.isEmpty() || currentCheckedField.get() != checkedField.get()) continue;
            branchToCheck = ifStatement.map(it -> (CtBinaryOperator)it.getCondition()).map(it -> it.getKind() == BinaryOperatorKind.EQ ? ((CtIf)ifStatement.get()).getThenStatement() : ((CtIf)ifStatement.get()).getElseStatement()).safeCast(CtStatement.class);
            break;
        }
        if (branchToCheck.isEmpty()) {
            return;
        }
        if (!((CtField)checkedField.get()).hasModifier(ModifierKind.VOLATILE)) {
            this.nonVolatilePattern.add((CtElement)checkedField.get(), new Object[0]).addSourcePosition((CtElement)synchro, this.getModule());
            this.owaspRule.get().applyNonVolatileField((CtElement)synchro, (CtField)checkedField.get());
        }
        CtStatement body = (singleMethodCallBody = branchToCheck.safeCast(CtStatementList.class).map(CtStatementList::getStatements).filter(it -> it.size() == 1).map(it -> (CtStatement)it.get(0)).safeCast(CtAbstractInvocation.class).map(it -> it.getExecutable()).map(CtExecutableReference::getExecutableDeclaration).map(CtExecutable::getBody).filter(it -> synchro.getParent(CtClass.class) == it.getParent(CtClass.class))).isPresent() ? (CtStatement)singleMethodCallBody.get() : (CtStatement)branchToCheck.get();
        final CtStatement[] assignment = new CtStatement[1];
        final WarningLevel[] warningLevel = new WarningLevel[1];
        new StatementWalker(body){
            private StatementWalker.Path assignmentPath;
            {
                super(statement);
                this.assignmentPath = null;
            }

            @Override
            protected void onStatement(CtStatement statement, StatementWalker.Path path) {
                Box<CtField> assignedField = Box.of(statement).safeCast(CtAssignment.class).map(it -> it.getAssigned()).safeCast(CtFieldWrite.class).map(it -> it.getVariable()).map(CtFieldReference::getFieldDeclaration).filter(it -> it == checkedField.get());
                if (assignment[0] == null) {
                    if (assignedField.isPresent() && !RulesUtils.isNullLiteral((CtElement)((CtAssignment)statement).getAssignment())) {
                        assignment[0] = statement;
                        this.assignmentPath = path;
                    }
                    return;
                }
                if (assignedField.isPresent()) {
                    if (!V6082.this.isNull((CtVariable)checkedField.get(), path, this.assignmentPath) && !V6082.this.areSiblings(this.assignmentPath, path)) {
                        V6082.this.reassignNonNullPattern.add((CtElement)statement, new Object[0]).addSourcePosition((CtElement)assignment[0], V6082.this.getModule());
                        V6082.this.owaspRule.get().applyFieldReassign(assignment[0], statement);
                    }
                    return;
                }
                for (CtFieldAccess fieldAccess : statement.getElements((Filter)new TypeFilter(CtFieldAccess.class))) {
                    if (fieldAccess.getVariable().getFieldDeclaration() != checkedField.get()) continue;
                    WarningLevel newWarningLevel = V6082.this.getModificationWarningLevel((CtElement)fieldAccess);
                    if (warningLevel[0] == null || newWarningLevel != null && newWarningLevel.isHigherThan(warningLevel[0])) {
                        warningLevel[0] = newWarningLevel;
                    }
                    if (warningLevel[0] != WarningLevel.LEVEL_1) continue;
                    this.terminate();
                    break;
                }
            }
        }.walk();
        if (warningLevel[0] != null) {
            WarningAdapter warning = this.nonAtomicPattern.add((CtElement)assignment[0], new Object[0]).setLevel(warningLevel[0]);
            if (body != branchToCheck.get()) {
                warning.addSourcePosition((CtElement)synchro, this.getModule());
            }
            this.owaspRule.get().applyNonAtomicInitialization((CtElement)synchro, assignment[0], warningLevel[0]);
        }
    }
}

