/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.FunctionClassification;
import com.pvsstudio.core.OptionalStringView;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6081
extends PvsStudioRule {
    PvsStudioRule.Pattern ruleForAnnotationClass = new PvsStudioRule.PatternBuilder().setMessage("The '%s' annotation does not have 'RUNTIME' retention policy, it will not be accessible through Reflection API.").build();
    PvsStudioRule.Pattern ruleForVariable = new PvsStudioRule.PatternBuilder().setMessage("The '%s' variable contains the '%s' annotation without 'RUNTIME' retention policy, it will not be accessible through Reflection API.").build();

    private boolean isFieldNameClass(CtFieldRead<?> ctFieldRead) {
        return ctFieldRead.getVariable().getSimpleName().equals("class");
    }

    private List<CtAssignment<?, ?>> getAssignmentsFromScope(CtElement scope, CtVariableAccess<?> ctVariableAccess) {
        List<CtAssignment<?, ?>> collect = scope.getElements((Filter)new TypeFilter(CtAssignment.class)).stream().filter(arg -> RulesUtils.equals((CtElement)arg.getAssigned(), (CtElement)ctVariableAccess)).collect(Collectors.toList());
        CtVariable declarationVarAccess = ctVariableAccess.getVariable().getDeclaration();
        collect.removeIf(arg -> {
            if (RulesUtils.isNullLiteral((CtElement)arg.getAssignment())) {
                return true;
            }
            if (arg.getAssigned() instanceof CtVariableAccess) {
                CtVariableReference currentVar = ((CtVariableAccess)arg.getAssigned()).getVariable();
                return currentVar != null && currentVar.getDeclaration() != declarationVarAccess;
            }
            return false;
        });
        return collect;
    }

    @Nullable
    private String getNameAnnotationByInvocation(CtInvocation<?> ctInvocation) {
        String name = ctInvocation.getExecutable().getSimpleName();
        if (!name.equals("forName")) {
            return null;
        }
        for (CtExpression arg : ctInvocation.getArguments()) {
            if (!RulesUtils.isSubtypeOf(arg, "java.lang.String")) continue;
            OptionalStringView value = this.getValue((CtElement)arg).getVirtualValue().getSingletonString();
            if (value.isPresent()) {
                return value.get();
            }
            if (arg instanceof CtLiteral && ((CtLiteral)arg).getValue() instanceof String) {
                return (String)((CtLiteral)arg).getValue();
            }
            return null;
        }
        return null;
    }

    @Nullable
    private String getNameAnnotationByVariable(CtVariableAccess<?> variableAccess) {
        CtElement scope = null;
        CtVariable variable = variableAccess.getVariable().getDeclaration();
        if (variable instanceof CtLocalVariable) {
            scope = variable.getParent((Filter)new TypeFilter(CtBlock.class));
        } else if (variable instanceof CtField) {
            if (!variable.getModifiers().contains(ModifierKind.PRIVATE)) {
                return null;
            }
            scope = variable.getParent((Filter)new TypeFilter(CtClass.class));
        }
        if (scope == null) {
            return null;
        }
        List<CtAssignment<?, ?>> assignmentsFromScope = this.getAssignmentsFromScope(scope, variableAccess);
        CtExpression defaultExpression = variable.getDefaultExpression();
        if (defaultExpression == null || RulesUtils.isNullLiteral((CtElement)defaultExpression)) {
            if (assignmentsFromScope.size() != 1) {
                return null;
            }
            CtExpression assignmentRhs = assignmentsFromScope.get(0).getAssignment();
            if (RulesUtils.equals((CtElement)assignmentsFromScope.get(0).getAssigned(), (CtElement)assignmentRhs)) {
                return null;
            }
            if (assignmentRhs instanceof CtInvocation) {
                return this.getNameAnnotationByInvocation((CtInvocation)assignmentRhs);
            }
            if (assignmentRhs instanceof CtVariableRead) {
                if (assignmentRhs instanceof CtFieldRead && this.isFieldNameClass((CtFieldRead)assignmentRhs)) {
                    return ((CtFieldRead)assignmentRhs).getTarget().toString();
                }
                return this.getNameAnnotationByVariable((CtVariableAccess<?>)((CtVariableRead)assignmentRhs));
            }
            return null;
        }
        if (!assignmentsFromScope.isEmpty()) {
            return null;
        }
        if (defaultExpression instanceof CtInvocation) {
            return this.getNameAnnotationByInvocation((CtInvocation)defaultExpression);
        }
        if (defaultExpression instanceof CtVariableRead) {
            if (defaultExpression instanceof CtFieldRead && this.isFieldNameClass((CtFieldRead)defaultExpression)) {
                return ((CtFieldRead)defaultExpression).getTarget().toString();
            }
            return this.getNameAnnotationByVariable((CtVariableAccess<?>)((CtVariableRead)defaultExpression));
        }
        return null;
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        Annotation methodAnnotation = this.getMethodAnnotation((CtAbstractInvocation<?>)invocation);
        if (!methodAnnotation.is(FunctionClassification.ReflectAccessToAnnotation)) {
            return;
        }
        if (invocation.getArguments().size() != 1) {
            assert (false);
            return;
        }
        CtExpression arg = (CtExpression)invocation.getArguments().get(0);
        if (arg instanceof CtVariableAccess) {
            CtFieldRead ctFieldRead;
            String qualifiedName = null;
            if (arg instanceof CtFieldRead && this.isFieldNameClass(ctFieldRead = (CtFieldRead)arg)) {
                CtType declaration;
                qualifiedName = ctFieldRead.getTarget().toString();
                if (ctFieldRead.getTarget() instanceof CtTypeAccess && (declaration = ((CtTypeAccess)ctFieldRead.getTarget()).getAccessedType().getDeclaration()) != null && !declaration.isTopLevel()) {
                    int index = qualifiedName.lastIndexOf(".");
                    if (index < 0) {
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder(qualifiedName);
                    stringBuilder.setCharAt(index, '$');
                    qualifiedName = stringBuilder.toString();
                }
            }
            WarningLevel level = WarningLevel.LEVEL_1;
            if (qualifiedName == null) {
                level = WarningLevel.LEVEL_2;
                qualifiedName = this.getNameAnnotationByVariable((CtVariableAccess)arg);
            }
            if (qualifiedName == null) {
                return;
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(qualifiedName);
            }
            catch (Exception index) {
                // empty catch block
            }
            CtType ctShadowType = clazz == null ? arg.getFactory().Type().get(qualifiedName) : arg.getFactory().Type().get(clazz);
            if (ctShadowType == null) {
                return;
            }
            Retention annotation = (Retention)ctShadowType.getAnnotation(Retention.class);
            if (annotation == null || annotation.value() != RetentionPolicy.RUNTIME) {
                if (this.isInsideTestSources((CtElement)arg)) {
                    level = WarningLevel.LEVEL_3;
                }
                if (arg instanceof CtFieldRead && this.isFieldNameClass((CtFieldRead)arg)) {
                    this.ruleForAnnotationClass.add((CtElement)arg, qualifiedName).setLevel(level);
                } else {
                    this.ruleForVariable.add((CtElement)arg, arg, qualifiedName).setLevel(level);
                }
            }
        }
    }
}

