/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.PointerVirtualValue;
import com.pvsstudio.dataflow.DataFlow;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.EarlyTerminatingScanner;

public class V6080
extends PvsStudioRule {
    private static final WarningLevel DEFAULT_WARNING_LEVEL = WarningLevel.LEVEL_2;
    private final PvsStudioRule.Pattern warning = new PvsStudioRule.PatternBuilder(this).setMessage("Consider checking for misprints. It's possible that an assigned variable should be checked in the next condition.").setLevel(DEFAULT_WARNING_LEVEL).setCwe(697).build();

    private static boolean anyBranchMatches(CtIf ifStatement, Predicate<CtStatement> predicate) {
        return ifStatement.getThenStatement() != null && predicate.test(ifStatement.getThenStatement()) || ifStatement.getElseStatement() != null && predicate.test(ifStatement.getElseStatement());
    }

    private static boolean isComparisonOperator(CtBinaryOperator<?> operator) {
        switch (operator.getKind()) {
            case EQ: 
            case NE: 
            case GT: 
            case GE: 
            case LT: 
            case LE: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNumberLike(CtTypeReference<?> type) {
        String name = type.unbox().getQualifiedName();
        return Objects.equals(name, "byte") || Objects.equals(name, "char") || Objects.equals(name, "short") || Objects.equals(name, "int") || Objects.equals(name, "long") || Objects.equals(name, "float") || Objects.equals(name, "double");
    }

    private static boolean areComparable(CtTypeReference<?> first, CtTypeReference<?> second) {
        if (first == null || second == null) {
            return false;
        }
        return Objects.equals(first.getQualifiedName(), "<nulltype>") && !second.isPrimitive() || Objects.equals(second.getQualifiedName(), "<nulltype>") && !first.isPrimitive() || first.isSubtypeOf(second) || second.isSubtypeOf(first) || V6080.isNumberLike(first) && V6080.isNumberLike(second);
    }

    private void processAssignment(VariablePath targetPath, CtTypeReference<?> targetType, CtStatement assignment, CtBlock<?> parent) {
        if (targetPath == null || targetType == null) {
            return;
        }
        if (targetPath.name.length() <= 1) {
            return;
        }
        Context context = Context.initialize(targetPath, targetType, assignment, parent, this.getDataFlow());
        if (context == null) {
            return;
        }
        LinkedList<Match> matches = new LinkedList<Match>();
        MatchScanner scanner = new MatchScanner(context, matches);
        scanner.scan((CtElement)context.check.getCondition());
        if (scanner.isSuppressed || matches.isEmpty()) {
            return;
        }
        context.matches = matches;
        context.hasFlowControl = V6080.anyBranchMatches(context.check, RulesUtils::endsWithFlowControl);
        if (context.strategy.trySuppressingAfterMatching(context)) {
            return;
        }
        context.strategy.postProcess(context);
        for (Match match : context.matches) {
            this.warning.add((CtElement)match.expression, new Object[0]).addSourcePosition((CtElement)assignment, this.getModule()).setLevel(match.level);
        }
    }

    private static boolean isCompoundVariableDefinition(CtLocalVariable<?> statement) {
        SourcePosition previousPosition;
        CtBlock parent = (CtBlock)statement.getParent();
        int indexInParent = parent.getStatements().indexOf(statement);
        if (indexInParent < 0) {
            return false;
        }
        SourcePosition statementPosition = statement.getPosition();
        if (!statementPosition.isValidPosition()) {
            return false;
        }
        if (indexInParent >= 1 && (previousPosition = parent.getStatement(indexInParent - 1).getPosition()).isValidPosition() && previousPosition.getSourceStart() == statementPosition.getSourceStart() && previousPosition.getSourceEnd() == statementPosition.getSourceEnd()) {
            return true;
        }
        if (indexInParent < parent.getStatements().size() - 1) {
            SourcePosition nextPosition = parent.getStatement(indexInParent + 1).getPosition();
            return nextPosition.isValidPosition() && nextPosition.getSourceStart() == statementPosition.getSourceStart() && nextPosition.getSourceEnd() == statementPosition.getSourceEnd();
        }
        return false;
    }

    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        if (localVariable.getAssignment() == null) {
            return;
        }
        CtElement parent = localVariable.getParent();
        if (parent instanceof CtBlock && !V6080.isCompoundVariableDefinition(localVariable)) {
            VariablePath path = VariablePath.split(localVariable);
            this.processAssignment(path, (CtTypeReference<?>)localVariable.getType(), (CtStatement)localVariable, (CtBlock<?>)((CtBlock)parent));
        }
    }

    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
        List children = assignment.getDirectChildren();
        if (children.get(children.size() - 1) instanceof CtAssignment) {
            return;
        }
        CtElement parent = assignment.getParent();
        if (parent instanceof CtBlock) {
            CtExpression assignmentLhs = assignment.getAssigned();
            VariablePath path = VariablePath.split((CtElement)assignmentLhs);
            this.processAssignment(path, (CtTypeReference<?>)assignmentLhs.getType(), (CtStatement)assignment, (CtBlock<?>)((CtBlock)parent));
        }
    }

    private static class VariablePath {
        public String prefix;
        public String name;
        public CtVariable<?> variable;

        private VariablePath() {
        }

        public static VariablePath split(CtLocalVariable<?> localVariable) {
            VariablePath path = new VariablePath();
            path.prefix = null;
            path.name = localVariable.getSimpleName();
            path.variable = localVariable.getReference().getDeclaration();
            return path;
        }

        public static VariablePath split(CtElement expression) {
            CtVariableReference variable;
            if (!(expression instanceof CtVariableAccess)) {
                return null;
            }
            String target = null;
            if (expression instanceof CtFieldAccess) {
                CtExpression targetExpression = ((CtFieldAccess)expression).getTarget();
                if (targetExpression instanceof CtThisAccess) {
                    target = "this";
                } else if (targetExpression instanceof CtTypeAccess) {
                    target = ((CtTypeAccess)targetExpression).getAccessedType().getQualifiedName();
                } else {
                    return null;
                }
            }
            if ((variable = ((CtVariableAccess)expression).getVariable()) == null) {
                return null;
            }
            VariablePath path = new VariablePath();
            path.prefix = target;
            path.name = variable.getSimpleName();
            path.variable = variable.getDeclaration();
            return path;
        }

        public MatchType compareWith(VariablePath other) {
            if (Objects.equals(this, other)) {
                return MatchType.EXACT;
            }
            if (!Objects.equals(this.prefix, other.prefix) && Objects.equals(this.name, other.name)) {
                return MatchType.SIMILAR;
            }
            if (Objects.equals(this.prefix, other.prefix)) {
                int maxDistance = 1;
                return RulesUtils.calculateLevenshteinDistance(this.name, other.name) <= maxDistance ? MatchType.SIMILAR : null;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariablePath that = (VariablePath)o;
            return this.variable == that.variable;
        }

        public int hashCode() {
            return this.variable.hashCode();
        }
    }

    private static class Context {
        private CtBlock<?> parent;
        private int assignmentIndex;
        public VariablePath targetPath;
        public CtTypeReference<?> targetType;
        public CtIf check;
        public VariablePath valuePath;
        public WorkerStrategy strategy;
        public Collection<Match> matches = Collections.emptyList();
        private boolean isLocalVariable = false;
        private boolean hasFlowControl = false;

        private Context() {
        }

        public static Context initialize(VariablePath targetPath, CtTypeReference<?> targetType, CtStatement assignment, CtBlock<?> parent, DataFlow dataFlow) {
            Context context = new Context();
            context.parent = parent;
            context.targetPath = targetPath;
            context.targetType = targetType;
            context.assignmentIndex = parent.getStatements().indexOf(assignment);
            if (context.assignmentIndex < 0) {
                return null;
            }
            CtStatement nextStatement = context.lookahead(1);
            if (!(nextStatement instanceof CtIf)) {
                return null;
            }
            context.check = (CtIf)nextStatement;
            List assignmentNodes = assignment.getDirectChildren();
            CtExpression assignmentRhs = (CtExpression)assignmentNodes.get(assignmentNodes.size() - 1);
            context.strategy = WorkerStrategy.byExpression(assignmentRhs, targetType, dataFlow);
            if (context.strategy == null || context.strategy.trySuppressingBeforeMatching(context)) {
                return null;
            }
            context.valuePath = VariablePath.split((CtElement)assignmentRhs);
            context.isLocalVariable = !(targetPath.variable instanceof CtField);
            return context;
        }

        public CtStatement lookahead(int depth) {
            int index = this.assignmentIndex + depth;
            List statements = this.parent.getStatements();
            return index >= 0 && index < statements.size() ? (CtStatement)statements.get(index) : null;
        }
    }

    private static class MatchScanner
    extends VariableScanner<Void> {
        private final Context context;
        private final Collection<Match> matchCollector;
        private boolean isSuppressed = false;

        public MatchScanner(Context context, Collection<Match> matchCollector) {
            this.context = context;
            this.matchCollector = matchCollector;
        }

        @Override
        protected void onVariable(CtVariableRead<?> variableRead) {
            VariablePath currentPath = VariablePath.split(variableRead);
            if (currentPath == null) {
                return;
            }
            MatchType type = this.context.valuePath != null && this.context.valuePath.compareWith(currentPath) == MatchType.EXACT ? MatchType.EXACT : this.context.targetPath.compareWith(currentPath);
            if (type == MatchType.EXACT) {
                this.isSuppressed = true;
                this.terminate();
                return;
            }
            if (type == null || variableRead.getRoleInParent() == CtRole.TARGET) {
                return;
            }
            if (type == MatchType.SIMILAR && this.matchCollector != null) {
                CtExpression otherExpression;
                CtElement parent = variableRead.getParent();
                if (!(parent instanceof CtBinaryOperator)) {
                    return;
                }
                CtBinaryOperator operator = (CtBinaryOperator)parent;
                if (!V6080.isComparisonOperator(operator)) {
                    return;
                }
                CtExpression ctExpression = otherExpression = operator.getLeftHandOperand() == variableRead ? operator.getRightHandOperand() : operator.getLeftHandOperand();
                if (!this.context.strategy.isComparableWithTarget(this.context, otherExpression)) {
                    return;
                }
                Match match = new Match();
                match.path = currentPath;
                match.expression = variableRead;
                match.type = type;
                this.matchCollector.add(match);
            }
        }
    }

    private static abstract class WorkerStrategy {
        private WorkerStrategy() {
        }

        public static WorkerStrategy byExpression(CtExpression<?> expression, CtTypeReference<?> targetType, DataFlow dataFlow) {
            if (expression instanceof CtConstructorCall || expression instanceof CtThisAccess || expression instanceof CtNewArray || RulesUtils.isConstantExpression(dataFlow.getVariablesCache(), expression)) {
                return null;
            }
            if (targetType.isPrimitive()) {
                return PrimitiveWorkerStrategy.INSTANCE;
            }
            PointerVirtualValue pointer = dataFlow.getValue((CtElement)expression).toPointer();
            if (pointer != null && (pointer.isNotNullPointer() || pointer.isNullPointer())) {
                return null;
            }
            return ReferenceWorkerStrategy.INSTANCE;
        }

        public boolean trySuppressingBeforeMatching(Context context) {
            CtExpression condition;
            CtStatement nextStatement;
            CtStatement previousStatement = context.lookahead(-1);
            if (previousStatement != null) {
                VariablePath previousPath = null;
                if (previousStatement instanceof CtLocalVariable) {
                    previousPath = VariablePath.split((CtLocalVariable)previousStatement);
                } else if (previousStatement instanceof CtAssignment) {
                    CtAssignment assignment = (CtAssignment)previousStatement;
                    previousPath = VariablePath.split((CtElement)assignment.getAssigned());
                }
                if (previousPath != null && previousPath.compareWith(context.targetPath) == MatchType.SIMILAR) {
                    return true;
                }
            }
            if ((nextStatement = context.lookahead(2)) instanceof CtIf && (VariableUsageScanner.hasUsages((CtElement)(condition = ((CtIf)nextStatement).getCondition()), context.targetPath.variable) || context.valuePath != null && VariableUsageScanner.hasUsages((CtElement)condition, context.valuePath.variable))) {
                return true;
            }
            Predicate<CtStatement> complexBranchPredicate = branch -> {
                if (branch instanceof CtStatementList) {
                    for (CtStatement statement : (CtStatementList)branch) {
                        if (!(statement instanceof CtIf) && !(statement instanceof CtLoop) && !(statement instanceof CtSwitch)) continue;
                        return true;
                    }
                }
                return false;
            };
            return V6080.anyBranchMatches(context.check, complexBranchPredicate);
        }

        public boolean trySuppressingAfterMatching(Context context) {
            if (context.hasFlowControl || V6080.anyBranchMatches(context.check, it -> VariableUsageScanner.hasUsages((CtElement)it, context.targetPath.variable))) {
                return false;
            }
            for (Match match : context.matches) {
                boolean matchedLocalVariable = !(match.path.variable instanceof CtField);
                if (matchedLocalVariable == context.isLocalVariable) continue;
                return false;
            }
            return true;
        }

        public abstract boolean isComparableWithTarget(Context var1, CtExpression<?> var2);

        public abstract void postProcess(Context var1);
    }

    private static class Match {
        public VariablePath path;
        public CtExpression<?> expression;
        public MatchType type;
        public WarningLevel level = DEFAULT_WARNING_LEVEL;

        private Match() {
        }

        public void decreaseLevel() {
            this.level = this.level.decrease();
        }

        public void increaseLevel() {
            this.level = this.level.increase();
        }
    }

    private static class ReferenceWorkerStrategy
    extends WorkerStrategy {
        public static final WorkerStrategy INSTANCE = new ReferenceWorkerStrategy();

        private ReferenceWorkerStrategy() {
        }

        @Override
        public boolean isComparableWithTarget(Context context, CtExpression<?> expression) {
            return expression.getType() != null && V6080.areComparable(expression.getType(), context.targetType);
        }

        @Override
        public void postProcess(Context context) {
            if (context.hasFlowControl || V6080.anyBranchMatches(context.check, it -> VariableUsageScanner.hasUsages((CtElement)it, context.targetPath.variable))) {
                for (Match match : context.matches) {
                    match.increaseLevel();
                }
                return;
            }
            for (Match match : context.matches) {
                match.decreaseLevel();
            }
            for (Match match : context.matches) {
                if (!V6080.anyBranchMatches(context.check, it -> VariableUsageScanner.hasUsages((CtElement)it, match.path.variable))) continue;
                match.decreaseLevel();
            }
        }
    }

    private static class PrimitiveWorkerStrategy
    extends WorkerStrategy {
        public static final WorkerStrategy INSTANCE = new PrimitiveWorkerStrategy();

        private PrimitiveWorkerStrategy() {
        }

        @Override
        public boolean isComparableWithTarget(Context context, CtExpression<?> expression) {
            return expression.getType() != null && V6080.isNumberLike(expression.getType());
        }

        @Override
        public void postProcess(Context context) {
            if (context.hasFlowControl) {
                for (Match match : context.matches) {
                    match.increaseLevel();
                }
            }
            for (Match match : context.matches) {
                if (V6080.anyBranchMatches(context.check, it -> VariableUsageScanner.hasUsages((CtElement)it, match.path.variable))) {
                    match.increaseLevel();
                    continue;
                }
                match.decreaseLevel();
            }
        }
    }

    private static class VariableUsageScanner
    extends VariableScanner<Boolean> {
        private final CtVariable<?> variable;

        public static boolean hasUsages(CtElement block, CtVariable<?> variable) {
            VariableUsageScanner scanner = new VariableUsageScanner(variable);
            scanner.scan(block);
            return (Boolean)scanner.getResult();
        }

        public VariableUsageScanner(CtVariable<?> variable) {
            this.setResult(false);
            this.variable = variable;
        }

        @Override
        protected void onVariable(CtVariableRead<?> variableRead) {
            if (variableRead.getVariable().getDeclaration() == this.variable) {
                this.setResult(true);
                this.terminate();
            }
        }
    }

    private static abstract class VariableScanner<T>
    extends EarlyTerminatingScanner<T> {
        private VariableScanner() {
        }

        protected abstract void onVariable(CtVariableRead<?> var1);

        public <R> void visitCtFieldRead(CtFieldRead<R> fieldRead) {
            this.onVariable((CtVariableRead<?>)fieldRead);
        }

        public <R> void visitCtVariableRead(CtVariableRead<R> variableRead) {
            this.onVariable(variableRead);
        }
    }

    private static enum MatchType {
        SIMILAR,
        EXACT;

    }
}

