/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.core.TypeClassification;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6079
extends PvsStudioRule {
    PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Value of the '%s' %s is checked after use. Potential logical error is present.").setCwe(129).setSecId("SEC-BUF-OVERFLOW").build();

    private void filterByFirstException(List<IndexAccess> indexAccesses, CtBinaryOperator<?> ctBinaryOperator) {
        indexAccesses.removeIf(indexAccess -> {
            CtElement stBinary;
            TypeFilter<CtElement> upToStatementFilter = new TypeFilter<CtElement>(CtElement.class){

                public boolean matches(CtElement element) {
                    return element.getRoleInParent() == CtRole.STATEMENT;
                }
            };
            CtElement stIndex = indexAccess.expression.getParent((Filter)upToStatementFilter);
            return stIndex != (stBinary = ctBinaryOperator.getParent((Filter)upToStatementFilter));
        });
    }

    boolean isSecondException(CtElement element1, CtElement element2) {
        SourcePosition position1 = element1.getPosition();
        SourcePosition position2 = element2.getPosition();
        if (position1.isValidPosition() && position2.isValidPosition()) {
            return Math.abs(position1.getLine() - position2.getLine()) > 100;
        }
        return false;
    }

    private BinaryOperatorKind getInverseOperator(BinaryOperatorKind op) {
        switch (op) {
            case LT: {
                return BinaryOperatorKind.GT;
            }
            case GT: {
                return BinaryOperatorKind.LT;
            }
            case LE: {
                return BinaryOperatorKind.GE;
            }
            case GE: {
                return BinaryOperatorKind.LE;
            }
            case EQ: {
                return BinaryOperatorKind.EQ;
            }
            case NE: {
                return BinaryOperatorKind.NE;
            }
        }
        return op;
    }

    @Nullable
    private Integer getSingletonValueInt(CtExpression<?> expression) {
        IntegerVirtualValue integerVirtualValueExpression = this.getValue((CtElement)expression).toInteger();
        if (integerVirtualValueExpression != null && integerVirtualValueExpression.singletonValue().isPresent()) {
            return integerVirtualValueExpression.singletonValue().get().toInt().get();
        }
        return null;
    }

    @Nullable
    private IndexAccess createIndexAccess(CtExpression<?> expression, CtExpression<?> indexExpression, List<CtBinaryOperator<?>> underBinOperators, String nameUpperBound) {
        if (indexExpression instanceof CtBinaryOperator) {
            return null;
        }
        if (indexExpression instanceof CtLiteral) {
            return null;
        }
        IntegerVirtualValue value = this.getValue((CtElement)indexExpression).toInteger();
        if (value != null && value.singletonValue().isPresent()) {
            return null;
        }
        if (RulesUtils.isModifyValue(indexExpression, this.getDataFlow())) {
            return null;
        }
        if (!indexExpression.getElements((Filter)new TypeFilter(CtThisAccess.class)).isEmpty()) {
            return null;
        }
        IndexAccess indexAccess = new IndexAccess(expression, indexExpression, underBinOperators, nameUpperBound);
        indexAccess.dependentVars.addAll(indexExpression.getElements((Filter)new TypeFilter(CtVariableAccess.class)).stream().map(arg -> arg.getVariable().getDeclaration()).filter(Objects::nonNull).collect(Collectors.toList()));
        return indexAccess;
    }

    private void mergeInfoBranches(List<IndexAccess> general, List<List<IndexAccess>> listSubIndexAccesses) {
        ArrayList varsForRemoval = new ArrayList();
        ArrayList<IndexAccess> newIndexAccesses = new ArrayList<IndexAccess>();
        for (List<IndexAccess> indexAccesses : listSubIndexAccesses) {
            if (indexAccesses == null) continue;
            general.stream().filter(arg -> !indexAccesses.contains(arg)).forEach(varsForRemoval::add);
            indexAccesses.removeAll(general);
            newIndexAccesses.addAll(indexAccesses);
        }
        general.addAll(newIndexAccesses);
        general.removeAll(varsForRemoval);
    }

    private List<CtExpression<?>> getExpressionsFromCondition(CtExpression<?> expression) {
        ArrayList expressions = new ArrayList();
        if (expression instanceof CtBinaryOperator) {
            CtBinaryOperator ctBinaryOperator = (CtBinaryOperator)expression;
            if (ctBinaryOperator.getKind() == BinaryOperatorKind.OR || ctBinaryOperator.getKind() == BinaryOperatorKind.AND || !RulesUtils.isBooleanOrBoxed(ctBinaryOperator)) {
                expressions.addAll(this.getExpressionsFromCondition(ctBinaryOperator.getLeftHandOperand()));
                expressions.addAll(this.getExpressionsFromCondition(ctBinaryOperator.getRightHandOperand()));
            } else {
                expressions.add((CtExpression<?>)ctBinaryOperator);
            }
        } else {
            expressions.add(expression);
        }
        return expressions;
    }

    private boolean parseBinaryOperator(CtBinaryOperator<?> ctBinaryOperator, List<IndexAccess> indexAccesses) {
        block28: {
            String addOnMessage;
            boolean isLoop;
            BinaryOperatorKind binaryOperatorKind;
            CtExpression expression;
            CtExpression indexExpression;
            List<IndexAccess> suspiciousIndexAccesses;
            block27: {
                boolean isLeft = true;
                suspiciousIndexAccesses = indexAccesses.stream().filter(arg -> arg.indexExpression.equals((Object)ctBinaryOperator.getLeftHandOperand())).collect(Collectors.toList());
                if (suspiciousIndexAccesses.isEmpty()) {
                    isLeft = false;
                    suspiciousIndexAccesses = indexAccesses.stream().filter(arg -> arg.indexExpression.equals((Object)ctBinaryOperator.getRightHandOperand())).collect(Collectors.toList());
                }
                suspiciousIndexAccesses.removeIf(arg -> arg.underBinOperators.stream().anyMatch(bin -> {
                    if (RulesUtils.equals((CtElement)bin.getLeftHandOperand(), arg.indexExpression)) {
                        String strSize = bin.getRightHandOperand().toString();
                        Integer valueExpression = this.getSingletonValueInt(bin.getRightHandOperand());
                        return valueExpression != null && valueExpression <= 0 || strSize.equals(arg.nameUpperBound);
                    }
                    if (RulesUtils.equals((CtElement)bin.getRightHandOperand(), arg.indexExpression)) {
                        String strSize = bin.getLeftHandOperand().toString();
                        Integer valueExpression = this.getSingletonValueInt(bin.getLeftHandOperand());
                        return valueExpression != null && valueExpression <= 0 || strSize.equals(arg.nameUpperBound);
                    }
                    return false;
                }));
                suspiciousIndexAccesses.removeIf(arg -> this.isSecondException((CtElement)arg.expression, (CtElement)ctBinaryOperator));
                if (suspiciousIndexAccesses.isEmpty()) {
                    return false;
                }
                indexExpression = isLeft ? ctBinaryOperator.getLeftHandOperand() : ctBinaryOperator.getRightHandOperand();
                expression = isLeft ? ctBinaryOperator.getRightHandOperand() : ctBinaryOperator.getLeftHandOperand();
                binaryOperatorKind = isLeft ? ctBinaryOperator.getKind() : this.getInverseOperator(ctBinaryOperator.getKind());
                isLoop = ctBinaryOperator.getParent(CtStatement.class) instanceof CtLoop;
                addOnMessage = indexExpression instanceof CtVariableAccess ? "variable" : "expression";
                Integer valueExpression = this.getSingletonValueInt(expression);
                if (valueExpression == null) break block27;
                switch (binaryOperatorKind) {
                    case LT: 
                    case LE: 
                    case GE: {
                        if (valueExpression <= 0) {
                            WarningAdapter warning = this.rule.add((CtElement)ctBinaryOperator, indexExpression, addOnMessage);
                            for (IndexAccess i : suspiciousIndexAccesses) {
                                warning.addSourcePosition((CtElement)i.expression, this.getModule());
                            }
                            indexAccesses.removeAll(suspiciousIndexAccesses);
                            return true;
                        }
                        break block28;
                    }
                    case GT: 
                    case EQ: 
                    case NE: {
                        if (valueExpression < 0) {
                            WarningAdapter warning = this.rule.add((CtElement)ctBinaryOperator, indexExpression, addOnMessage);
                            for (IndexAccess i : suspiciousIndexAccesses) {
                                warning.addSourcePosition((CtElement)i.expression, this.getModule());
                            }
                            indexAccesses.removeAll(suspiciousIndexAccesses);
                            return true;
                        }
                        this.filterByFirstException(suspiciousIndexAccesses, ctBinaryOperator);
                        if (suspiciousIndexAccesses.isEmpty()) {
                            return false;
                        }
                        IntegerVirtualValue valueIndex = this.getValue((CtElement)indexExpression).toInteger();
                        if (valueIndex != null && valueIndex.isInterval() && valueIndex.min().toInt().isPresent() && valueIndex.min().toInt().get() >= 0) {
                            return false;
                        }
                        WarningAdapter warning = this.rule.add((CtElement)ctBinaryOperator, indexExpression, addOnMessage).setLevel(WarningLevel.LEVEL_3);
                        for (IndexAccess i : suspiciousIndexAccesses) {
                            warning.addSourcePosition((CtElement)i.expression, this.getModule());
                        }
                        indexAccesses.removeAll(suspiciousIndexAccesses);
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (expression instanceof CtInvocation || expression instanceof CtFieldRead) {
                switch (binaryOperatorKind) {
                    case LT: 
                    case GT: 
                    case LE: 
                    case GE: 
                    case EQ: 
                    case NE: {
                        if (isLoop) {
                            this.filterByFirstException(suspiciousIndexAccesses, ctBinaryOperator);
                            if (suspiciousIndexAccesses.isEmpty()) {
                                return false;
                            }
                        }
                        WarningAdapter warning = null;
                        for (IndexAccess i : suspiciousIndexAccesses) {
                            if (!Objects.equals(i.nameUpperBound, expression.toString())) continue;
                            if (warning == null) {
                                warning = this.rule.add((CtElement)ctBinaryOperator, indexExpression, addOnMessage);
                            }
                            warning.addSourcePosition((CtElement)i.expression, this.getModule());
                            indexAccesses.remove(i);
                        }
                        return warning != null;
                    }
                }
                return false;
            }
            if (expression instanceof CtVariableRead) {
                switch (binaryOperatorKind) {
                    case LT: 
                    case GT: 
                    case LE: 
                    case GE: 
                    case EQ: 
                    case NE: {
                        this.filterByFirstException(suspiciousIndexAccesses, ctBinaryOperator);
                        if (suspiciousIndexAccesses.isEmpty()) {
                            return false;
                        }
                        WarningAdapter warning = this.rule.add((CtElement)ctBinaryOperator, indexExpression, addOnMessage).setLevel(WarningLevel.LEVEL_3);
                        for (IndexAccess i : suspiciousIndexAccesses) {
                            warning.addSourcePosition((CtElement)i.expression, this.getModule());
                        }
                        indexAccesses.removeAll(suspiciousIndexAccesses);
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private void processExpression(CtExpression<?> ctExpression, List<IndexAccess> indexAccesses, List<CtBinaryOperator<?>> underBinOperators) {
        if (ctExpression instanceof CtBinaryOperator) {
            CtBinaryOperator ctBinaryOperator = (CtBinaryOperator)ctExpression;
            if (ctBinaryOperator.getKind() == BinaryOperatorKind.OR || ctBinaryOperator.getKind() == BinaryOperatorKind.AND || !RulesUtils.isBooleanOrBoxed(ctBinaryOperator)) {
                this.processExpression(ctBinaryOperator.getLeftHandOperand(), indexAccesses, underBinOperators);
                this.processExpression(ctBinaryOperator.getRightHandOperand(), indexAccesses, underBinOperators);
            } else if (!this.parseBinaryOperator(ctBinaryOperator, indexAccesses)) {
                this.processExpression(ctBinaryOperator.getLeftHandOperand(), indexAccesses, underBinOperators);
                this.processExpression(ctBinaryOperator.getRightHandOperand(), indexAccesses, underBinOperators);
            }
        } else if (ctExpression instanceof CtInvocation) {
            CtInvocation invocation = (CtInvocation)ctExpression;
            this.processExpression(invocation.getTarget(), indexAccesses, underBinOperators);
            Annotation annotation = this.getMethodAnnotation((CtAbstractInvocation<?>)invocation);
            if (!annotation.getPure()) {
                List collect = invocation.getTarget().getElements((Filter)new TypeFilter(CtVariableRead.class)).stream().filter(arg -> arg.getRoleInParent() == CtRole.TARGET && arg.getParent() instanceof CtInvocation).map(arg -> arg.getVariable().getDeclaration()).filter(Objects::nonNull).collect(Collectors.toList());
                indexAccesses.removeIf(info -> info.dependentVars.stream().anyMatch(var -> collect.stream().anyMatch(arg -> arg == var)));
            }
            if (annotation.getIndexArgument() != -1) {
                if (annotation.getIndexArgument() < 0 || annotation.getIndexArgument() >= invocation.getArguments().size()) {
                    return;
                }
                Annotation argAnnotation = this.getDataFlow().getTypeAnnotation(invocation.getTarget());
                String nameUpperBound = argAnnotation != null && argAnnotation.is(TypeClassification.String) ? String.format("%s.length()", invocation.getTarget()) : String.format("%s.size()", invocation.getTarget());
                IndexAccess indexAccess = this.createIndexAccess((CtExpression<?>)invocation, (CtExpression<?>)((CtExpression)invocation.getArguments().get(annotation.getIndexArgument())), underBinOperators, nameUpperBound);
                if (indexAccess != null) {
                    indexAccesses.add(indexAccess);
                }
            }
            for (CtExpression arg2 : invocation.getArguments()) {
                this.processExpression(arg2, indexAccesses, underBinOperators);
            }
        } else if (ctExpression instanceof CtAssignment) {
            CtAssignment assignment = (CtAssignment)ctExpression;
            this.processExpression(assignment.getAssignment(), indexAccesses, underBinOperators);
            this.processExpression(assignment.getAssigned(), indexAccesses, underBinOperators);
        } else {
            V6079Visitor visitor = new V6079Visitor(indexAccesses, underBinOperators);
            visitor.scan((CtElement)ctExpression);
        }
    }

    @Nullable
    private List<IndexAccess> processControlFlows(CtStatementList ctStatements, List<IndexAccess> indexAccesses, List<CtBinaryOperator<?>> underBinOperators) {
        return this.processControlFlows(ctStatements, indexAccesses, underBinOperators, new ArrayList());
    }

    @Nullable
    private List<IndexAccess> processControlFlows(CtStatementList ctStatements, List<IndexAccess> indexAccesses, List<CtBinaryOperator<?>> binaryOperators, List<CtVariable<?>> declVarsInCurrentBlock) {
        if (ctStatements == null) {
            return null;
        }
        ArrayList<IndexAccess> currentIndexAccess = new ArrayList<IndexAccess>(indexAccesses);
        for (CtStatement statement : ctStatements) {
            List<CtExpression<?>> expressionsInCondition;
            ArrayList<CtBinaryOperator> currentBinaryOperators;
            if (statement instanceof CtBlock) {
                this.mergeInfoBranches(currentIndexAccess, Collections.singletonList(this.processControlFlows((CtStatementList)((CtBlock)statement), currentIndexAccess, binaryOperators)));
                continue;
            }
            if (statement instanceof CtIf) {
                CtStatement elseStatement;
                CtIf ctIf = (CtIf)statement;
                CtExpression condition = ctIf.getCondition();
                currentBinaryOperators = new ArrayList<CtBinaryOperator>();
                expressionsInCondition = this.getExpressionsFromCondition(condition);
                for (CtExpression<?> expr : expressionsInCondition) {
                    if (expr instanceof CtBinaryOperator) {
                        currentBinaryOperators.add((CtBinaryOperator)expr);
                        binaryOperators.add((CtBinaryOperator)expr);
                    }
                    this.processExpression(expr, currentIndexAccess, binaryOperators);
                }
                Iterator<Object> subIndexAccesses = new ArrayList<List<IndexAccess>>();
                CtStatement thenStatement = ctIf.getThenStatement();
                if (thenStatement instanceof CtBlock) {
                    subIndexAccesses.add(this.processControlFlows((CtStatementList)((CtBlock)thenStatement), currentIndexAccess, binaryOperators));
                }
                if ((elseStatement = ctIf.getElseStatement()) instanceof CtBlock) {
                    subIndexAccesses.add(this.processControlFlows((CtStatementList)((CtBlock)elseStatement), currentIndexAccess, binaryOperators));
                }
                this.mergeInfoBranches((List<IndexAccess>)currentIndexAccess, (List<List<IndexAccess>>)((Object)subIndexAccesses));
                binaryOperators.removeIf(bin -> currentBinaryOperators.stream().anyMatch(arg -> arg == bin));
                continue;
            }
            if (statement instanceof CtSwitch) {
                CtSwitch ctSwitch = (CtSwitch)statement;
                CtExpression selector = ctSwitch.getSelector();
                this.processExpression(selector, currentIndexAccess, binaryOperators);
                List subIndexAccesses = ctSwitch.getCases().stream().map(ctCase -> this.processControlFlows((CtStatementList)ctCase, currentIndexAccess, binaryOperators)).collect(Collectors.toList());
                this.mergeInfoBranches(currentIndexAccess, subIndexAccesses);
                continue;
            }
            if (statement instanceof CtLoop) {
                CtLoop ctLoop = (CtLoop)statement;
                if (ctLoop instanceof CtFor) {
                    CtFor ctFor = (CtFor)ctLoop;
                    for (CtStatement st : ctFor.getForInit()) {
                        if (st instanceof CtExpression) {
                            this.processExpression((CtExpression)st, currentIndexAccess, binaryOperators);
                            continue;
                        }
                        if (!(st instanceof CtLocalVariable)) continue;
                        declVarsInCurrentBlock.add((CtVariable)st);
                        this.processExpression(((CtLocalVariable)st).getDefaultExpression(), currentIndexAccess, binaryOperators);
                    }
                    currentBinaryOperators = new ArrayList();
                    expressionsInCondition = this.getExpressionsFromCondition(ctFor.getExpression());
                    for (CtExpression<?> expr : expressionsInCondition) {
                        if (expr instanceof CtBinaryOperator) {
                            currentBinaryOperators.add((CtBinaryOperator)expr);
                            binaryOperators.add((CtBinaryOperator)expr);
                        }
                        this.processExpression(expr, currentIndexAccess, binaryOperators);
                    }
                    if (ctFor.getBody() instanceof CtBlock) {
                        this.mergeInfoBranches(currentIndexAccess, Collections.singletonList(this.processControlFlows((CtStatementList)((CtBlock)ctFor.getBody()), currentIndexAccess, binaryOperators, declVarsInCurrentBlock)));
                    }
                    for (CtStatement st : ctFor.getForUpdate()) {
                        if (!(st instanceof CtExpression)) continue;
                        this.processExpression((CtExpression)st, currentIndexAccess, binaryOperators);
                    }
                    binaryOperators.removeIf(bin -> currentBinaryOperators.stream().anyMatch(arg -> arg == bin));
                    continue;
                }
                if (ctLoop instanceof CtForEach) {
                    CtForEach ctForEach = (CtForEach)ctLoop;
                    declVarsInCurrentBlock.add((CtVariable<?>)ctForEach.getVariable());
                    this.processExpression(ctForEach.getExpression(), currentIndexAccess, binaryOperators);
                    if (!(ctForEach.getBody() instanceof CtBlock)) continue;
                    this.mergeInfoBranches(currentIndexAccess, Collections.singletonList(this.processControlFlows((CtStatementList)((CtBlock)ctForEach.getBody()), currentIndexAccess, binaryOperators, declVarsInCurrentBlock)));
                    continue;
                }
                if (ctLoop instanceof CtWhile) {
                    CtWhile ctWhile = (CtWhile)ctLoop;
                    currentBinaryOperators = new ArrayList();
                    expressionsInCondition = this.getExpressionsFromCondition(ctWhile.getLoopingExpression());
                    for (CtExpression<?> expr : expressionsInCondition) {
                        if (expr instanceof CtBinaryOperator) {
                            currentBinaryOperators.add((CtBinaryOperator)expr);
                            binaryOperators.add((CtBinaryOperator)expr);
                        }
                        this.processExpression(expr, currentIndexAccess, binaryOperators);
                    }
                    if (ctWhile.getBody() instanceof CtBlock) {
                        this.mergeInfoBranches(currentIndexAccess, Collections.singletonList(this.processControlFlows((CtStatementList)((CtBlock)ctWhile.getBody()), currentIndexAccess, binaryOperators)));
                    }
                    binaryOperators.removeIf(bin -> currentBinaryOperators.stream().anyMatch(arg -> arg == bin));
                    continue;
                }
                if (!(ctLoop instanceof CtDo)) continue;
                CtDo ctDo = (CtDo)ctLoop;
                if (ctDo.getBody() instanceof CtBlock) {
                    this.mergeInfoBranches(currentIndexAccess, Collections.singletonList(this.processControlFlows((CtStatementList)((CtBlock)ctDo.getBody()), currentIndexAccess, binaryOperators)));
                }
                this.processExpression(ctDo.getLoopingExpression(), currentIndexAccess, binaryOperators);
                continue;
            }
            if (statement instanceof CtSynchronized) {
                CtSynchronized ctSynchronized = (CtSynchronized)statement;
                this.mergeInfoBranches(currentIndexAccess, Collections.singletonList(this.processControlFlows((CtStatementList)ctSynchronized.getBlock(), currentIndexAccess, binaryOperators)));
                continue;
            }
            if (statement instanceof CtTry) {
                CtTry ctTry = (CtTry)statement;
                if (ctTry instanceof CtTryWithResource) {
                    CtTryWithResource ctTryWithResource = (CtTryWithResource)ctTry;
                    for (CtStatement st : ctTryWithResource.getResources()) {
                        if (!(st instanceof CtVariable)) continue;
                        CtVariable stVariable = (CtVariable)st;
                        declVarsInCurrentBlock.add(stVariable);
                        this.processExpression(stVariable.getDefaultExpression(), currentIndexAccess, binaryOperators);
                    }
                }
                this.mergeInfoBranches(currentIndexAccess, Collections.singletonList(this.processControlFlows((CtStatementList)ctTry.getBody(), currentIndexAccess, binaryOperators, declVarsInCurrentBlock)));
                List<List<IndexAccess>> subIndexAccess = ctTry.getCatchers().stream().map(ctCatch -> this.processControlFlows((CtStatementList)ctCatch.getBody(), currentIndexAccess, binaryOperators)).collect(Collectors.toList());
                this.mergeInfoBranches(currentIndexAccess, subIndexAccess);
                this.mergeInfoBranches(currentIndexAccess, Collections.singletonList(this.processControlFlows((CtStatementList)ctTry.getFinalizer(), currentIndexAccess, binaryOperators)));
                continue;
            }
            if (statement instanceof CtLocalVariable) {
                declVarsInCurrentBlock.add((CtVariable)statement);
                this.processExpression(((CtLocalVariable)statement).getDefaultExpression(), currentIndexAccess, binaryOperators);
                continue;
            }
            if (statement instanceof CtReturn) {
                CtReturn ctReturn = (CtReturn)statement;
                this.processExpression(ctReturn.getReturnedExpression(), currentIndexAccess, binaryOperators);
                return null;
            }
            if (statement instanceof CtThrow) {
                CtThrow ctThrow = (CtThrow)statement;
                this.processExpression(ctThrow.getThrownExpression(), currentIndexAccess, binaryOperators);
                return null;
            }
            if (statement instanceof CtContinue) {
                return null;
            }
            if (!(statement instanceof CtExpression)) continue;
            this.processExpression((CtExpression)statement, currentIndexAccess, binaryOperators);
        }
        currentIndexAccess.removeIf(info -> info.dependentVars.stream().anyMatch(varInfo -> declVarsInCurrentBlock.stream().anyMatch(varForRemoval -> varInfo == varForRemoval)));
        return currentIndexAccess;
    }

    public <R> void visitCtBlock(CtBlock<R> block) {
        if (!(block.getParent() instanceof CtMethod)) {
            return;
        }
        EarlyTerminatingScanner<Boolean> scanner = new EarlyTerminatingScanner<Boolean>(){

            public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
                this.setResult(true);
                this.terminate();
            }

            public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
                this.setResult(true);
                this.terminate();
            }

            public <T> void visitCtInvocation(CtInvocation<T> invocation) {
                if (V6079.this.getMethodAnnotation((CtAbstractInvocation<?>)invocation).getIndexArgument() != -1) {
                    this.setResult(true);
                    this.terminate();
                    return;
                }
                super.visitCtInvocation(invocation);
            }
        };
        scanner.scan(block);
        if (scanner.getResult() != null && ((Boolean)scanner.getResult()).booleanValue()) {
            this.processControlFlows((CtStatementList)block, (List<IndexAccess>)new ArrayList<IndexAccess>(), new ArrayList());
        }
    }

    private static class IndexAccess {
        CtExpression<?> expression;
        CtExpression<?> indexExpression;
        Set<CtVariable<?>> dependentVars = new HashSet();
        List<CtBinaryOperator<?>> underBinOperators;
        String nameUpperBound;

        IndexAccess(CtExpression<?> expression, CtExpression<?> indexExpression, List<CtBinaryOperator<?>> underBinOperators, String nameUpperBound) {
            this.expression = expression;
            this.indexExpression = indexExpression;
            this.underBinOperators = new ArrayList(underBinOperators);
            this.nameUpperBound = nameUpperBound;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IndexAccess) {
                return this.expression == ((IndexAccess)obj).expression;
            }
            return false;
        }

        public int hashCode() {
            return this.expression.hashCode();
        }
    }

    private class V6079Visitor
    extends EarlyTerminatingScanner<CtElement> {
        private final List<IndexAccess> indexAccesses;
        private final List<CtBinaryOperator<?>> underBinOperators;

        V6079Visitor(@NotNull List<IndexAccess> indexAccesses, List<CtBinaryOperator<?>> underBinOperators) {
            this.indexAccesses = indexAccesses;
            this.underBinOperators = underBinOperators;
        }

        public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
            CtVariable variable;
            if (variableRead.getRoleInParent() == CtRole.ARGUMENT && !RulesUtils.isPrimitive(variableRead) && (variable = variableRead.getVariable().getDeclaration()) != null) {
                this.indexAccesses.removeIf(info -> info.dependentVars.stream().anyMatch(arg -> variable == arg));
            }
            super.visitCtVariableRead(variableRead);
        }

        public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
            CtVariable variable = variableWrite.getVariable().getDeclaration();
            if (variable != null) {
                this.indexAccesses.removeIf(info -> info.dependentVars.stream().anyMatch(arg -> variable == arg));
            }
            super.visitCtVariableWrite(variableWrite);
        }

        public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
            this.visitArray((CtArrayAccess<?, ?>)arrayRead);
            super.visitCtArrayRead(arrayRead);
        }

        public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
            this.visitArray((CtArrayAccess<?, ?>)arrayWrite);
            super.visitCtArrayWrite(arrayWrite);
        }

        public void visitArray(CtArrayAccess<?, ?> arrayAccess) {
            String nameUpperBound = String.format("%s.length", arrayAccess.getTarget());
            IndexAccess indexAccess = V6079.this.createIndexAccess((CtExpression<?>)arrayAccess, (CtExpression<?>)arrayAccess.getIndexExpression(), this.underBinOperators, nameUpperBound);
            if (indexAccess != null) {
                this.indexAccesses.add(indexAccess);
            }
        }

        public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
            CtField variable;
            if (fieldRead.getRoleInParent() == CtRole.ARGUMENT && !RulesUtils.isPrimitive(fieldRead) && (variable = fieldRead.getVariable().getDeclaration()) != null) {
                this.indexAccesses.removeIf(arg_0 -> V6079Visitor.lambda$visitCtFieldRead$5((CtVariable)variable, arg_0));
            }
            super.visitCtFieldRead(fieldRead);
        }

        public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
            CtField variable = fieldWrite.getVariable().getDeclaration();
            if (variable != null) {
                this.indexAccesses.removeIf(arg_0 -> V6079Visitor.lambda$visitCtFieldWrite$7((CtVariable)variable, arg_0));
            }
            super.visitCtFieldWrite(fieldWrite);
        }

        public <R> void visitCtBlock(CtBlock<R> block) {
            if (!(block.getParent() instanceof CtMethod)) {
                super.visitCtBlock(block);
                return;
            }
            V6079.this.processControlFlows((CtStatementList)block, (List<IndexAccess>)new ArrayList<IndexAccess>(), new ArrayList());
        }

        private static /* synthetic */ boolean lambda$visitCtFieldWrite$7(CtVariable variable, IndexAccess info) {
            return info.dependentVars.stream().anyMatch(arg -> variable == arg);
        }

        private static /* synthetic */ boolean lambda$visitCtFieldRead$5(CtVariable variable, IndexAccess info) {
            return info.dependentVars.stream().anyMatch(arg -> variable == arg);
        }
    }
}

