/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.migration.ClassInfo;
import com.pvsstudio.migration.MethodInfo;
import com.pvsstudio.migration.MigrationUtils;
import com.pvsstudio.migration.PackageInfo;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.runner.PvsStudioAnalyzer;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import spoon.experimental.CtUnresolvedImport;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtImportKind;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.util.ModelList;

public class V6078
extends PvsStudioRule {
    private final int minJdk = 8;
    private final int maxJdk = 14;
    private Map<String, PackageInfo> migration = new HashMap<String, PackageInfo>();
    private String prefixMessage = "";
    private final Set<String> excludedPackages = new HashSet<String>();
    private final PvsStudioRule.Pattern ruleDeletedMethod = new PvsStudioRule.PatternBuilder().setMessage("%s The '%s' method will be removed.").setLevel(WarningLevel.LEVEL_1).build();
    private final PvsStudioRule.Pattern ruleDeletedClass = new PvsStudioRule.PatternBuilder().setMessage("%s The '%s' class will be removed.").setLevel(WarningLevel.LEVEL_1).build();
    private final PvsStudioRule.Pattern ruleDeletedPackage = new PvsStudioRule.PatternBuilder().setMessage("%s The '%s.*' package will be removed.").setLevel(WarningLevel.LEVEL_1).build();
    private final PvsStudioRule.Pattern ruleNotFound = new PvsStudioRule.PatternBuilder().setMessage("%s The '%s' method will be removed or its signature will be changed.").setLevel(WarningLevel.LEVEL_2).build();
    private final PvsStudioRule.Pattern ruleDeprecatedMethod = new PvsStudioRule.PatternBuilder().setMessage("%s The '%s' method will be marked as deprecated.").setLevel(WarningLevel.LEVEL_3).build();
    private final PvsStudioRule.Pattern ruleDeprecatedClass = new PvsStudioRule.PatternBuilder().setMessage("%s The '%s' class will be marked as deprecated.").setLevel(WarningLevel.LEVEL_3).build();
    private final PvsStudioRule.Pattern ruleDeprecatedPackage = new PvsStudioRule.PatternBuilder().setMessage("%s The '%s.*' package will be marked as deprecated.").setLevel(WarningLevel.LEVEL_3).build();

    @Override
    public void init(@NotNull PvsStudioAnalyzer analyzer, AnnotationService annotationService) {
        super.init(analyzer, annotationService);
        if (!this.shouldBeExecuted()) {
            return;
        }
        AnalyzerConfig config = analyzer.getConfig();
        if (config.compatibility.booleanValue()) {
            if (config.sourceJava == null || config.targetJava == null || config.sourceJava < 8 || config.targetJava > 14 || config.sourceJava > config.targetJava) {
                analyzer.getWarnings().add(new Warning(((Object)((Object)this)).getClass().getSimpleName(), String.format("Incorrectly specified versions of JDK. Supported versions of JDK: %d to %d.", 8, 14), WarningLevel.LEVEL_1));
                return;
            }
            List resourceNames = IntStream.range(config.sourceJava, config.targetJava).mapToObj(i -> String.format("%d-%d", i, i + 1)).collect(Collectors.toList());
            if (!resourceNames.isEmpty()) {
                for (String resource : resourceNames) {
                    Map<String, PackageInfo> infoFromFile = MigrationUtils.getInfoFromFile(((Object)((Object)this)).getClass().getResourceAsStream("/migration/" + resource));
                    if (infoFromFile.isEmpty()) {
                        this.migration.clear();
                        break;
                    }
                    this.migration = MigrationUtils.merge(this.migration, infoFromFile);
                }
                if (this.migration.isEmpty()) {
                    analyzer.getWarnings().add(new Warning(((Object)((Object)this)).getClass().getSimpleName(), "Load compatibility rules failed.", WarningLevel.LEVEL_1));
                }
                this.excludedPackages.addAll(config.excludePackages);
                this.prefixMessage = String.format("API compatibility issue between versions %d and %d.", config.sourceJava, config.targetJava);
            }
        }
    }

    @NotNull
    private Pair<String, String> getNamePackClass(@NotNull CtTypeReference<?> ctTypeReference) {
        String qualifiedDeclTypeName = ctTypeReference.getQualifiedName();
        int indexLastDot = qualifiedDeclTypeName.lastIndexOf(46);
        if (indexLastDot < 1 || indexLastDot > qualifiedDeclTypeName.length() - 2) {
            return new ImmutablePair((Object)"", (Object)"");
        }
        return new ImmutablePair((Object)qualifiedDeclTypeName.substring(0, indexLastDot), (Object)qualifiedDeclTypeName.substring(indexLastDot + 1));
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (this.migration.isEmpty() || invocation.isImplicit() || invocation.getExecutable() == null || invocation.getExecutable().getDeclaringType() == null) {
            return;
        }
        Pair<String, String> pair = this.getNamePackClass(invocation.getExecutable().getDeclaringType());
        String packageName = (String)pair.getLeft();
        if (this.excludedPackages.stream().anyMatch(packageName::startsWith)) {
            return;
        }
        String className = (String)pair.getRight();
        String invocationName = invocation.getExecutable().getSimpleName();
        PackageInfo packageInfo = this.migration.getOrDefault(packageName, null);
        if (packageInfo != null) {
            if (packageInfo.isDeleted()) {
                return;
            }
            ClassInfo classInfo = packageInfo.getClass(className);
            if (classInfo != null) {
                if (classInfo.isDeleted()) {
                    return;
                }
                String invocationArgs = invocation.getExecutable().getParameters().stream().map(CtTypeInformation::getQualifiedName).collect(Collectors.joining(","));
                CtTypeReference type = invocation.getExecutable().getType();
                if (type == null) {
                    return;
                }
                String invocationReturnType = type.getSimpleName();
                String fullName = String.format("%s(%s)->%s", invocationName, invocationArgs, invocationReturnType);
                MethodInfo method = classInfo.getMethod(fullName);
                if (method != null) {
                    if (method.isDeleted()) {
                        this.ruleDeletedMethod.add((CtElement)invocation, this.prefixMessage, invocationName);
                    } else if (method.isDeletedSignature()) {
                        this.ruleNotFound.add((CtElement)invocation, this.prefixMessage, invocationName);
                    } else if (method.isDeprecated()) {
                        this.ruleDeprecatedMethod.add((CtElement)invocation, this.prefixMessage, invocationName);
                    }
                }
            }
        }
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        if (this.migration.isEmpty() || !ctClass.isTopLevel()) {
            return;
        }
        if (ctClass.getPosition().isValidPosition()) {
            ModelList imports = ctClass.getPosition().getCompilationUnit().getImports();
            for (CtImport imp : imports) {
                String packageName = "";
                String className = "";
                CtImportKind importKind = imp.getImportKind();
                if (importKind == CtImportKind.UNRESOLVED) {
                    String unresolvedReference = ((CtUnresolvedImport)imp).getUnresolvedReference();
                    int indexLastDot = unresolvedReference.lastIndexOf(46);
                    if (indexLastDot < 1 || indexLastDot > unresolvedReference.length() - 1) continue;
                    List tokens = Arrays.stream(unresolvedReference.split("\\.")).filter(x -> !x.equals("*")).collect(Collectors.toList());
                    StringBuilder sbPackageName = new StringBuilder();
                    StringBuilder sbClassName = new StringBuilder();
                    for (String token : tokens) {
                        if (token.equals(token.toLowerCase()) && sbClassName.toString().isEmpty()) {
                            sbPackageName.append('.');
                            sbPackageName.append(token);
                            continue;
                        }
                        if (token.isEmpty() || !Character.isUpperCase(token.charAt(0))) break;
                        if (!sbClassName.toString().isEmpty()) {
                            sbClassName.append('$');
                        }
                        sbClassName.append(token);
                    }
                    if (sbPackageName.toString().length() > 1) {
                        packageName = sbPackageName.substring(1);
                    }
                    className = sbClassName.toString();
                } else {
                    CtReference reference = imp.getReference();
                    if (reference instanceof CtTypeReference) {
                        Pair<String, String> pair = this.getNamePackClass((CtTypeReference)reference);
                        packageName = (String)pair.getLeft();
                        className = (String)pair.getRight();
                    } else if (reference instanceof CtFieldReference) {
                        Pair<String, String> pair = this.getNamePackClass(((CtFieldReference)reference).getDeclaringType());
                        packageName = (String)pair.getLeft();
                        className = (String)pair.getRight();
                    } else if (reference instanceof CtExecutableReference) {
                        Pair<String, String> pair = this.getNamePackClass(((CtExecutableReference)reference).getDeclaringType());
                        packageName = (String)pair.getLeft();
                        className = (String)pair.getRight();
                    } else if (reference instanceof CtPackageReference) {
                        packageName = ((CtPackageReference)reference).getQualifiedName();
                    }
                }
                if (this.excludedPackages.stream().anyMatch(packageName::startsWith)) continue;
                boolean isDeprecatedPackage = false;
                boolean isDeprecatedClass = false;
                PackageInfo packageInfo = this.migration.getOrDefault(packageName, null);
                if (packageInfo == null) continue;
                if (packageInfo.isDeleted()) {
                    this.ruleDeletedPackage.add((CtElement)imp, this.prefixMessage, packageName);
                    continue;
                }
                isDeprecatedPackage = packageInfo.isDeprecated();
                ClassInfo classInfo = packageInfo.getClass(className);
                if (classInfo != null) {
                    isDeprecatedClass = classInfo.isDeprecated();
                    if (classInfo.isDeleted()) {
                        this.ruleDeletedClass.add((CtElement)imp, this.prefixMessage, className);
                        continue;
                    }
                }
                if (isDeprecatedPackage) {
                    this.ruleDeprecatedPackage.add((CtElement)imp, this.prefixMessage, packageName);
                    continue;
                }
                if (!isDeprecatedClass) continue;
                this.ruleDeprecatedClass.add((CtElement)imp, this.prefixMessage, className);
            }
        }
    }
}

