/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtLabelledFlowBreak;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6077
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(478).setSastId("CERT-MSC57-J");
    PvsStudioRule.Pattern ruleCase = this.ruleBuilder.setMessage("Label named '%s:' is present inside a switch(). It is possible that these are misprints and '%s:' label should be used instead.").build();
    PvsStudioRule.Pattern ruleDefault = this.ruleBuilder.setMessage("Label named '%s:' is present inside a switch(). It is possible that these are misprints and 'default:' label should be used instead.").build();

    private boolean isWrongLabel(@NotNull String label) {
        if (label.startsWith("case")) {
            return true;
        }
        return RulesUtils.calculateLevenshteinDistance(label, "default") == 1;
    }

    public <T> void visitCtSwitch(CtSwitch<T> switchStatement) {
        List listWrongStatements = switchStatement.getElements((Filter)new TypeFilter(CtStatement.class)).stream().filter(x -> x.getLabel() != null).filter(x -> x.getParent() instanceof CtSwitch || x.getParent() instanceof CtCase).filter(x -> this.isWrongLabel(x.getLabel())).collect(Collectors.toList());
        if (listWrongStatements.isEmpty()) {
            return;
        }
        Collections.reverse(listWrongStatements);
        List ctLabelledFlowBreaks = switchStatement.getElements((Filter)new TypeFilter(CtLabelledFlowBreak.class));
        for (CtStatement statement : listWrongStatements) {
            if (ctLabelledFlowBreaks.stream().anyMatch(x -> x.getLabelledStatement().equals((Object)statement))) continue;
            String label = statement.getLabel();
            if (label.startsWith("case")) {
                this.ruleCase.add((CtElement)statement, label, String.format("case %s", label.substring(4)));
            } else {
                if (switchStatement.getCases().stream().anyMatch(RulesUtils::isDefault)) continue;
                this.ruleDefault.add((CtElement)statement, label);
            }
            return;
        }
    }
}

