/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.FunctionClassification;
import com.pvsstudio.core.SymbolicValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.WarningAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6076
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Recurrent serialization will use cached object state from first serialization, any subsequent object modifications will not be serialized.").setExtendedMessage("Recurrent serialization will use cached state of '%s' from first serialization, any subsequent object modifications will not be serialized.").build();

    private boolean isWriteObject(CtInvocation<?> invocation) {
        return this.getMethodAnnotation((CtAbstractInvocation<?>)invocation).getName().equals("writeObject") && invocation.getExecutable() != null && invocation.getExecutable().getDeclaringType() != null && invocation.getExecutable().getDeclaringType().getQualifiedName().equals("java.io.ObjectOutputStream");
    }

    @Contract(value="null -> null")
    @Nullable
    private CtElement getDecl(CtElement element) {
        if (element instanceof CtVariableAccess) {
            return this.getDeclaration(((CtVariableAccess)element).getVariable());
        }
        if (element instanceof CtThisAccess) {
            return this.getDeclaration(((CtThisAccess)element).getType());
        }
        return null;
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (!this.isWriteObject(invocation)) {
            return;
        }
        CtElement streamObjDecl = this.getDecl((CtElement)invocation.getTarget());
        if (streamObjDecl == null) {
            return;
        }
        CtElement serializedObject = this.getDecl((CtElement)invocation.getArguments().get(0));
        if (serializedObject == null) {
            return;
        }
        SymbolicValue serObjSymbVal = this.getValue((CtElement)invocation.getArguments().get(0)).getSymbolicValue();
        Predicate<CtElement> isSerializedObject = el -> this.getDecl((CtElement)el) == serializedObject || serObjSymbVal != SymbolicValue.EMPTY && serObjSymbVal.equals(this.getValue((CtElement)el).getSymbolicValue());
        SymbolicValue streamSymbVal = this.getValue((CtElement)invocation.getTarget()).getSymbolicValue();
        Predicate<CtElement> isStreamObject = el -> this.getDecl((CtElement)el) == streamObjDecl || streamSymbVal != SymbolicValue.EMPTY && streamSymbVal.equals(this.getValue((CtElement)el).getSymbolicValue());
        List blockStatements = ((CtBlock)invocation.getParent((Filter)new TypeFilter(CtBlock.class))).getStatements();
        int firstWrObjIndex = -1;
        int secondWrObjIndex = -1;
        for (int i = blockStatements.size() - 1; i >= 0; --i) {
            CtStatement currentStatement = (CtStatement)blockStatements.get(i);
            if (currentStatement == invocation) {
                secondWrObjIndex = i;
                continue;
            }
            if (secondWrObjIndex != -1 && currentStatement instanceof CtInvocation && this.isWriteObject((CtInvocation)currentStatement) && isStreamObject.test((CtElement)((CtInvocation)currentStatement).getTarget()) && isSerializedObject.test((CtElement)((CtInvocation)currentStatement).getArguments().get(0))) {
                firstWrObjIndex = i;
            }
            if (secondWrObjIndex != -1 && firstWrObjIndex != -1) break;
        }
        if (secondWrObjIndex == -1 || firstWrObjIndex == -1) {
            return;
        }
        Predicate<CtElement> isInvModifySerObj = el -> el instanceof CtInvocation && this.getMethodAnnotation((CtAbstractInvocation)el).is(FunctionClassification.ModifiesObject) && (isSerializedObject.test((CtElement)((CtInvocation)el).getTarget()) || ((CtInvocation)el).getTarget() instanceof CtFieldRead && !((CtFieldRead)((CtInvocation)el).getTarget()).getVariable().isStatic() && isSerializedObject.test((CtElement)((CtFieldRead)((CtInvocation)el).getTarget()).getTarget()));
        Predicate<CtElement> isChangeSerObjFields = el -> el instanceof CtFieldWrite && !((CtFieldWrite)el).getVariable().isStatic() && isSerializedObject.test((CtElement)((CtFieldWrite)el).getTarget());
        Predicate<CtElement> isSerObjReset = el -> el instanceof CtInvocation && this.getMethodAnnotation((CtAbstractInvocation<?>)((CtInvocation)el)).getName().equals("reset") && ((CtInvocation)el).getTarget() instanceof CtVariableRead && isStreamObject.test((CtElement)((CtInvocation)el).getTarget());
        Predicate<CtElement> isSerObjAssignments = el -> el instanceof CtAssignment && ((CtAssignment)el).getAssigned() instanceof CtVariableWrite && !this.getValue((CtElement)((CtAssignment)el).getAssigned()).equals(this.getValue((CtElement)((CtAssignment)el).getAssignment())) && isSerializedObject.test((CtElement)((CtAssignment)el).getAssigned());
        ArrayList<CtInvocation> invModifySerObj = new ArrayList<CtInvocation>();
        ArrayList<CtFieldWrite> serObjFieldsChanges = new ArrayList<CtFieldWrite>();
        for (CtStatement statement : blockStatements.subList(firstWrObjIndex + 1, secondWrObjIndex)) {
            for (CtElement currentStatement : statement.asIterable()) {
                if (currentStatement instanceof CtInvocation) {
                    if (isSerObjReset.test(currentStatement)) {
                        return;
                    }
                    if (!isInvModifySerObj.test(currentStatement)) continue;
                    invModifySerObj.add((CtInvocation)currentStatement);
                    continue;
                }
                if (currentStatement instanceof CtFieldWrite && isChangeSerObjFields.test(currentStatement)) {
                    serObjFieldsChanges.add((CtFieldWrite)currentStatement);
                    continue;
                }
                if (!(currentStatement instanceof CtAssignment) || !isSerObjAssignments.test(currentStatement)) continue;
                return;
            }
        }
        if (!invModifySerObj.isEmpty() || !serObjFieldsChanges.isEmpty()) {
            WarningAdapter warning = this.rule.add((CtElement)blockStatements.get(secondWrObjIndex), serializedObject instanceof CtType ? "this" : ((CtVariable)serializedObject).getSimpleName());
            for (CtInvocation inv : invModifySerObj) {
                warning.addSourcePosition((CtElement)inv.getTarget(), this.getModule());
            }
            for (CtFieldWrite field : serObjFieldsChanges) {
                warning.addSourcePosition((CtElement)field, this.getModule());
            }
        }
    }
}

