/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtTypeReference;

public class V6075
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("The signature of method 'X' does not conform to serialization requirements.").setExtendedMessage("The signature of method '%s' does not conform to serialization requirements.").setLevel(WarningLevel.LEVEL_1).setCwe(684).setSastId("CERT-SER01-J").build();

    private List<CtMethod<?>> getSpecificMethods(@NotNull Set<CtMethod<?>> methods) {
        List<String> specificMethods = Arrays.asList("readObject", "writeObject", "readObjectNoData", "readResolve", "writeReplace");
        return methods.stream().filter(met -> specificMethods.contains(met.getSimpleName())).collect(Collectors.toList());
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        CtTypeReference serializableType;
        List<CtMethod<?>> methods = this.getSpecificMethods(ctClass.getMethods());
        if (methods.isEmpty()) {
            return;
        }
        if (ctClass.getSuperInterfaces().stream().noneMatch(i -> i.getQualifiedName().equals("java.io.Serializable")) && !ctClass.isSubtypeOf(serializableType = ctClass.getFactory().createReference("java.io.Serializable"))) {
            return;
        }
        block13: for (CtMethod<?> method : methods) {
            String name;
            if (this.isAnnotated("Override")) continue;
            switch (name = method.getSimpleName()) {
                case "readObject": {
                    CtParameter param;
                    if (method.getType().equals((Object)method.getFactory().Type().voidPrimitiveType()) && method.getParameters().size() == 1 && (param = (CtParameter)method.getParameters().get(0)).getType() != null && param.getType().getQualifiedName().equals("java.io.ObjectInputStream") && (!method.isPrivate() || method.isStatic())) break;
                    continue block13;
                }
                case "writeObject": {
                    CtParameter param;
                    if (method.getType().equals((Object)method.getFactory().Type().voidPrimitiveType()) && method.getParameters().size() == 1 && (param = (CtParameter)method.getParameters().get(0)).getType() != null && param.getType().getQualifiedName().equals("java.io.ObjectOutputStream") && (!method.isPrivate() || method.isStatic())) break;
                    continue block13;
                }
                case "readObjectNoData": {
                    if (method.getType().equals((Object)method.getFactory().Type().voidPrimitiveType()) && method.getParameters().isEmpty() && (!method.isPrivate() || method.isStatic())) break;
                    continue block13;
                }
                case "readResolve": 
                case "writeReplace": {
                    if (method.getParameters().isEmpty() && (method.isStatic() || !method.getType().equals((Object)method.getFactory().Type().objectType()))) break;
                    continue block13;
                }
                default: {
                    continue block13;
                }
            }
            this.rule.add((CtElement)method, method.getSimpleName());
        }
    }
}

