/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.stream.Collectors;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6074
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Non-atomic modification of volatile variable.").setExtendedMessage("Non-atomic modification of volatile variable. Inspect '%s'.").setLevel(WarningLevel.LEVEL_2).setCwe(567).setSastId("CERT-VNA02-J").setSecId("SEC-SYNCHRONIZATION").build();

    private boolean isDependsSelf(CtFieldWrite<?> fieldWrite) {
        UnaryOperatorKind operatorKind;
        if (fieldWrite.getParent() instanceof CtOperatorAssignment) {
            return true;
        }
        if (fieldWrite.getParent() instanceof CtUnaryOperator && ((operatorKind = ((CtUnaryOperator)fieldWrite.getParent()).getKind()) == UnaryOperatorKind.POSTINC || operatorKind == UnaryOperatorKind.PREINC || operatorKind == UnaryOperatorKind.POSTDEC || operatorKind == UnaryOperatorKind.PREDEC)) {
            return true;
        }
        return ((CtStatement)fieldWrite.getParent(CtStatement.class)).getElements((Filter)new TypeFilter(CtFieldRead.class)).stream().anyMatch(f -> f.getVariable().equals((Object)fieldWrite.getVariable()) && RulesUtils.equals((CtElement)f.getTarget(), (CtElement)fieldWrite.getTarget()));
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        List fields = ctClass.getFields().stream().filter(f -> f.getModifiers().contains(ModifierKind.VOLATILE)).collect(Collectors.toList());
        if (fields.isEmpty()) {
            return;
        }
        List listFieldWrites = ctClass.getElements((Filter)new TypeFilter(CtFieldWrite.class)).stream().filter(f -> fields.contains(f.getVariable().getFieldDeclaration())).collect(Collectors.toList());
        for (CtFieldWrite fieldWrite : listFieldWrites) {
            if (!this.isDependsSelf(fieldWrite) || fieldWrite.getParent(CtSynchronized.class) != null) continue;
            CtMethod curMethod = (CtMethod)fieldWrite.getParent(CtMethod.class);
            if (curMethod != null) {
                if (curMethod.getModifiers().contains(ModifierKind.SYNCHRONIZED)) continue;
                List invLocks = curMethod.getBody().getElements((Filter)new TypeFilter(CtAbstractInvocation.class)).stream().filter(inv -> RulesUtils.getQualifiedName(inv).contains("java.util.concurrent.locks")).collect(Collectors.toList());
                if (invLocks.size() > 1) {
                    SourcePosition spInv1 = ((CtAbstractInvocation)invLocks.get(0)).getPosition();
                    SourcePosition spInv2 = ((CtAbstractInvocation)invLocks.get(1)).getPosition();
                    SourcePosition spField = fieldWrite.getPosition();
                    if (spInv1.isValidPosition() && spInv2.isValidPosition() && spField.isValidPosition() && spInv1.getLine() < spField.getLine() && spField.getLine() < spInv2.getLine()) continue;
                }
            }
            this.rule.add((CtElement)fieldWrite, fieldWrite.getVariable().getSimpleName());
        }
    }
}

