/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Result;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6073
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder(this).setCwe(684);
    private final PvsStudioRule.Pattern ruleReturnNull = this.ruleBuilder.setMessage("It is not recommended to return null from '%s' method.").setSastId("CERT-EXP01-J").build();
    private final PvsStudioRule.Pattern ruleThrowException = this.ruleBuilder.setMessage("It is not recommended to throw exceptions from '%s' method.").build();
    private MethodType methodType = null;

    private boolean isOverridingToStringOrClone(CtMethod<?> method) {
        if (method.getParameters().isEmpty() && !method.isAbstract() && !method.isStatic()) {
            if (method.getSimpleName().equals("toString")) {
                this.methodType = MethodType.toString;
            } else if (method.getSimpleName().equals("clone")) {
                this.methodType = MethodType.clone;
            }
        }
        return this.methodType != null;
    }

    private boolean isStubMethod(CtBlock<?> ctBlock) {
        CtMethod method = (CtMethod)ctBlock.getParent();
        return method != null && ctBlock.getStatements().size() == 1 && ctBlock.getStatements().get(0) instanceof CtThrow;
    }

    public <R> void visitCtBlock(CtBlock<R> block) {
        this.methodType = null;
        CtElement parent = block.getParent();
        if (parent instanceof CtMethod && this.isOverridingToStringOrClone((CtMethod)parent)) {
            if (this.methodType == MethodType.clone && this.isStubMethod(block)) {
                return;
            }
            List throwList = block.getElements((Filter)new TypeFilter(CtThrow.class));
            List returnList = block.getElements((Filter)new TypeFilter(CtReturn.class));
            for (CtThrow ctThrow : throwList) {
                this.applyToThrow(ctThrow);
            }
            for (CtReturn ctReturn : returnList) {
                this.applyToReturn(ctReturn);
            }
        }
    }

    private boolean containsInMethodThrows(CtTypeReference<? extends Throwable> exceptionTypeReference) {
        CtMethod method = (CtMethod)this.getCurrentMethod();
        if (method != null) {
            Set thrownTypes = method.getThrownTypes();
            if (!thrownTypes.contains(exceptionTypeReference)) {
                return thrownTypes.stream().anyMatch(arg_0 -> exceptionTypeReference.isSubtypeOf(arg_0));
            }
            return true;
        }
        return false;
    }

    private void applyToThrow(CtThrow throwStatement) {
        CtElement result = this.rememberCurrentTryOrCatch(throwStatement);
        if (result instanceof CtTry) {
            CtType<?> ctType = this.getType(throwStatement.getThrownExpression());
            if (ctType != null && !this.isThrowCaught(ctType.getReference(), (CtTry)result)) {
                this.addThrowWarnings(throwStatement);
            }
            return;
        }
        if (result instanceof CtCatch && this.methodType == MethodType.toString) {
            this.addThrowWarnings(throwStatement);
            return;
        }
        if (result instanceof CtCatch && this.methodType == MethodType.clone) {
            return;
        }
        this.addThrowWarnings(throwStatement);
    }

    @Nullable
    private CtElement rememberCurrentTryOrCatch(CtThrow throwStatement) {
        CtElement parent = throwStatement.getParent();
        do {
            if (parent instanceof CtCatch) {
                return parent;
            }
            if (!(parent instanceof CtTry)) continue;
            return parent;
        } while (!((parent = parent.getParent()) instanceof CtMethod));
        return null;
    }

    private boolean isCloneNotSupported(CtExpression<? extends Throwable> throwExpression) {
        return throwExpression.getType().isSubtypeOf(throwExpression.getFactory().createCtTypeReference(CloneNotSupportedException.class));
    }

    private boolean isThrowCaught(CtTypeReference<?> throwType, CtTry ctTry) {
        return ctTry.getCatchers().stream().anyMatch(ctCatch -> throwType.isSubtypeOf(ctCatch.getParameter().getType()));
    }

    private void addThrowWarnings(CtThrow throwStatement) {
        if (this.methodType == MethodType.clone) {
            if (!this.containsInMethodThrows((CtTypeReference<? extends Throwable>)throwStatement.getThrownExpression().getType())) {
                this.ruleThrowException.add((CtElement)throwStatement, new Object[]{this.methodType}).setLevel(WarningLevel.LEVEL_3);
            }
        } else {
            this.ruleThrowException.add((CtElement)throwStatement, new Object[]{this.methodType}).setLevel(WarningLevel.LEVEL_3);
        }
    }

    private void applyToReturn(CtReturn<?> returnStatement) {
        CtExpression expression = returnStatement.getReturnedExpression();
        if (this.getValue((CtElement)expression).isNullPointer()) {
            this.addReturnWarnings(returnStatement, null);
        } else if (expression instanceof CtConditional) {
            if (this.conditionalMayBeNull((CtConditional)expression)) {
                this.addReturnWarnings(returnStatement, null);
            }
        } else if (expression instanceof CtInvocation && this.getValue((CtElement)expression).toPointer() != null && this.getValue((CtElement)expression).toPointer().isPotentialNullPointer()) {
            this.addReturnWarnings(returnStatement, (CtInvocation)expression);
        }
    }

    private boolean conditionalMayBeNull(CtConditional<?> conditional) {
        CtExpression thenExp = conditional.getThenExpression();
        CtExpression elseExp = conditional.getElseExpression();
        if (!(thenExp instanceof CtConditional) && this.getValue((CtElement)thenExp).isNullPointer() || !(elseExp instanceof CtConditional) && this.getValue((CtElement)elseExp).isNullPointer()) {
            return true;
        }
        if (thenExp instanceof CtConditional && this.conditionalMayBeNull((CtConditional)thenExp)) {
            return true;
        }
        return elseExp instanceof CtConditional && this.conditionalMayBeNull((CtConditional)elseExp);
    }

    private void addReturnWarnings(CtReturn<?> returnStatement, CtInvocation<?> invocation) {
        WarningAdapter warning = this.ruleReturnNull.add((CtElement)returnStatement, new Object[]{this.methodType});
        if (invocation != null) {
            if (this.isAnnotated("Nullable")) {
                warning.setLevel(WarningLevel.LEVEL_3);
            } else {
                Result constrainsRes = this.constraints().notNull(this.getValue((CtElement)invocation), this.getDataFlow().getExpressionIndex((CtElement)invocation));
                if (constrainsRes == Result.Level1 || constrainsRes == Result.Level2) {
                    warning.setLevel(WarningLevel.LEVEL_2);
                } else if (constrainsRes == Result.Level3) {
                    warning.setLevel(WarningLevel.LEVEL_3);
                }
            }
        } else {
            warning.setLevel(this.isAnnotated("Nullable") ? WarningLevel.LEVEL_3 : WarningLevel.LEVEL_2);
        }
    }

    private static enum MethodType {
        clone,
        toString;

    }
}

