/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.visitor.Filter;

public class V6072
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Two similar code fragments were found. Perhaps, this is a typo and '%s' variable should be used instead of '%s'.").setCwe(682).build();
    Boolean copyDirection = null;
    private final int maxAnalyzedBlockLines = 25;
    private final Filter<CtElement> variableFilter = el -> el instanceof CtVariableAccess || el instanceof CtVariable;
    List<NodeInfo> nodesInfo = new ArrayList<NodeInfo>();
    int countReplaces = 0;
    private final int maxReplaces = 3;
    private WarningLevel warningLevel;

    public <R> void visitCtBlock(CtBlock<R> block) {
        this.warningLevel = null;
        this.nodesInfo.clear();
        for (CtElement element : block.getStatements()) {
            this.nodesInfo.add(new NodeInfo(element));
        }
        ArrayList<VariableInfo> mainBlockVariables = new ArrayList<VariableInfo>();
        ArrayList<VariableInfo> subBlockVariables = new ArrayList<VariableInfo>();
        for (int blockSize = 1; blockSize <= this.nodesInfo.size() / 2 && blockSize <= 25; ++blockSize) {
            block2: for (int walk = 0; walk < this.nodesInfo.size() - (blockSize - 1 + blockSize); ++walk) {
                VariablePairInfo warning;
                mainBlockVariables.clear();
                subBlockVariables.clear();
                int indexStart1 = walk;
                int indexEnd1 = walk + blockSize - 1;
                int indexStart2 = walk + blockSize;
                int indexEnd2 = walk + blockSize + blockSize - 1;
                for (int i = indexStart1; i < indexEnd1; ++i) {
                    SourcePosition mainPos1 = this.nodesInfo.get((int)i).ctElement.getPosition();
                    SourcePosition mainPos2 = this.nodesInfo.get((int)(i + 1)).ctElement.getPosition();
                    SourcePosition subPos1 = this.nodesInfo.get((int)(i + blockSize)).ctElement.getPosition();
                    SourcePosition subPos2 = this.nodesInfo.get((int)(i + blockSize + 1)).ctElement.getPosition();
                    if (!(mainPos1 instanceof NoSourcePosition) && !(mainPos2 instanceof NoSourcePosition) && !(subPos1 instanceof NoSourcePosition) && !(subPos2 instanceof NoSourcePosition) && (mainPos1.getEndLine() + 1 != mainPos2.getLine() || subPos1.getEndLine() + 1 != subPos2.getLine())) continue block2;
                }
                SourcePosition start1 = this.nodesInfo.get((int)indexStart1).ctElement.getPosition();
                SourcePosition end1 = this.nodesInfo.get((int)indexEnd1).ctElement.getPosition();
                SourcePosition start2 = this.nodesInfo.get((int)indexStart2).ctElement.getPosition();
                SourcePosition end2 = this.nodesInfo.get((int)indexEnd2).ctElement.getPosition();
                if (!(start1 instanceof NoSourcePosition) && !(start2 instanceof NoSourcePosition) && !(end1 instanceof NoSourcePosition) && !(end2 instanceof NoSourcePosition) && (end1.getEndLine() - start1.getLine() != end2.getEndLine() - start2.getLine() || end1.getEndLine() == start2.getLine())) continue;
                for (int i = indexStart1; i <= indexEnd1; ++i) {
                    NodeInfo mainNodeInfo = this.nodesInfo.get(i);
                    NodeInfo subNodeInfo = this.nodesInfo.get(i + blockSize);
                    SourcePosition mainPosition = mainNodeInfo.ctElement.getPosition();
                    SourcePosition subPosition = subNodeInfo.ctElement.getPosition();
                    if (!(mainPosition instanceof NoSourcePosition) && !(subPosition instanceof NoSourcePosition) && subPosition.getLine() - mainPosition.getLine() != subPosition.getEndLine() - mainPosition.getEndLine() || !this.partialComparePairNodes(mainNodeInfo, subNodeInfo)) continue block2;
                    mainBlockVariables.addAll(mainNodeInfo.getVariableInfoList());
                    subBlockVariables.addAll(subNodeInfo.getVariableInfoList());
                }
                if (mainBlockVariables.size() != subBlockVariables.size()) continue;
                if (indexStart1 == 0 && indexEnd2 != this.nodesInfo.size() - 1) {
                    if (this.fullComparePairNodes(this.nodesInfo.get(indexEnd2), this.nodesInfo.get(indexEnd2 + 1)) && this.compareAllNodesInBlock(0, blockSize * 2)) {
                        continue;
                    }
                } else if (indexStart1 == 0 || indexEnd2 != this.nodesInfo.size() - 1 ? indexStart1 != 0 && indexEnd2 != this.nodesInfo.size() - 1 && this.fullComparePairNodes(this.nodesInfo.get(indexEnd2), this.nodesInfo.get(indexStart1)) && (this.fullComparePairNodes(this.nodesInfo.get(indexEnd2), this.nodesInfo.get(indexEnd2 + 1)) || this.fullComparePairNodes(this.nodesInfo.get(indexStart1), this.nodesInfo.get(indexStart1 - 1))) && this.compareAllNodesInBlock(indexStart1, blockSize * 2) : this.fullComparePairNodes(this.nodesInfo.get(indexStart1), this.nodesInfo.get(indexStart1 - 1)) && this.compareAllNodesInBlock(this.nodesInfo.size() - 2 * blockSize, blockSize * 2)) continue;
                if ((warning = this.findRulesWarnings(mainBlockVariables, subBlockVariables)) == null) continue;
                ArrayList<NodeInfo> mainNodesInfo = new ArrayList<NodeInfo>();
                ArrayList<NodeInfo> subNodesInfo = new ArrayList<NodeInfo>();
                for (int i = indexStart1; i <= indexEnd1; ++i) {
                    mainNodesInfo.add(this.nodesInfo.get(i));
                    subNodesInfo.add(this.nodesInfo.get(i + blockSize));
                }
                if (!this.fullCompareBlocks(mainNodesInfo, subNodesInfo)) continue;
                if (this.warningLevel == null) {
                    this.warningLevel = this.countReplaces == 3 ? WarningLevel.LEVEL_3 : WarningLevel.LEVEL_2;
                }
                CtElement mainBlockStart = this.nodesInfo.get((int)indexStart1).ctElement;
                CtElement mainBlockEnd = this.nodesInfo.get((int)indexEnd1).ctElement;
                CtElement subBlockStart = this.nodesInfo.get((int)indexStart2).ctElement;
                CtElement subBlockEnd = this.nodesInfo.get((int)indexEnd2).ctElement;
                if (this.copyDirection.booleanValue()) {
                    this.rule.add(warning.subVarInfo.ctElement, warning.subVarInfo.name, warning.mainVarInfo.name).addSourcePosition(warning.mainVarInfo.ctElement, this.getModule()).addSourcePosition(mainBlockStart, mainBlockEnd, this.getModule()).addSourcePosition(subBlockStart, subBlockEnd, this.getModule()).setLevel(this.warningLevel);
                    continue;
                }
                this.rule.add(warning.mainVarInfo.ctElement, warning.mainVarInfo.name, warning.subVarInfo.name).addSourcePosition(warning.subVarInfo.ctElement, this.getModule()).addSourcePosition(mainBlockStart, mainBlockEnd, this.getModule()).addSourcePosition(subBlockStart, subBlockEnd, this.getModule()).setLevel(this.warningLevel);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private VariablePairInfo findRulesWarnings(List<VariableInfo> mainBlockVariables, List<VariableInfo> subBlockVariables) {
        void var9_14;
        List rightKeys;
        List leftKeys;
        if (mainBlockVariables.isEmpty() && subBlockVariables.isEmpty()) {
            return null;
        }
        this.copyDirection = null;
        ArrayList<VariablePairInfo> equalIdentifiers = new ArrayList<VariablePairInfo>();
        ArrayList<VariablePairInfo> notEqualIdentifiers = new ArrayList<VariablePairInfo>();
        for (int i = 0; i < mainBlockVariables.size(); ++i) {
            VariableInfo mainVarInfo = mainBlockVariables.get(i);
            VariableInfo subVarInfo = subBlockVariables.get(i);
            if (mainVarInfo.name.equals(subVarInfo.name)) {
                equalIdentifiers.add(new VariablePairInfo(mainVarInfo, subVarInfo));
                continue;
            }
            notEqualIdentifiers.add(new VariablePairInfo(mainVarInfo, subVarInfo));
        }
        HashSet<String> mainVarNames = new HashSet<String>();
        HashSet<String> subVarNames = new HashSet<String>();
        HashSet<CallSite> replaces = new HashSet<CallSite>();
        for (VariablePairInfo variablePairInfo : notEqualIdentifiers) {
            mainVarNames.add(variablePairInfo.mainToString());
            subVarNames.add(variablePairInfo.subToString());
            replaces.add((CallSite)((Object)(variablePairInfo.mainToString() + "|" + variablePairInfo.subToString())));
        }
        if (replaces.size() > 3 || mainVarNames.size() != subVarNames.size() || mainVarNames.removeAll(subVarNames)) {
            return null;
        }
        ArrayList<VariablePairInfo> foundOnce = new ArrayList<VariablePairInfo>();
        for (VariablePairInfo info : equalIdentifiers) {
            List equals = equalIdentifiers.stream().filter(p -> p.mainFullEquals(info)).collect(Collectors.toList());
            if (equals.size() == 1) {
                foundOnce.add((VariablePairInfo)equals.get(0));
                continue;
            }
            if (equals.size() > 1) {
                leftKeys = notEqualIdentifiers.stream().filter(p -> p.mainFullEquals(info)).collect(Collectors.toList());
                if (!leftKeys.isEmpty()) {
                    return null;
                }
                rightKeys = notEqualIdentifiers.stream().filter(p -> p.subFullEquals(info)).collect(Collectors.toList());
                if (rightKeys.isEmpty()) continue;
                return null;
            }
            return null;
        }
        for (VariablePairInfo compareInfo : notEqualIdentifiers) {
            if (notEqualIdentifiers.stream().filter(p -> p.mainFullEquals(compareInfo)).allMatch(p -> p.subNameEquals(compareInfo)) && notEqualIdentifiers.stream().filter(p -> p.subFullEquals(compareInfo)).allMatch(p -> p.mainNameEquals(compareInfo))) continue;
            return null;
        }
        Object var9_13 = null;
        for (VariablePairInfo info : foundOnce) {
            VariablePairInfo replacesInfo;
            leftKeys = notEqualIdentifiers.stream().filter(p -> p.mainFullEquals(info)).collect(Collectors.toList());
            rightKeys = notEqualIdentifiers.stream().filter(p -> p.subFullEquals(info)).collect(Collectors.toList());
            if (foundOnce.size() == 1 && (leftKeys.size() >= 3 || rightKeys.size() >= 3)) {
                this.warningLevel = WarningLevel.LEVEL_1;
            }
            if (leftKeys.size() > 1 && rightKeys.isEmpty()) {
                if (this.copyDirection == null || this.copyDirection.booleanValue()) {
                    this.copyDirection = true;
                    if (var9_14 != null) continue;
                    replacesInfo = (VariablePairInfo)leftKeys.get(0);
                    VariablePairInfo variablePairInfo = new VariablePairInfo(new VariableInfo(replacesInfo.mainVarInfo.name, info.mainVarInfo.ctElement), new VariableInfo(replacesInfo.subVarInfo.name, info.subVarInfo.ctElement));
                    continue;
                }
                return null;
            }
            if (rightKeys.size() > 1 && leftKeys.isEmpty()) {
                if (this.copyDirection == null || !this.copyDirection.booleanValue()) {
                    this.copyDirection = false;
                    if (var9_14 != null) continue;
                    replacesInfo = (VariablePairInfo)rightKeys.get(0);
                    VariablePairInfo variablePairInfo = new VariablePairInfo(new VariableInfo(replacesInfo.mainVarInfo.name, info.mainVarInfo.ctElement), new VariableInfo(replacesInfo.subVarInfo.name, info.subVarInfo.ctElement));
                    continue;
                }
                return null;
            }
            if (leftKeys.isEmpty() && rightKeys.isEmpty()) continue;
            return null;
        }
        this.countReplaces = replaces.size();
        return var9_14;
    }

    public boolean fullCompareBlocks(List<NodeInfo> main, List<NodeInfo> sub) {
        if (main.size() != sub.size()) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < main.size(); ++i) {
            result &= this.fullComparePairNodes(main.get(i), sub.get(i));
        }
        return result;
    }

    private boolean partialComparePairNodes(NodeInfo main, NodeInfo sub) {
        if (main.getVariableInfoList().size() != sub.getVariableInfoList().size() || main.getAllNodes().size() != sub.getAllNodes().size()) {
            return false;
        }
        for (int i = 0; i < main.getAllNodes().size(); ++i) {
            CtElement mainNode = main.getAllNodes().get(i);
            CtElement subNode = sub.getAllNodes().get(i);
            if (mainNode.getClass() == subNode.getClass() && mainNode.getRoleInParent() == subNode.getRoleInParent()) continue;
            return false;
        }
        return true;
    }

    private boolean fullComparePairNodes(NodeInfo main, NodeInfo sub) {
        return RulesUtils.equals(main.getCloneElement(), sub.getCloneElement());
    }

    private boolean compareAllNodesInBlock(int startIndex, int blockNodesCount) {
        boolean allNodesSameWithoutIdentifiers = true;
        int endIndex = startIndex + blockNodesCount - 1;
        for (int i = startIndex; i < endIndex; ++i) {
            allNodesSameWithoutIdentifiers &= this.fullComparePairNodes(this.nodesInfo.get(i), this.nodesInfo.get(i + 1));
        }
        return allNodesSameWithoutIdentifiers;
    }

    private final class NodeInfo {
        private CtElement cloneElement;
        private List<VariableInfo> variableInfoList;
        private List<CtElement> allNodes;
        final CtElement ctElement;

        public CtElement getCloneElement() {
            if (this.cloneElement == null) {
                this.cloneElement = this.ctElement.clone();
                this.cloneElement.getElements(V6072.this.variableFilter).forEach(el -> {
                    if (el instanceof CtVariableAccess) {
                        ((CtVariableAccess)el).getVariable().setSimpleName("temp");
                    }
                    if (el instanceof CtVariable) {
                        ((CtVariable)el).setSimpleName("temp");
                    }
                });
            }
            return this.cloneElement;
        }

        public List<VariableInfo> getVariableInfoList() {
            if (this.variableInfoList == null) {
                this.variableInfoList = this.ctElement.getElements(V6072.this.variableFilter).stream().map(el -> new VariableInfo(el instanceof CtVariableAccess ? ((CtVariableAccess)el).getVariable().getSimpleName() : ((CtVariable)el).getSimpleName(), (CtElement)el)).collect(Collectors.toList());
            }
            return this.variableInfoList;
        }

        public List<CtElement> getAllNodes() {
            if (this.allNodes == null) {
                this.allNodes = this.ctElement.getElements(el -> true);
            }
            return this.allNodes;
        }

        NodeInfo(CtElement element) {
            this.ctElement = element;
        }
    }

    private static final class VariablePairInfo {
        public final VariableInfo mainVarInfo;
        public final VariableInfo subVarInfo;

        VariablePairInfo(VariableInfo mainVarInfo, VariableInfo subVarInfo) {
            this.mainVarInfo = mainVarInfo;
            this.subVarInfo = subVarInfo;
        }

        boolean mainFullEquals(VariablePairInfo pairInfo) {
            return this.mainVarInfo.name.equals(pairInfo.mainVarInfo.name) && this.mainVarInfo.type == pairInfo.mainVarInfo.type;
        }

        boolean subFullEquals(VariablePairInfo pairInfo) {
            return this.subVarInfo.name.equals(pairInfo.subVarInfo.name) && this.subVarInfo.type == pairInfo.subVarInfo.type;
        }

        boolean mainNameEquals(VariablePairInfo pairInfo) {
            return this.mainVarInfo.name.equals(pairInfo.mainVarInfo.name);
        }

        boolean subNameEquals(VariablePairInfo pairInfo) {
            return this.subVarInfo.name.equals(pairInfo.subVarInfo.name);
        }

        String mainToString() {
            return this.mainVarInfo.name + ":" + this.mainVarInfo.type.ordinal();
        }

        String subToString() {
            return this.subVarInfo.name + ":" + this.subVarInfo.type.ordinal();
        }
    }

    private static final class VariableInfo {
        public final String name;
        public final CtElement ctElement;
        public VariableType type = null;

        public VariableType getType() {
            return this.type;
        }

        VariableInfo(String name, CtElement element) {
            this.name = name;
            this.ctElement = element;
            if (element instanceof CtFieldAccess || element instanceof CtField) {
                this.type = VariableType.Field;
                return;
            }
            if (element instanceof CtVariableAccess || element instanceof CtVariable) {
                this.type = VariableType.Variable;
            }
        }
    }

    private static enum VariableType {
        Field,
        Variable;

    }
}

