/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.projects.Module;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.NavigationInfo;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningLevel;
import com.pvsstudio.warnings.WarningPosition;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import spoon.reflect.code.CtComment;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtType;

public class V6071
extends PvsStudioRule {
    private static final String message = "This file is marked with copyleft license, which requires you to open the derived source code.";
    private static final List<String> patterns = new ArrayList<String>();
    private static final Pattern openSourceLicensePattern;

    private <T> void checkOpenSourceLicense(CtType<T> ctType) {
        if (!ctType.isTopLevel()) {
            return;
        }
        List fileComments = this.getModule().getComments(ctType.getPosition().getFile()).stream().filter(c -> c.getCommentType() == CtComment.CommentType.FILE).collect(Collectors.toList());
        for (CtComment comment : fileComments) {
            Matcher matcher = openSourceLicensePattern.matcher("");
            WarningPosition commentPosition = RulesUtils.getPosition((CtElement)comment, this.getModule());
            if (commentPosition == WarningPosition.INVALID_POSITION) {
                return;
            }
            int indexLineInComment = 0;
            Module module = this.getModule();
            for (String commentLine : comment.getRawContent().split("\n")) {
                matcher.reset(commentLine);
                if (matcher.find() && commentPosition.file != null) {
                    File commentPositionFile = new File(commentPosition.file);
                    int lineNumber = commentPosition.line + indexLineInComment;
                    NavigationInfo navigationInfo = new NavigationInfo(module.getLine(commentPositionFile, lineNumber - 1).orElse(""), module.getLine(commentPositionFile, lineNumber).orElse(""), module.getLine(commentPositionFile, lineNumber + 1).orElse(""));
                    WarningPosition warningPosition = new WarningPosition(commentPosition.file, lineNumber, lineNumber, 1, commentLine.length(), navigationInfo);
                    this.getAnalyzer().getWarnings().add(new Warning(this.getName(), message, WarningLevel.LEVEL_1, warningPosition));
                    return;
                }
                ++indexLineInComment;
            }
        }
    }

    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.checkOpenSourceLicense((CtType)annotationType);
    }

    public <T> void visitCtInterface(CtInterface<T> ctInterface) {
        this.checkOpenSourceLicense((CtType<T>)ctInterface);
    }

    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.checkOpenSourceLicense((CtType<T>)ctEnum);
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.checkOpenSourceLicense((CtType<T>)ctClass);
    }

    static {
        patterns.add("GPL");
        patterns.add("General Public License");
        patterns.add("http://www.gnu.org/licenses/");
        openSourceLicensePattern = Pattern.compile(String.join((CharSequence)"|", patterns));
    }
}

