/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6070
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder(this).setCwe(662).setSastId("CERT-LCK01-J");
    private final PvsStudioRule.Pattern thisRule = this.ruleBuilder.setMessage("Unsafe synchronization on 'this' instance in class '%s'.").build();
    private final PvsStudioRule.Pattern rule = this.ruleBuilder.setSecId("SEC-SYNCHRONIZATION").setMessage("Unsafe synchronization on an object of the '%s' type.").build();

    public void visitCtSynchronized(CtSynchronized synchro) {
        CtExpression expr = synchro.getExpression();
        CtTypeReference<?> targetType = RulesUtils.getType(expr);
        if (targetType == null) {
            return;
        }
        if (expr instanceof CtLiteral && RulesUtils.getTypeName(expr).equals("java.lang.String")) {
            this.rule.add((CtElement)expr, expr.getType().getSimpleName()).setLevel(WarningLevel.LEVEL_2);
            return;
        }
        if (expr instanceof CtThisAccess) {
            CtClass currentClass = (CtClass)expr.getParent((Filter)new TypeFilter(CtClass.class));
            if (currentClass == null) {
                return;
            }
            if (expr.getType().getQualifiedName().equals(currentClass.getQualifiedName()) && !currentClass.isPrivate()) {
                this.thisRule.add((CtElement)expr, expr.getType().getSimpleName()).addSourcePosition((CtElement)currentClass, this.getModule()).setLevel(WarningLevel.LEVEL_3);
            }
            return;
        }
        if (expr instanceof CtVariableAccess && (RulesUtils.isBoxedIntegerType(expr) || RulesUtils.isBoxedBoolean(expr) || RulesUtils.getTypeName(expr).equals("java.lang.String"))) {
            CtVariable varDecl = ((CtVariableAccess)synchro.getExpression()).getVariable().getDeclaration();
            if (varDecl == null) {
                return;
            }
            if (RulesUtils.isBoxedBoolean(expr)) {
                this.rule.add((CtElement)expr, expr.getType().getSimpleName()).addSourcePosition((CtElement)varDecl, this.getModule()).setLevel(WarningLevel.LEVEL_2);
                return;
            }
            WarningLevel level = null;
            CtExpression defaultExpression = varDecl.getDefaultExpression();
            if (defaultExpression == null) {
                level = WarningLevel.LEVEL_3;
            } else if (defaultExpression instanceof CtLiteral || RulesUtils.isPrimitive(defaultExpression)) {
                level = WarningLevel.LEVEL_2;
            } else if (defaultExpression instanceof CtAbstractInvocation) {
                if (RulesUtils.getQualifiedName((CtAbstractInvocation)defaultExpression).equals(RulesUtils.getTypeName(expr) + ".valueOf")) {
                    level = WarningLevel.LEVEL_2;
                } else {
                    return;
                }
            }
            if (level == null) {
                return;
            }
            this.rule.add((CtElement)expr, expr.getType().getSimpleName()).addSourcePosition((CtElement)varDecl, this.getModule()).setLevel(level);
        }
    }
}

