/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.declaration.CtElement;

public class V6069
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Unsigned right shift of a negative value of the '%s' type may differ from expected result.").build();

    @Nullable
    private WarningLevel getLevel(CtExpression<?> expr) {
        IntegerVirtualValue value = this.getValue((CtElement)expr).toInteger();
        if (value != null) {
            if (value.singletonValue().isPresent()) {
                if (value.singletonValue().get().toInt().get() < 0) {
                    return WarningLevel.LEVEL_2;
                }
                return null;
            }
            if (value.min().toInt().isPresent() && value.max().toInt().isPresent()) {
                int min = value.min().toInt().get();
                int max = value.max().toInt().get();
                if (min >= 0 && max >= 0) {
                    return null;
                }
                return WarningLevel.LEVEL_2;
            }
        }
        return WarningLevel.LEVEL_3;
    }

    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> operator) {
        WarningLevel level;
        CtExpression expr;
        String name;
        if (operator.getKind() == BinaryOperatorKind.USR && ((name = RulesUtils.getTypeName(expr = operator.getAssigned())).equals("byte") || name.equals("short")) && (level = this.getLevel(expr)) != null) {
            this.rule.add((CtElement)operator, name).setLevel(level);
        }
    }
}

