/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6068
extends PvsStudioRule {
    private final PvsStudioRule.Pattern ruleCtr = new PvsStudioRule.PatternBuilder(this).setMessage("Constructor call can result in imprecise representation of the initialized value.").setSastId("CERT-NUM10-J").build();
    private final PvsStudioRule.Pattern ruleEquals = new PvsStudioRule.PatternBuilder(this).setMessage("Consider using 'compareTo' method instead of 'equals' for comparison of only the numerical values.").setLevel(WarningLevel.LEVEL_3).setSastId("CERT-NUM10-J").build();

    private boolean hasExceptionInvocation(@NotNull CtElement element) {
        while ((element = element.getParent()) instanceof CtInvocation) {
            CtInvocation inv = (CtInvocation)element;
            if (inv.getExecutable() != null && (inv.getExecutable().getSimpleName().equals("setScale") || inv.getExecutable().getSimpleName().equals("doubleValue"))) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> invocation) {
        CtExpression arg;
        String qualifiedName;
        super.visitCtConstructorCall(invocation);
        if (invocation.getExecutable().getDeclaringType() != null && invocation.getArguments().size() == 1 && (qualifiedName = invocation.getExecutable().getDeclaringType().getQualifiedName()).equals("java.math.BigDecimal") && (arg = (CtExpression)invocation.getArguments().get(0)) != null && RulesUtils.isRealType(arg)) {
            Number num;
            String op;
            if (arg instanceof CtUnaryOperator && ((op = RulesUtils.getOperatorText(((CtUnaryOperator)arg).getKind())).equals("+") || op.equals("-"))) {
                arg = ((CtUnaryOperator)arg).getOperand();
            }
            if (arg instanceof CtLiteral && (num = (Number)((CtLiteral)arg).getValue()).doubleValue() % 0.5 == 0.0) {
                return;
            }
            if (this.hasExceptionInvocation((CtElement)invocation)) {
                return;
            }
            WarningLevel level = this.isInsideTestSources((CtElement)invocation) ? WarningLevel.LEVEL_3 : WarningLevel.LEVEL_2;
            this.ruleCtr.add((CtElement)invocation, new Object[0]).setLevel(level);
        }
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (invocation.getArguments().isEmpty()) {
            return;
        }
        String name = RulesUtils.getQualifiedName(invocation);
        if (name.equals("java.math.BigDecimal.equals")) {
            if (Stream.of(invocation.getTarget(), (CtExpression)invocation.getArguments().get(0)).filter(CtFieldRead.class::isInstance).map(expr -> ((CtFieldRead)expr).getVariable()).filter(variable -> variable.getDeclaringType() != null).anyMatch(variable -> variable.isStatic() && variable.isFinal() && variable.getDeclaringType().getQualifiedName().equals("java.math.BigDecimal"))) {
                return;
            }
            if (Stream.of(invocation.getTarget(), (CtExpression)invocation.getArguments().get(0)).filter(CtConstructorCall.class::isInstance).map(expr -> (CtConstructorCall)expr).filter(ctr -> !ctr.getArguments().isEmpty()).anyMatch(ctr -> ctr.getArguments().get(0) instanceof CtLiteral)) {
                return;
            }
            CtMethod method = (CtMethod)invocation.getParent((Filter)new TypeFilter(CtMethod.class));
            if (method != null && method.getSimpleName().contains("equals")) {
                return;
            }
            this.ruleEquals.add((CtElement)invocation, new Object[0]);
        }
    }
}

