/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCFlowBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.declaration.CtElement;

public class V6067
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Two or more case-branches perform the same actions.").setLevel(WarningLevel.LEVEL_3).setCwe(691).build();

    private <S> boolean isEqualsStatements(@NotNull List<CtStatement> stmt1, @NotNull List<CtStatement> stmt2) {
        if (stmt1.size() > 1 && stmt1.size() != stmt2.size()) {
            return false;
        }
        return IntStream.range(0, stmt1.size()).allMatch(index -> RulesUtils.equals((CtElement)stmt1.get(index), (CtElement)stmt2.get(index)));
    }

    private List<CtStatement> getAllStatements(@NotNull List<CtStatement> list) {
        ArrayList<CtStatement> statements = new ArrayList<CtStatement>();
        for (CtStatement statement : list) {
            if (statement instanceof CtBlock) {
                statements.addAll(this.getAllStatements(((CtBlock)statement).getStatements()));
                continue;
            }
            statements.add(statement);
        }
        return statements;
    }

    private List<CtStatement> getAllStatementsFromCase(@NotNull CtCase<?> ctCase) {
        ArrayList<CtStatement> statements = new ArrayList<CtStatement>();
        for (CtStatement statement : ctCase.getStatements()) {
            if (statement instanceof CtBlock) {
                statements.addAll(((CtBlock)statement).getStatements());
                continue;
            }
            statements.add(statement);
        }
        return statements;
    }

    private <S> List<List<CtCase<? super S>>> getIdenticalCases(@NotNull List<CtCase<? super S>> ctCaseList) {
        ArrayList<ArrayList<CtCase<S>>> identicalCasesList = new ArrayList<ArrayList<CtCase<S>>>();
        for (CtCase<S> ctCase : ctCaseList) {
            List<CtStatement> statementsCtCase = this.getAllStatements(ctCase.getStatements());
            if (!statementsCtCase.isEmpty() && !(statementsCtCase.get(statementsCtCase.size() - 1) instanceof CtCFlowBreak) || statementsCtCase.size() == 1 && statementsCtCase.get(0) instanceof CtBreak) continue;
            boolean isAdded = false;
            for (List list : identicalCasesList) {
                if (list.isEmpty() || !this.isEqualsStatements(statementsCtCase, this.getAllStatements(((CtCase)list.get(0)).getStatements()))) continue;
                list.add(ctCase);
                isAdded = true;
                break;
            }
            if (isAdded) continue;
            identicalCasesList.add(new ArrayList<CtCase<S>>(Collections.singletonList(ctCase)));
        }
        return identicalCasesList.stream().filter(listIdenticalCases -> listIdenticalCases.size() > 1).collect(Collectors.toList());
    }

    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
        List<CtCase<? super S>> listCases = switchStatement.getCases().stream().filter(arg -> !RulesUtils.isDefault(arg) && !arg.getStatements().isEmpty()).collect(Collectors.toList());
        List<List<CtCase<S>>> identicalCasesList = this.getIdenticalCases(listCases);
        for (List<CtCase<S>> identicalCases : identicalCasesList) {
            if (identicalCases.size() > 3) continue;
            WarningAdapter warning = this.rule.add((CtElement)identicalCases.get(0), new Object[0]);
            if (this.getAllStatements(identicalCases.get(0).getStatements()).stream().filter(arg -> !(arg instanceof CtBreak)).filter(arg -> !(arg instanceof CtReturn) || ((CtReturn)arg).getReturnedExpression() != null).count() > 1L) {
                warning.setLevel(WarningLevel.LEVEL_2);
            }
            identicalCases.stream().skip(1L).forEach(c -> warning.addSourcePosition((CtElement)c, this.getModule()));
        }
    }
}

