/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.TypeCollectionArg;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.V6058;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.List;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;

public class V6066
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Passing objects of incompatible types to the method of collection.").setExtendedMessage("The type of object passed as argument is incompatible with the type of collection: %s, %s.").setSastId("CERT-EXP04-J").build();

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        int indexArgument = this.getMethodAnnotation((CtAbstractInvocation<?>)invocation).getCollectionArgument().getIndex();
        if (indexArgument < 0 || indexArgument >= invocation.getArguments().size()) {
            return;
        }
        ArrayList args = new ArrayList();
        args.add(invocation.getTarget());
        args.add((CtExpression)invocation.getArguments().get(indexArgument));
        List<CtTypeReference<?>> types = V6058.getTypes(args);
        if (types == null) {
            return;
        }
        CtTypeReference type1 = types.get(0);
        CtTypeReference<?> type2 = types.get(1);
        TypeCollectionArg isExpectedType = this.getMethodAnnotation((CtAbstractInvocation<?>)invocation).getCollectionArgument().getType();
        boolean isType2Collection = type2.isSubtypeOf(type2.getFactory().Type().COLLECTION);
        if (isExpectedType == TypeCollectionArg.Element) {
            if (type1.getActualTypeArguments().size() != 1) {
                return;
            }
            CtTypeReference typeTargetCollection = (CtTypeReference)type1.getActualTypeArguments().get(0);
            if (typeTargetCollection.equals((Object)typeTargetCollection.getFactory().Type().OBJECT)) {
                return;
            }
            if (isType2Collection) {
                if (typeTargetCollection.isSubtypeOf(typeTargetCollection.getFactory().Type().COLLECTION)) {
                    return;
                }
                StringBuilder name1 = new StringBuilder();
                RulesUtils.getSimpleNameType(typeTargetCollection, name1);
                StringBuilder name2 = new StringBuilder();
                RulesUtils.getSimpleNameType(type2, name2);
                this.rule.add((CtElement)invocation, name1, name2).setLevel(this.isInsideTestSources((CtElement)invocation) ? WarningLevel.LEVEL_3 : WarningLevel.LEVEL_1);
                return;
            }
            type1 = typeTargetCollection;
        }
        if (isType2Collection && type2.getActualTypeArguments().isEmpty()) {
            return;
        }
        if (!RulesUtils.equals(type1, type2) && V6058.isWrongArguments(type1, type2, true, this.getTypes())) {
            StringBuilder name1 = new StringBuilder();
            RulesUtils.getSimpleNameType(type1, name1);
            StringBuilder name2 = new StringBuilder();
            RulesUtils.getSimpleNameType(type2, name2);
            this.rule.add((CtElement)invocation, name1, name2).setLevel(this.isInsideTestSources((CtElement)invocation) ? WarningLevel.LEVEL_3 : WarningLevel.LEVEL_1);
        }
    }
}

