/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import java.util.List;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeReference;

public class V6065
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("A non-serializable class should not be serialized.").build();

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        if (inv.getTarget() == null || inv.getExecutable() == null || inv.getArguments().size() != 1 || !"writeObject".equals(inv.getExecutable().getSimpleName())) {
            return;
        }
        CtExpression arg1 = (CtExpression)inv.getArguments().get(0);
        if ("null".equals(arg1.toString())) {
            return;
        }
        CtTypeReference targetType = inv.getTarget().getType();
        if (targetType == null || !"java.io.ObjectOutputStream".equals(targetType.getQualifiedName()) && !"java.io.ObjectOutput".equals(targetType.getQualifiedName())) {
            return;
        }
        CtTypeReference type = arg1.getType();
        if (type.isArray() || type.isInterface() || type.isPrimitive() || type.isGenerics() || type.getModifiers().contains(ModifierKind.ABSTRACT) || "java.lang.Object".equals(type.getQualifiedName())) {
            return;
        }
        List<CtTypeReference<?>> allSuperInterfaces = this.getTypes().getAllImplementedInterfaces(type);
        if (allSuperInterfaces.stream().anyMatch(i -> "java.io.Serializable".equals(i.getQualifiedName()))) {
            return;
        }
        this.rule.add((CtElement)inv, new Object[0]);
    }
}

