/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;

public class V6064
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Suspicious invocation of Thread.run(). Use Thread.start() to start a new thread.").setCwe(572).setSastId("CERT-THI00-J").setSecId("SEC-SYNCHRONIZATION").build();

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        if (inv.getTarget() == null || inv.getExecutable() == null || !"run".equals(inv.getExecutable().getSimpleName())) {
            return;
        }
        CtTypeReference type = inv.getTarget().getType();
        if (type == null || !"java.lang.Thread".equals(type.getQualifiedName())) {
            return;
        }
        List typeCasts = inv.getTarget().getTypeCasts();
        if (!typeCasts.isEmpty() && typeCasts.stream().anyMatch(cast -> "java.lang.Runnable".equals(cast.getQualifiedName()))) {
            return;
        }
        WarningLevel level = this.isInsideTestSources((CtElement)inv) ? WarningLevel.LEVEL_2 : WarningLevel.LEVEL_1;
        this.rule.add((CtElement)inv, new Object[0]).setLevel(level);
    }
}

