/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.google.common.collect.Sets;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.visitors.ModificationsScanner;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;

public class V6063
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Suspicious empty body of the '%s' statement.").setCwe(670).setSastId("CERT-MSC51-J").build();

    public void visitCtIf(CtIf ifElement) {
        if (ifElement.getThenStatement() == null) {
            this.rule.add((CtElement)ifElement, "if");
        }
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        if (foreach.getBody() == null) {
            this.rule.add((CtElement)foreach, "foreach");
        }
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        if (whileLoop.getBody() == null && !ModificationsScanner.hasAnyModification((CtElement)whileLoop.getLoopingExpression(), this.getDataFlow().getVariablesCache())) {
            this.rule.add((CtElement)whileLoop, "while");
        }
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        if (forLoop.getBody() == null) {
            Set localVariables = Sets.newIdentityHashSet();
            for (CtStatement statement : forLoop.getForInit()) {
                if (!(statement instanceof CtLocalVariable)) continue;
                localVariables.add((CtVariable)statement);
            }
            Function<CtElement, Boolean> modifiesAnything = it -> {
                Map<CtElement, Boolean> modifications = ModificationsScanner.scan(it, this.getDataFlow().getVariablesCache());
                for (Map.Entry<CtElement, Boolean> modification : modifications.entrySet()) {
                    CtVariable variable;
                    if (modification.getKey() instanceof CtVariable ? localVariables.contains(modification.getKey()) : modification.getKey() instanceof CtVariableAccess && localVariables.contains(variable = ((CtVariableAccess)modification.getKey()).getVariable().getDeclaration())) continue;
                    return true;
                }
                return false;
            };
            if (forLoop.getExpression() != null && modifiesAnything.apply((CtElement)forLoop.getExpression()).booleanValue()) {
                return;
            }
            for (CtStatement statement : forLoop.getForUpdate()) {
                if (!modifiesAnything.apply((CtElement)statement).booleanValue()) continue;
                return;
            }
            this.rule.add((CtElement)forLoop, "for");
        }
    }
}

