/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.FunctionClassification;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6062
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Possible infinite recursion inside the '%s' method.").setCwe(674).build();

    private boolean hasExit(CtElement element) {
        EarlyTerminatingScanner<Boolean> scanner = new EarlyTerminatingScanner<Boolean>(){

            public void visitCtThrow(CtThrow throwStatement) {
                this.setResult(true);
                this.terminate();
            }

            public <R> void visitCtReturn(CtReturn<R> returnStatement) {
                this.setResult(true);
                this.terminate();
            }

            public <T> void visitCtInvocation(CtInvocation<T> invocation) {
                if (V6062.this.getMethodAnnotation((CtAbstractInvocation<?>)invocation).is(FunctionClassification.NoReturn)) {
                    this.setResult(true);
                    this.terminate();
                }
            }
        };
        scanner.scan(element);
        return scanner.getResult() != null && (Boolean)scanner.getResult() != false;
    }

    private boolean hasThrowOrNoreturn(CtElement element) {
        EarlyTerminatingScanner<Boolean> scanner = new EarlyTerminatingScanner<Boolean>(){

            public void visitCtThrow(CtThrow throwStatement) {
                this.setResult(true);
                this.terminate();
            }

            public <T> void visitCtInvocation(CtInvocation<T> invocation) {
                if (V6062.this.getMethodAnnotation((CtAbstractInvocation<?>)invocation).is(FunctionClassification.NoReturn)) {
                    this.setResult(true);
                    this.terminate();
                }
            }
        };
        scanner.scan(element);
        return scanner.getResult() != null && (Boolean)scanner.getResult() != false;
    }

    @Nullable
    private CtInvocation<?> getWrongSelfInvocation(CtMethod<?> m, CtBlock<?> body) {
        int n = 0;
        for (CtStatement stmt : body.getStatements()) {
            CtInvocation<?> stmtInsideFinal;
            CtBlock finalBody;
            if (stmt instanceof CtInvocation && (((CtInvocation)stmt).getTarget() instanceof CtThisAccess || ((CtInvocation)stmt).getExecutable().isStatic()) && ((CtInvocation)stmt).getExecutable().equals((Object)m.getReference())) {
                boolean exitPossible = IntStream.range(0, n).anyMatch(i -> this.hasExit((CtElement)body.getStatement(i)));
                if (exitPossible) break;
                return (CtInvocation)stmt;
            }
            if (stmt instanceof CtTry && (finalBody = ((CtTry)stmt).getFinalizer()) != null && (stmtInsideFinal = this.getWrongSelfInvocation(m, finalBody)) != null) {
                boolean exitPossible = IntStream.range(0, n).anyMatch(i -> this.hasExit((CtElement)body.getStatement(i)));
                if (exitPossible) break;
                return stmtInsideFinal;
            }
            ++n;
        }
        return null;
    }

    private boolean isFirstException(CtInvocation<?> inv) {
        List currentParams = inv.getArguments().stream().map(x -> {
            CtTypeReference<?> local = RulesUtils.getType(x);
            if (local != null && local.getSimpleName().equals("<nulltype>")) {
                return local.getFactory().Type().OBJECT;
            }
            return local;
        }).collect(Collectors.toList());
        if (currentParams.contains(null)) {
            return true;
        }
        if (currentParams.size() == inv.getExecutable().getParameters().size() && IntStream.range(0, currentParams.size()).allMatch(i -> ((CtTypeReference)currentParams.get(i)).box().equals((Object)((CtTypeReference)inv.getExecutable().getParameters().get(i)).box()))) {
            return false;
        }
        CtClass ctClass = (CtClass)inv.getParent(CtClass.class);
        if (ctClass != null) {
            List methodsByName = ctClass.getMethodsByName(inv.getExecutable().getSimpleName());
            ArrayList<CtMethod> suspiciousMethods = new ArrayList<CtMethod>();
            for (CtMethod met : methodsByName) {
                List methodParams = met.getParameters().stream().map(CtTypedElement::getType).collect(Collectors.toList());
                if (methodParams.contains(null) || methodParams.size() != currentParams.size()) {
                    return true;
                }
                if (!IntStream.range(0, methodParams.size()).allMatch(i -> ((CtTypeReference)methodParams.get(i)).box().isSubtypeOf(((CtTypeReference)currentParams.get(i)).box()))) continue;
                suspiciousMethods.add(met);
            }
            if (suspiciousMethods.size() != 1) {
                return true;
            }
            return !((CtMethod)suspiciousMethods.get(0)).getReference().equals((Object)inv.getExecutable());
        }
        return true;
    }

    public <R> void visitCtBlock(CtBlock<R> block) {
        if (!(block.getParent() instanceof CtMethod)) {
            return;
        }
        CtMethod m = (CtMethod)block.getParent();
        CtBlock body = m.getBody();
        if (body == null) {
            return;
        }
        CtInvocation<?> selfInvocation = this.getWrongSelfInvocation(m, body);
        if (selfInvocation != null) {
            if (this.isFirstException(selfInvocation)) {
                return;
            }
            this.rule.add((CtElement)m, m.getSimpleName()).addSourcePosition((CtElement)selfInvocation, this.getModule());
            return;
        }
        List returns = body.getElements((Filter)new TypeFilter(CtReturn.class));
        if (!returns.isEmpty() && returns.stream().allMatch(ret -> ret.getReturnedExpression() instanceof CtInvocation && (((CtInvocation)ret.getReturnedExpression()).getTarget() instanceof CtThisAccess || ((CtInvocation)ret.getReturnedExpression()).getExecutable().isStatic()) && ((CtInvocation)ret.getReturnedExpression()).getExecutable().equals((Object)m.getReference()) && !this.isFirstException((CtInvocation)ret.getReturnedExpression())) && !this.hasThrowOrNoreturn((CtElement)m)) {
            WarningAdapter warning = this.rule.add((CtElement)m, m.getSimpleName());
            returns.forEach(r -> warning.addSourcePosition((CtElement)r, this.getModule()));
        }
    }
}

