/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.FormatterStyle;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.V6046;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtVariable;

public class V6061
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Be advised that the utilized constant value is represented by an octal form. Oct: %s, Dec: %s.").setCwe(682).setSastId("CERT-DCL50-J").build();

    private boolean isException3(Optional<String> line) {
        if (!line.isPresent()) {
            return false;
        }
        String str = line.get().toLowerCase();
        return str.contains("chmod") || str.contains("permission") || str.contains("octal") || str.contains("mask") || str.contains("canread") || str.contains("canwrite") || str.contains("canexecute") || str.contains("unixmode") || str.contains("owner_read") || str.contains("owner_write") || str.contains("owner_execute") || str.contains("group_read") || str.contains("group_write") || str.contains("group_execute") || str.contains("others_read") || str.contains("others_write") || str.contains("others_execute") || str.contains("mode") || str.contains("perm");
    }

    private boolean isException5(Optional<String> line) {
        if (!line.isPresent()) {
            return false;
        }
        String str = line.get().toLowerCase();
        return str.contains("file") || str.contains("mode") || str.contains("mkdir") || str.contains("permission") || str.contains("mask") || str.contains("folder") || str.contains("directory") || str.contains("directories") || str.contains("access");
    }

    private boolean isOctalLiteral(CtLiteral<?> literal) {
        String valueString;
        Object value = literal.getValue();
        if (value == null) {
            return false;
        }
        Class<?> cls = value.getClass();
        if (cls != Integer.class && cls != Long.class && cls != Short.class && cls != Byte.class) {
            return false;
        }
        SourcePosition position = literal.getPosition();
        Optional<String> line = this.getModule().getLine(position.getFile(), position.getLine());
        if (line.isEmpty()) {
            return false;
        }
        try {
            valueString = line.get().substring(position.getColumn() - 1, position.getEndColumn());
        }
        catch (IndexOutOfBoundsException ignored) {
            return false;
        }
        if (valueString.length() < 2) {
            return false;
        }
        return valueString.charAt(0) == '0' && Character.isDigit(valueString.charAt(1));
    }

    private boolean isOctalCounterException(List<?> elements) {
        int octalCounter = 0;
        for (Object element : elements) {
            if (!(element instanceof CtLiteral) || !this.isOctalLiteral((CtLiteral)element) || ++octalCounter != 3) continue;
            return true;
        }
        return false;
    }

    private boolean containsOctalFormatSpecifier(String input) {
        return V6046.parse(input).stream().anyMatch(formatSpecifier -> formatSpecifier.type.equalsIgnoreCase("o"));
    }

    private void applyOtherFiltersAndCollectWarnings(CtLiteral<?> literal, long longValue, Optional<String> line) {
        if (!line.isPresent()) {
            return;
        }
        SourcePosition position = literal.getPosition();
        Optional<String> prevLine = this.getModule().getLine(position.getFile(), position.getLine() - 1);
        Optional<String> prevLine2 = this.getModule().getLine(position.getFile(), position.getLine() - 2);
        Optional<String> nextLine = this.getModule().getLine(position.getFile(), position.getLine() + 1);
        Pattern octalNumberRegExp = Pattern.compile("(?<![\\d|\\w])0[0-7]+(?![\\d|\\w])");
        MutableBoolean prevLineContainsOctalLiteral = new MutableBoolean(false);
        prevLine.ifPresent(l -> prevLineContainsOctalLiteral.setValue(octalNumberRegExp.matcher((CharSequence)l).find()));
        MutableBoolean prevLine2ContainsOctalLiteral = new MutableBoolean(false);
        prevLine2.ifPresent(l -> prevLine2ContainsOctalLiteral.setValue(octalNumberRegExp.matcher((CharSequence)l).find()));
        MutableBoolean nextLineContainsOctalLiteral = new MutableBoolean(false);
        nextLine.ifPresent(l -> nextLineContainsOctalLiteral.setValue(octalNumberRegExp.matcher((CharSequence)l).find()));
        MutableBoolean nextLine2ContainsOctalLiteral = new MutableBoolean(false);
        Optional<String> nextLine2 = this.getModule().getLine(position.getFile(), position.getLine() + 2);
        nextLine2.ifPresent(l -> nextLine2ContainsOctalLiteral.setValue(octalNumberRegExp.matcher((CharSequence)l).find()));
        if (prevLineContainsOctalLiteral.getValue() != false && prevLine2ContainsOctalLiteral.getValue() != false || nextLineContainsOctalLiteral.getValue() != false && nextLine2ContainsOctalLiteral.getValue() != false || prevLineContainsOctalLiteral.getValue().booleanValue() && nextLineContainsOctalLiteral.getValue().booleanValue()) {
            return;
        }
        CtInvocation parentInvocation = (CtInvocation)literal.getParent(CtInvocation.class);
        CtMethod parentMethod = (CtMethod)literal.getParent(CtMethod.class);
        Optional<String> invocationName = Optional.empty();
        Optional<String> methodName = Optional.empty();
        if (parentInvocation != null && parentInvocation.getExecutable() != null) {
            invocationName = Optional.of(parentInvocation.getExecutable().getSimpleName());
        }
        if (parentMethod != null) {
            methodName = Optional.of(parentMethod.getSimpleName());
        }
        if (this.isException3(prevLine) || this.isException3(line) || this.isException3(nextLine) || this.isException3(invocationName) || this.isException3(methodName)) {
            return;
        }
        if ((longValue <= 511L || longValue >= 32768L && longValue <= 33206L) && (this.isException5(prevLine) || this.isException5(line) || this.isException5(nextLine) || this.isException5(invocationName) || this.isException5(methodName))) {
            return;
        }
        String valueString = line.get().substring(position.getColumn() - 1, position.getEndColumn());
        this.rule.add((CtElement)literal, valueString, longValue);
    }

    private boolean isPermissionVariable(long longValue, String varName) {
        if (varName == null || longValue > 511L || longValue < 0L) {
            return false;
        }
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf('7'), "rwx");
        map.put(Character.valueOf('6'), "rw");
        map.put(Character.valueOf('5'), "rx");
        map.put(Character.valueOf('4'), "r");
        map.put(Character.valueOf('3'), "wx");
        map.put(Character.valueOf('2'), "w");
        map.put(Character.valueOf('1'), "x");
        map.put(Character.valueOf('0'), "");
        StringBuilder permName = new StringBuilder();
        StringBuilder permNameWithSpace = new StringBuilder();
        char[] chars = Long.toOctalString(longValue).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            String get = (String)map.get(Character.valueOf(chars[i]));
            permName.append(get);
            permNameWithSpace.append(get);
            if (i == chars.length - 1) continue;
            permNameWithSpace.append(' ');
        }
        return varName.toLowerCase().contains(permName.toString().toLowerCase()) || varName.toLowerCase().contains(permNameWithSpace.toString().trim().replaceAll(" ", "_").toLowerCase());
    }

    private boolean isFirstOrSecondException(CtLiteral<?> literal, long longValue) {
        if (longValue < 8L) {
            return true;
        }
        return this.isSuppressed("OctalInteger") || this.isSuppressed((CtElement)literal, "OctalInteger");
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        List octalLiterals = inv.getArguments().stream().filter(CtLiteral.class::isInstance).map(arg -> (CtLiteral)arg).filter(this::isOctalLiteral).filter(arg -> !this.isFirstOrSecondException((CtLiteral<?>)arg, ((Number)arg.getValue()).longValue())).collect(Collectors.toList());
        if (this.isOctalCounterException(octalLiterals)) {
            return;
        }
        if (!octalLiterals.isEmpty()) {
            if (this.getMethodAnnotation((CtAbstractInvocation<?>)inv).getFormatArgument() != null && this.getMethodAnnotation((CtAbstractInvocation<?>)inv).getFormatArgument().getStyle() == FormatterStyle.Printf) {
                Object currentString;
                CtExpression formatString = (CtExpression)inv.getArguments().get(this.getMethodAnnotation((CtAbstractInvocation<?>)inv).getFormatArgument().getIndex());
                if (formatString instanceof CtLiteral && (currentString = ((CtLiteral)formatString).getValue()) instanceof String && this.containsOctalFormatSpecifier((String)currentString)) {
                    return;
                }
                if (formatString instanceof CtVariableRead && ((CtVariableRead)formatString).getType().getQualifiedName().equals("java.lang.String") && this.containsOctalFormatSpecifier(this.getValue((CtElement)formatString).getVirtualValue().getSingletonString().get())) {
                    return;
                }
            }
            for (CtLiteral octalLiteral : octalLiterals) {
                SourcePosition position = octalLiteral.getPosition();
                this.applyOtherFiltersAndCollectWarnings(octalLiteral, ((Number)octalLiteral.getValue()).longValue(), this.getModule().getLine(position.getFile(), position.getLine()));
            }
        }
    }

    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        List elements;
        BinaryOperatorKind kind;
        if (!this.isOctalLiteral(literal)) {
            return;
        }
        long longValue = ((Number)literal.getValue()).longValue();
        if (this.isFirstOrSecondException(literal, longValue)) {
            return;
        }
        CtElement parent = literal.getParent();
        if (parent instanceof CtInvocation) {
            return;
        }
        if (parent instanceof CtBinaryOperator && ((kind = ((CtBinaryOperator)parent).getKind()) == BinaryOperatorKind.BITOR || kind == BinaryOperatorKind.BITAND || kind == BinaryOperatorKind.BITXOR)) {
            return;
        }
        if (parent instanceof CtOperatorAssignment && ((kind = ((CtOperatorAssignment)parent).getKind()) == BinaryOperatorKind.BITOR || kind == BinaryOperatorKind.BITAND || kind == BinaryOperatorKind.BITXOR)) {
            return;
        }
        if (parent instanceof CtUnaryOperator && ((CtUnaryOperator)parent).getKind() == UnaryOperatorKind.COMPL) {
            return;
        }
        if (parent instanceof CtNewArray && this.isOctalCounterException(elements = ((CtNewArray)parent).getElements())) {
            return;
        }
        if (parent instanceof CtAssignment) {
            String varName = null;
            if (((CtAssignment)parent).getAssigned() instanceof CtVariable) {
                varName = ((CtVariable)((CtAssignment)parent).getAssigned()).getSimpleName();
            } else if (((CtAssignment)parent).getAssigned() instanceof CtVariableWrite) {
                varName = ((CtVariableWrite)((CtAssignment)parent).getAssigned()).getVariable().getSimpleName();
            }
            if (this.isPermissionVariable(longValue, varName)) {
                return;
            }
        } else if (parent instanceof CtVariable && this.isPermissionVariable(longValue, ((CtVariable)parent).getSimpleName())) {
            return;
        }
        SourcePosition position = literal.getPosition();
        this.applyOtherFiltersAndCollectWarnings(literal, longValue, this.getModule().getLine(position.getFile(), position.getLine()));
    }
}

