/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.PointerVirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtElement;

public class V6060
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("The reference was utilized before it was verified against null.").setExtendedMessage("The '%s' reference was utilized before it was verified against null.").setCwe(476).build();

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        PointerVirtualValue pointerValue;
        if (operator.getKind() != BinaryOperatorKind.EQ && operator.getKind() != BinaryOperatorKind.NE) {
            return;
        }
        if (this.getValue((CtElement)operator).isIndeterminate()) {
            return;
        }
        CtExpression pointer = operator.getLeftHandOperand();
        CtExpression nullPointer = operator.getRightHandOperand();
        if (RulesUtils.isPrimitive(pointer) || RulesUtils.isPrimitive(nullPointer)) {
            return;
        }
        if (!this.getValue((CtElement)nullPointer).isNullPointer()) {
            nullPointer = operator.getLeftHandOperand();
            pointer = operator.getRightHandOperand();
            if (!this.getValue((CtElement)nullPointer).isNullPointer()) {
                return;
            }
        }
        if ((pointerValue = this.getValue((CtElement)pointer).getVirtualValue().toPointer()) == null) {
            return;
        }
        CtElement dereferenced = this.getDataFlow().getExpressionByIndex(pointerValue.getDereferenceTree());
        if (dereferenced == null) {
            return;
        }
        this.rule.add((CtElement)operator, pointer).addSourcePosition(dereferenced, this.getModule());
    }
}

