/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.dataflow.TypesCache;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6058
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Comparing objects of incompatible types.").setExtendedMessage("The '%s' function compares objects of incompatible types: %s, %s.").setCwe(1024).build();

    private boolean getCmpArgs(CtInvocation<?> inv, @NotNull List<CtExpression<?>> out) {
        String simpleNameInv = this.getMethodAnnotation((CtAbstractInvocation<?>)inv).getName();
        if (simpleNameInv.equals("equals") || simpleNameInv.equals("deepEquals") || simpleNameInv.equals("assertEquals") || simpleNameInv.equals("assertArrayEquals")) {
            if (inv.getArguments().size() == 1) {
                out.add(inv.getTarget());
                out.add((CtExpression)inv.getArguments().get(0));
            } else if (inv.getArguments().size() == 2) {
                out.add((CtExpression)inv.getArguments().get(0));
                out.add((CtExpression)inv.getArguments().get(1));
            } else if (inv.getArguments().size() == 3) {
                out.add((CtExpression)inv.getArguments().get(1));
                out.add((CtExpression)inv.getArguments().get(2));
            }
        }
        return out.size() == 2;
    }

    private static boolean isException(CtTypeReference<?> type1, CtTypeReference<?> type2, TypesCache types) {
        if (type1.getActualTypeArguments().isEmpty()) {
            if (type1.isSubtypeOf(type1.getFactory().Type().COLLECTION) || type1.isSubtypeOf(type1.getFactory().Type().MAP)) {
                return true;
            }
            if (type2.isClass()) {
                ArrayList classes = new ArrayList(types.getAllExtendedClasses(type1));
                classes.add(type1);
                return classes.stream().anyMatch(arg -> arg.getQualifiedName().equals(type2.getQualifiedName()));
            }
            if (type2.isInterface()) {
                ArrayList interfaces = new ArrayList(types.getAllImplementedInterfaces(type1));
                interfaces.add(type1);
                return interfaces.stream().anyMatch(arg -> arg.getQualifiedName().equals(type2.getQualifiedName()));
            }
        }
        return false;
    }

    static boolean isWrongArguments(CtTypeReference<?> type1, CtTypeReference<?> type2, boolean isInvCollection, TypesCache types) {
        if (type1.getActualTypeArguments().isEmpty() && type2.getActualTypeArguments().isEmpty()) {
            if (type1.isClass() && type2.isClass()) {
                return !type2.isSubtypeOf(type1) && !type1.isSubtypeOf(type2);
            }
            if (type1.isInterface() && type2.isInterface()) {
                ArrayList interfaces1 = new ArrayList(types.getAllImplementedInterfaces(type1));
                interfaces1.add(type1);
                ArrayList interfaces2 = new ArrayList(types.getAllImplementedInterfaces(type2));
                interfaces2.add(type2);
                return !interfaces1.removeAll(interfaces2);
            }
            return false;
        }
        if (!type1.getActualTypeArguments().isEmpty() && !type2.getActualTypeArguments().isEmpty()) {
            if (type1.getActualTypeArguments().size() != type2.getActualTypeArguments().size()) {
                return !(type1.isSubtypeOf(type1.getFactory().Type().COLLECTION) && type2.isSubtypeOf(type2.getFactory().Type().COLLECTION) || type1.isSubtypeOf(type1.getFactory().Type().MAP) && type2.isSubtypeOf(type2.getFactory().Type().MAP));
            }
            CtTypeReference subType1 = type1.getFactory().Type().createReference(type1.getQualifiedName());
            CtTypeReference subType2 = type2.getFactory().Type().createReference(type2.getQualifiedName());
            boolean isType1SubType2 = type1.isSubtypeOf(subType2);
            boolean isType2SubType1 = type2.isSubtypeOf(subType1);
            if (!(isInvCollection || isType1SubType2 || isType2SubType1)) {
                return true;
            }
            if ((isType1SubType2 || isType2SubType1) && !subType1.equals((Object)subType2) && (type1.getPackage() != null && !type1.getPackage().getQualifiedName().equals("java.util") || type2.getPackage() != null && !type2.getPackage().getQualifiedName().equals("java.util"))) {
                return false;
            }
            List actualArgsType1 = type1.getActualTypeArguments();
            List actualArgsType2 = type2.getActualTypeArguments();
            if (actualArgsType1.size() == actualArgsType2.size()) {
                return IntStream.range(0, actualArgsType1.size()).anyMatch(i -> V6058.isWrongArguments((CtTypeReference)actualArgsType1.get(i), (CtTypeReference)actualArgsType2.get(i), isInvCollection, types));
            }
            return false;
        }
        if (V6058.isException(type1, type2, types) || V6058.isException(type2, type1, types)) {
            return false;
        }
        return !type2.isSubtypeOf(type1) && !type1.isSubtypeOf(type2);
    }

    @Nullable
    static List<CtTypeReference<?>> getTypes(List<CtExpression<?>> args) {
        if (args.get(0) instanceof CtLiteral || RulesUtils.isNullLiteral((CtElement)args.get(1))) {
            return null;
        }
        CtTypeReference type1 = args.get(0).getType();
        CtTypeReference type2 = args.get(1).getType();
        if (type1 == null || type2 == null || !type1.isClass() && !type1.isInterface() || !type2.isClass() && !type2.isInterface() || !type1.getElements((Filter)new TypeFilter(CtTypeParameterReference.class)).isEmpty() || !type2.getElements((Filter)new TypeFilter(CtTypeParameterReference.class)).isEmpty()) {
            return null;
        }
        type1 = type1.box();
        type2 = type2.box();
        if (type1.equals((Object)type1.getFactory().Type().VOID) || type2.equals((Object)type2.getFactory().Type().VOID) || RulesUtils.getTypeName(type1).equals("java.lang.Class") || RulesUtils.getTypeName(type2).equals("java.lang.Class")) {
            return null;
        }
        return Arrays.asList(type1, type2);
    }

    private boolean isSpecialException(CtExpression<?> argument, CtTypeReference<?> argumentType) {
        return argument instanceof CtFieldRead && ((CtFieldRead)argument).getTarget() instanceof CtTypeAccess && ((CtFieldRead)argument).getVariable().getFieldDeclaration() == null && ((CtType)argument.getParent(ctType -> ctType instanceof CtClass || ctType instanceof CtInterface)).getQualifiedName().equals(argumentType.getQualifiedName());
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        CtTypeReference<?> secondArgumentType;
        ArrayList args = new ArrayList();
        if (!this.getCmpArgs(invocation, args)) {
            return;
        }
        List<CtTypeReference<?>> types = V6058.getTypes(args);
        if (types == null) {
            return;
        }
        CtTypeReference<?> firstArgumentType = types.get(0);
        if (!RulesUtils.equals(firstArgumentType, secondArgumentType = types.get(1)) && V6058.isWrongArguments(firstArgumentType, secondArgumentType, false, this.getTypes())) {
            CtExpression firstArgument = (CtExpression)args.get(0);
            CtExpression secondArgument = (CtExpression)args.get(1);
            if (this.isSpecialException(secondArgument, secondArgumentType) || this.isSpecialException(firstArgument, firstArgumentType)) {
                return;
            }
            StringBuilder name1 = new StringBuilder();
            RulesUtils.getSimpleNameType(firstArgumentType, name1);
            StringBuilder name2 = new StringBuilder();
            RulesUtils.getSimpleNameType(secondArgumentType, name2);
            this.rule.add((CtElement)invocation, invocation.getExecutable().getSimpleName(), name1, name2).setLevel(this.isInsideTestSources((CtElement)invocation) ? WarningLevel.LEVEL_3 : WarningLevel.LEVEL_1);
        }
    }
}

