/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Tribool;
import com.pvsstudio.core.Value;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;

public class V6057
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Consider inspecting this expression. The expression is excessive or contains a misprint.").setExtendedMessage("Consider inspecting the '%s' expression. The expression is excessive or contains a misprint.").setCwe(571).setSastId("CERT-MSC57-J").build();

    private BinaryOperatorKind getOperatorKind(CtExpression<?> expr) {
        if (expr instanceof CtBinaryOperator) {
            BinaryOperatorKind op = ((CtBinaryOperator)expr).getKind();
            if (op == BinaryOperatorKind.NE || op == BinaryOperatorKind.EQ) {
                return op;
            }
        } else if (expr instanceof CtUnaryOperator) {
            CtUnaryOperator ctUnaryOperator = (CtUnaryOperator)expr;
            if (ctUnaryOperator.getKind() == UnaryOperatorKind.NOT && ctUnaryOperator.getOperand() instanceof CtInvocation && ((CtInvocation)ctUnaryOperator.getOperand()).getExecutable().getSimpleName().equals("equals")) {
                return BinaryOperatorKind.NE;
            }
        } else if (expr instanceof CtInvocation && ((CtInvocation)expr).getExecutable().getSimpleName().equals("equals")) {
            return BinaryOperatorKind.EQ;
        }
        return null;
    }

    @Nullable
    private CtExpression<?> getLeftPart(CtExpression<?> lhs) {
        if (lhs instanceof CtBinaryOperator) {
            return ((CtBinaryOperator)lhs).getLeftHandOperand();
        }
        if (lhs instanceof CtUnaryOperator) {
            CtExpression operand = ((CtUnaryOperator)lhs).getOperand();
            if (operand instanceof CtInvocation && ((CtInvocation)operand).getExecutable().getSimpleName().equals("equals")) {
                return ((CtInvocation)operand).getTarget();
            }
        } else if (lhs instanceof CtInvocation && ((CtInvocation)lhs).getExecutable().getSimpleName().equals("equals")) {
            return ((CtInvocation)lhs).getTarget();
        }
        return null;
    }

    @Nullable
    private CtExpression<?> getRightPart(CtExpression<?> rhs) {
        CtInvocation inv;
        if (rhs instanceof CtBinaryOperator) {
            return ((CtBinaryOperator)rhs).getRightHandOperand();
        }
        if (rhs instanceof CtUnaryOperator) {
            CtInvocation inv2;
            CtExpression operand = ((CtUnaryOperator)rhs).getOperand();
            if (operand instanceof CtInvocation && (inv2 = (CtInvocation)operand).getExecutable().getSimpleName().equals("equals") && inv2.getArguments().size() == 1) {
                return (CtExpression)inv2.getArguments().get(0);
            }
        } else if (rhs instanceof CtInvocation && (inv = (CtInvocation)rhs).getExecutable().getSimpleName().equals("equals") && inv.getArguments().size() == 1) {
            return (CtExpression)inv.getArguments().get(0);
        }
        return null;
    }

    private CmpType getTypeCmp(CtExpression<?> expr) {
        if (expr instanceof CtBinaryOperator) {
            BinaryOperatorKind op = ((CtBinaryOperator)expr).getKind();
            switch (op) {
                case LT: {
                    return CmpType.Lt;
                }
                case LE: {
                    return CmpType.Le;
                }
                case GT: {
                    return CmpType.Gt;
                }
                case GE: {
                    return CmpType.Ge;
                }
            }
            return CmpType.InvalidCMP;
        }
        return CmpType.InvalidCMP;
    }

    @Nullable
    private BinaryOperatorKind getInverseOperator(BinaryOperatorKind op) {
        switch (op) {
            case LT: {
                return BinaryOperatorKind.GT;
            }
            case GT: {
                return BinaryOperatorKind.LT;
            }
            case LE: {
                return BinaryOperatorKind.GE;
            }
            case GE: {
                return BinaryOperatorKind.LE;
            }
            case EQ: {
                return BinaryOperatorKind.EQ;
            }
            case NE: {
                return BinaryOperatorKind.NE;
            }
        }
        return null;
    }

    private void simplifyUnsafeIntervalCmp(MutableLong value, MutableObject<BinaryOperatorKind> op) {
        if (op.getValue() == BinaryOperatorKind.GT) {
            value.increment();
            op.setValue((Object)BinaryOperatorKind.GE);
        } else if (op.getValue() == BinaryOperatorKind.LT) {
            value.decrement();
            op.setValue((Object)BinaryOperatorKind.LE);
        }
    }

    private void simplifyUnsafeIntervalCmp(MutableDouble value, Mutable<BinaryOperatorKind> op) {
        double epsilon = 1.0E-9;
        if (op.getValue() == BinaryOperatorKind.GT) {
            value.setValue(value.doubleValue() + 1.0E-9);
            op.setValue((Object)BinaryOperatorKind.GE);
        } else if (op.getValue() == BinaryOperatorKind.LT) {
            value.setValue(value.doubleValue() - 1.0E-9);
            op.setValue((Object)BinaryOperatorKind.LE);
        }
    }

    private boolean checkSubExpressions(Method method, CtExpression<?> left, CtExpression<?> right, BinaryOperatorKind op) {
        CtBinaryOperator ctBinaryOperator;
        if (left instanceof CtBinaryOperator && ((ctBinaryOperator = (CtBinaryOperator)left).getKind() == BinaryOperatorKind.AND && op == BinaryOperatorKind.AND || ctBinaryOperator.getKind() == BinaryOperatorKind.OR && op == BinaryOperatorKind.OR) && !RulesUtils.isModifyValue(left, this.getDataFlow())) {
            if (method.impl(ctBinaryOperator.getLeftHandOperand(), right, op)) {
                return true;
            }
            return method.impl(ctBinaryOperator.getRightHandOperand(), right, op);
        }
        if (right instanceof CtBinaryOperator && ((ctBinaryOperator = (CtBinaryOperator)right).getKind() == BinaryOperatorKind.AND && op == BinaryOperatorKind.AND || ctBinaryOperator.getKind() == BinaryOperatorKind.OR && op == BinaryOperatorKind.OR) && !RulesUtils.isModifyValue(right, this.getDataFlow())) {
            if (method.impl(left, ctBinaryOperator.getLeftHandOperand(), op)) {
                return true;
            }
            return method.impl(left, ctBinaryOperator.getRightHandOperand(), op);
        }
        return false;
    }

    private double toDouble(CtLiteral<?> literal) {
        if (literal.getValue() instanceof Number) {
            return ((Number)literal.getValue()).doubleValue();
        }
        return Double.NaN;
    }

    private boolean isUnsafeInterval(BinaryOperatorKind leftOperation, BinaryOperatorKind rightOperation, boolean isNotEqual) {
        boolean leftLe = leftOperation == BinaryOperatorKind.LE;
        boolean leftGe = leftOperation == BinaryOperatorKind.GE;
        boolean rightLe = rightOperation == BinaryOperatorKind.LE;
        boolean rightGe = rightOperation == BinaryOperatorKind.GE;
        return leftGe == rightGe && leftLe == rightLe && isNotEqual;
    }

    private boolean applyRuleCmpUnsafeIntervalImpl(CtExpression<?> l2, CtExpression<?> r2, MutableObject<BinaryOperatorKind> leftOperation, MutableObject<BinaryOperatorKind> rightOperation, boolean isInteger) {
        if (isInteger && this.getValue((CtElement)l2).toLong().isPresent() && this.getValue((CtElement)r2).toLong().isPresent()) {
            MutableLong const1 = new MutableLong(this.getValue((CtElement)l2).toLong().get());
            MutableLong const2 = new MutableLong(this.getValue((CtElement)r2).toLong().get());
            this.simplifyUnsafeIntervalCmp(const1, leftOperation);
            this.simplifyUnsafeIntervalCmp(const2, rightOperation);
            return this.isUnsafeInterval((BinaryOperatorKind)leftOperation.getValue(), (BinaryOperatorKind)rightOperation.getValue(), !const1.equals((Object)const2)) || this.isUnsafeInterval((BinaryOperatorKind)rightOperation.getValue(), (BinaryOperatorKind)leftOperation.getValue(), !const2.equals((Object)const1));
        }
        if (l2 instanceof CtLiteral && r2 instanceof CtLiteral) {
            MutableDouble const1 = new MutableDouble(this.toDouble((CtLiteral)l2));
            MutableDouble const2 = new MutableDouble(this.toDouble((CtLiteral)r2));
            if (const1.getValue().isNaN() || const2.getValue().isNaN()) {
                return false;
            }
            this.simplifyUnsafeIntervalCmp(const1, (Mutable<BinaryOperatorKind>)leftOperation);
            this.simplifyUnsafeIntervalCmp(const2, (Mutable<BinaryOperatorKind>)rightOperation);
            return this.isUnsafeInterval((BinaryOperatorKind)leftOperation.getValue(), (BinaryOperatorKind)rightOperation.getValue(), !const1.equals((Object)const2)) || this.isUnsafeInterval((BinaryOperatorKind)rightOperation.getValue(), (BinaryOperatorKind)leftOperation.getValue(), !const2.equals((Object)const1));
        }
        return false;
    }

    private boolean applyRuleCmpUnsafeInterval(CtExpression<?> left, CtExpression<?> right) {
        if (!(left instanceof CtBinaryOperator) || !(right instanceof CtBinaryOperator)) {
            return false;
        }
        CtExpression<?> l1 = this.getLeftPart(left);
        CtExpression<?> l2 = this.getRightPart(left);
        CtExpression<?> r1 = this.getLeftPart(right);
        CtExpression<?> r2 = this.getRightPart(right);
        if (l1 == null || l2 == null || r1 == null || r2 == null) {
            return false;
        }
        boolean leftReverse = false;
        boolean rightReverse = false;
        if (RulesUtils.isModifyValue(left, this.getDataFlow()) || RulesUtils.isModifyValue(right, this.getDataFlow())) {
            return false;
        }
        if (!RulesUtils.equals(l1, r1)) {
            CtExpression<?> temp;
            if (RulesUtils.equals(l1, r2)) {
                temp = r1;
                r1 = r2;
                r2 = temp;
                rightReverse = true;
            } else if (RulesUtils.equals(l2, r2)) {
                temp = l1;
                l1 = l2;
                l2 = temp;
                temp = r1;
                r1 = r2;
                r2 = temp;
                leftReverse = true;
                rightReverse = true;
            } else if (RulesUtils.equals(l2, r1)) {
                temp = l1;
                l1 = l2;
                l2 = temp;
                leftReverse = true;
            } else {
                return false;
            }
        }
        if (!RulesUtils.isIntegerType(l1) && !RulesUtils.isRealType(l1)) {
            return false;
        }
        BinaryOperatorKind leftOperation = ((CtBinaryOperator)left).getKind();
        if (leftReverse && (leftOperation = this.getInverseOperator(leftOperation)) == null) {
            return false;
        }
        BinaryOperatorKind rightOperation = ((CtBinaryOperator)right).getKind();
        if (rightReverse && (rightOperation = this.getInverseOperator(rightOperation)) == null) {
            return false;
        }
        return this.applyRuleCmpUnsafeIntervalImpl(l2, r2, (MutableObject<BinaryOperatorKind>)new MutableObject((Object)leftOperation), (MutableObject<BinaryOperatorKind>)new MutableObject((Object)rightOperation), RulesUtils.isIntegerType(l1) && RulesUtils.isIntegerType(r1));
    }

    private boolean applyRuleCmp(CtExpression<?> left, CtExpression<?> right, BinaryOperatorKind op) {
        if (left == null || right == null) {
            return false;
        }
        CmpType leftType = this.getTypeCmp(left);
        CmpType rightType = this.getTypeCmp(right);
        if (op != BinaryOperatorKind.AND && op != BinaryOperatorKind.OR || leftType == CmpType.InvalidCMP || rightType == CmpType.InvalidCMP) {
            return this.checkSubExpressions(this::applyRuleCmp, left, right, op);
        }
        return this.applyRuleCmpUnsafeInterval(left, right);
    }

    private boolean applyRuleEquals(CtExpression<?> left, CtExpression<?> right, BinaryOperatorKind op) {
        CtExpression<?> temp;
        boolean isRightNotEq;
        if (op != BinaryOperatorKind.AND && op != BinaryOperatorKind.OR) {
            return false;
        }
        if (left == null || right == null) {
            return false;
        }
        boolean isLeftEq = this.getOperatorKind(left) == BinaryOperatorKind.EQ;
        boolean isRightEq = this.getOperatorKind(right) == BinaryOperatorKind.EQ;
        boolean isLeftNotEq = this.getOperatorKind(left) == BinaryOperatorKind.NE;
        boolean bl = isRightNotEq = this.getOperatorKind(right) == BinaryOperatorKind.NE;
        if (isLeftEq && isRightNotEq || isLeftNotEq && isRightEq) {
            Value value = this.getValue((CtElement)right);
            if (value.toBool() != Tribool.Indeterminate) {
                return false;
            }
        } else {
            return this.checkSubExpressions(this::applyRuleEquals, left, right, op);
        }
        if (RulesUtils.isModifyValue(left, this.getDataFlow()) || RulesUtils.isModifyValue(right, this.getDataFlow())) {
            return false;
        }
        CtExpression<?> l1 = this.getLeftPart(left);
        CtExpression<?> l2 = this.getRightPart(left);
        CtExpression<?> r1 = this.getLeftPart(right);
        CtExpression<?> r2 = this.getRightPart(right);
        if (l1 == null || l2 == null || r1 == null || r2 == null) {
            return false;
        }
        if (this.getValue((CtElement)l1).toLong().isPresent()) {
            temp = l1;
            l1 = l2;
            l2 = temp;
        }
        if (this.getValue((CtElement)r1).toLong().isPresent()) {
            temp = r1;
            r1 = r2;
            r2 = temp;
        }
        if (this.getValue((CtElement)l2).toLong().isPresent() && this.getValue((CtElement)r2).toLong().isPresent() && this.getValue((CtElement)l2).toLong().get() != this.getValue((CtElement)r2).toLong().get() && RulesUtils.equals(l1, r1)) {
            return true;
        }
        if (this.getValue((CtElement)l1).getVirtualValue().getSingletonString().isPresent()) {
            temp = l1;
            l1 = l2;
            l2 = temp;
        }
        if (this.getValue((CtElement)r1).getVirtualValue().getSingletonString().isPresent()) {
            temp = r1;
            r1 = r2;
            r2 = temp;
        }
        if (this.getValue((CtElement)l2).getVirtualValue().getSingletonString().isPresent() && this.getValue((CtElement)r2).getVirtualValue().getSingletonString().isPresent() && !RulesUtils.equals(l2, r2)) {
            return RulesUtils.equals(l1, r1);
        }
        return false;
    }

    private boolean apply(CtBinaryOperator<?> binOperator, Set<CtBinaryOperator<?>> errors) {
        if (this.applyRuleEquals(binOperator.getLeftHandOperand(), binOperator.getRightHandOperand(), binOperator.getKind()) || this.applyRuleCmp(binOperator.getLeftHandOperand(), binOperator.getRightHandOperand(), binOperator.getKind())) {
            errors.add(binOperator);
        }
        if (binOperator.getLeftHandOperand() instanceof CtBinaryOperator && this.apply((CtBinaryOperator)binOperator.getLeftHandOperand(), errors)) {
            return true;
        }
        if (binOperator.getRightHandOperand() instanceof CtBinaryOperator) {
            return this.apply((CtBinaryOperator)binOperator.getRightHandOperand(), errors);
        }
        return false;
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> expression) {
        if (expression.getParent() instanceof CtBinaryOperator) {
            return;
        }
        if (expression.getLeftHandOperand() == null || expression.getRightHandOperand() == null) {
            return;
        }
        HashSet errors = new HashSet();
        this.apply(expression, errors);
        for (CtBinaryOperator ctBinaryOperator : errors) {
            this.rule.add((CtElement)ctBinaryOperator, ctBinaryOperator);
        }
    }

    static enum CmpType {
        InvalidCMP,
        Lt,
        Le,
        Ge,
        Gt;

    }

    static interface Method {
        public boolean impl(CtExpression<?> var1, CtExpression<?> var2, BinaryOperatorKind var3);
    }
}

