/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;

public class V6056
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("The implementation of 'compareTo' overloads the method from the '%s' base class. Possibly, an override was intended.").build();

    private boolean isImplementsComparable(@NotNull CtTypeReference<?> type) {
        List<CtTypeReference<?>> interfaces = this.getTypes().getAllImplementedInterfaces(type);
        return interfaces.stream().anyMatch(arg -> arg.getQualifiedName().equals("java.lang.Comparable"));
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        Optional<CtMethod> cmpMethod = ctClass.getMethods().stream().filter(CtModifiable::isPublic).filter(arg -> arg.getParameters().size() == 1).filter(arg -> arg.getSimpleName().equals("compareTo")).findFirst();
        if (!cmpMethod.isPresent()) {
            return;
        }
        if (!this.isImplementsComparable(ctClass.getReference())) {
            return;
        }
        CtTypeReference superClass = ctClass.getSuperclass();
        while (superClass != null) {
            CtType type = superClass.getDeclaration();
            if (type == null || type.isAbstract()) {
                return;
            }
            if (this.isImplementsComparable(superClass)) {
                if (type.getMethods().stream().noneMatch(arg -> ((CtMethod)cmpMethod.get()).isOverriding(arg))) {
                    this.rule.add((CtElement)cmpMethod.get(), type.getSimpleName()).addSourcePosition((CtElement)type, this.getModule());
                }
                return;
            }
            superClass = superClass.getSuperclass();
        }
        return;
    }
}

