/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.FunctionClassification;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6055
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Expression '%s' inside assert statement can change object's state.").setSastId("CERT-EXP06-J").build();

    public <T> void visitCtAssert(CtAssert<T> ctAssert) {
        CtExpression expr = ctAssert.getAssertExpression();
        if (expr == null) {
            return;
        }
        List invocations = expr.getElements((Filter)new TypeFilter(CtInvocation.class));
        for (CtInvocation inv : invocations) {
            if (!this.getMethodAnnotation((CtAbstractInvocation<?>)inv).is(FunctionClassification.ModifiesObject)) continue;
            this.rule.add((CtElement)ctAssert, inv.getExecutable().getSimpleName()).setLevel(this.isInsideTestSources((CtElement)ctAssert) ? WarningLevel.LEVEL_3 : WarningLevel.LEVEL_1);
        }
    }
}

