/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.FunctionClassification;
import com.pvsstudio.core.TypeClassification;
import com.pvsstudio.core.Value;
import com.pvsstudio.rules.Equality;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCFlowBreak;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6053
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("The collection is modified while the iteration is in progress. ConcurrentModificationException may occur.").setExtendedMessage("The '%s' collection of '%s' type is modified while iteration is in progress. ConcurrentModificationException may occur.").setLevel(WarningLevel.LEVEL_1).setSastId("CERT-MSC06-J").build();

    private boolean isException1(CtInvocation<?> invocation) {
        CtElement parent = invocation.getParent();
        if (parent instanceof CtBlock) {
            CtStatement lastStatement = ((CtBlock)parent).getLastStatement();
            return lastStatement instanceof CtCFlowBreak || lastStatement instanceof CtInvocation && this.getMethodAnnotation((CtAbstractInvocation<?>)((CtInvocation)lastStatement)).is(FunctionClassification.NoReturn);
        }
        return false;
    }

    @Nullable
    private CtTypeReference<?> getActualDeclaredType(CtVariableRead<?> collectionExpr) {
        if (collectionExpr instanceof CtFieldRead) {
            CtTypeReference type = Optional.ofNullable(collectionExpr.getVariable()).map(CtVariableReference::getDeclaration).map(CtVariable::getDefaultExpression).map(CtTypedElement::getType).orElse(null);
            if (type != null && !(type instanceof CtArrayTypeReference)) {
                return type;
            }
        } else {
            Value value = this.getDataFlow().getValue((CtElement)collectionExpr);
            CtElement definition = this.getDataFlow().getExpressionByIndex(value.getDefinition());
            if (definition instanceof CtTypedElement) {
                return ((CtTypedElement)definition).getType();
            }
        }
        return null;
    }

    private void checkInvocations(CtElement body, CtExpression<?> collectionExpr) {
        if (!(collectionExpr instanceof CtVariableRead)) {
            return;
        }
        CtTypeReference<?> type = this.getActualDeclaredType((CtVariableRead)collectionExpr);
        if (type == null) {
            return;
        }
        Annotation typeAnnotation = this.getDataFlow().getTypeAnnotation(type.getQualifiedName());
        if (typeAnnotation != null && typeAnnotation.is(TypeClassification.ConcurrentModificationUnsafe)) {
            List invs = body.getElements(e -> e instanceof CtInvocation || e instanceof CtExecutableReferenceExpression);
            invs = invs.stream().filter(e -> ((CtTargetedExpression)e).getTarget() != null && RulesUtils.equals((CtElement)((CtTargetedExpression)e).getTarget(), (CtElement)collectionExpr, Equality.IGNORE_CASTS, new Equality[0])).collect(Collectors.toList());
            for (CtElement inv : invs) {
                if ((!(inv instanceof CtExecutableReferenceExpression) || !this.getMethodAnnotation((CtExecutableReferenceExpression)inv).is(FunctionClassification.ModifiesObject)) && (!(inv instanceof CtInvocation) || !this.getMethodAnnotation((CtAbstractInvocation<?>)((CtInvocation)inv)).is(FunctionClassification.ModifiesObject))) continue;
                if (inv instanceof CtInvocation && this.isException1((CtInvocation)inv)) {
                    return;
                }
                CtVariableReference variable = ((CtVariableRead)collectionExpr).getVariable();
                this.rule.add(inv, variable, type.getSimpleName());
            }
        }
    }

    @Nullable
    private CtExpression<?> skipStreams(CtTargetedExpression<?, ?> expression) {
        CtExpression target = expression.getTarget();
        while (target instanceof CtInvocation && target.getType().getQualifiedName().equals("java.util.stream.Stream")) {
            target = ((CtInvocation)target).getTarget();
        }
        return target;
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.checkInvocations((CtElement)foreach.getBody(), foreach.getExpression());
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (invocation.getTarget() == null) {
            return;
        }
        Annotation methodAnnotation = this.getMethodAnnotation((CtAbstractInvocation<?>)invocation);
        if (!methodAnnotation.getName().equals("forEach")) {
            return;
        }
        if (!this.getTypes().isSubtypeOf(invocation.getTarget(), "java.lang.Iterable") && !this.getTypes().isSubtypeOf(invocation.getTarget(), "java.util.stream.Stream")) {
            return;
        }
        CtExpression arg1 = (CtExpression)invocation.getArguments().get(0);
        CtExpression<?> target = this.skipStreams((CtTargetedExpression<?, ?>)invocation);
        if (target == null) {
            return;
        }
        if (!(arg1 instanceof CtLambda)) {
            if (arg1 instanceof CtExecutableReferenceExpression) {
                this.checkInvocations((CtElement)arg1, target);
            }
            return;
        }
        CtExpression lambdaExpression = ((CtLambda)arg1).getExpression();
        CtBlock lambdaBody = ((CtLambda)arg1).getBody();
        if (lambdaExpression != null) {
            this.checkInvocations((CtElement)lambdaExpression, target);
        } else if (lambdaBody != null) {
            this.checkInvocations((CtElement)lambdaBody, target);
        }
    }

    @NotNull
    Set<CtExpression<?>> getIteratingCollections(CtLoop loop) {
        CtExpression loopingExpression;
        HashSet iteratingCollections = new HashSet();
        if (loop instanceof CtWhile) {
            loopingExpression = ((CtWhile)loop).getLoopingExpression();
        } else if (loop instanceof CtDo) {
            loopingExpression = ((CtDo)loop).getLoopingExpression();
        } else if (loop instanceof CtFor) {
            loopingExpression = ((CtFor)loop).getExpression();
        } else {
            return iteratingCollections;
        }
        if (loopingExpression == null) {
            return iteratingCollections;
        }
        List invocations = loopingExpression.getElements((Filter)new TypeFilter(CtInvocation.class));
        for (CtInvocation inv : invocations) {
            Annotation methodAnnotation;
            if (inv.getTarget() == null || !(inv.getTarget() instanceof CtVariableRead) || !inv.getExecutable().getSimpleName().equals("hasNext") && !inv.getExecutable().getSimpleName().equals("hasPrevious") || !this.getTypes().isSubtypeOf(inv.getTarget(), "java.util.Iterator") && !this.getTypes().isSubtypeOf(inv.getTarget(), "java.util.ListIterator")) continue;
            long definitionLong = this.getDataFlow().getValue((CtElement)inv.getTarget()).getDefinition();
            CtElement definition = this.getDataFlow().getExpressionByIndex(definitionLong);
            if (!(definition instanceof CtInvocation) || !(methodAnnotation = this.getMethodAnnotation((CtAbstractInvocation<?>)((CtInvocation)definition))).getName().equals("iterator") && !methodAnnotation.getName().equals("listIterator")) continue;
            CtExpression target = ((CtInvocation)definition).getTarget();
            iteratingCollections.add(target);
        }
        return iteratingCollections;
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        Set<CtExpression<?>> iteratingCollections = this.getIteratingCollections((CtLoop)whileLoop);
        iteratingCollections.forEach(collectionExpr -> this.checkInvocations((CtElement)whileLoop.getBody(), (CtExpression<?>)collectionExpr));
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        Set<CtExpression<?>> iteratingCollections = this.getIteratingCollections((CtLoop)doLoop);
        iteratingCollections.forEach(collectionExpr -> this.checkInvocations((CtElement)doLoop.getBody(), (CtExpression<?>)collectionExpr));
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        Set<CtExpression<?>> iteratingCollections = this.getIteratingCollections((CtLoop)forLoop);
        iteratingCollections.forEach(collectionExpr -> this.checkInvocations((CtElement)forLoop.getBody(), (CtExpression<?>)collectionExpr));
        for (CtStatement updateStatement : forLoop.getForUpdate()) {
            iteratingCollections.forEach(collectionExpr -> this.checkInvocations((CtElement)updateStatement, (CtExpression<?>)collectionExpr));
        }
    }
}

