/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6052
extends PvsStudioRule {
    private final PvsStudioRule.Pattern ruleField = new PvsStudioRule.PatternBuilder().setMessage("Calling overridden '%s' method in '%s' parent-class constructor may lead to use of uninitialized data. Inspect field: %s.").setSastId("CERT-MET05-J").build();

    private void getParentCtrs(CtConstructor<?> ctr, Set<CtConstructor<?>> interestParentCtrs, CtClass<?> ctClass, Set<CtConstructor<?>> allParentCtrs) {
        if (ctr.getBody() == null || ctr.getBody().getStatements().isEmpty()) {
            return;
        }
        CtExecutable exec = ((CtInvocation)ctr.getBody().getStatement(0)).getExecutable().getDeclaration();
        if (exec == null) {
            return;
        }
        if (exec instanceof CtConstructor) {
            if (!allParentCtrs.add((CtConstructor)exec)) {
                return;
            }
            this.getParentCtrs((CtConstructor)exec, interestParentCtrs, ctClass, allParentCtrs);
            if (exec.getType() != null && exec.getType().getDeclaration() != null && exec.getType().getDeclaration() == ctClass) {
                interestParentCtrs.add((CtConstructor)exec);
            }
        }
    }

    private boolean isCompileTimeExpression(CtExpression<?> expression) {
        if (expression instanceof CtUnaryOperator) {
            CtUnaryOperator unaryOperator = (CtUnaryOperator)expression;
            return this.isCompileTimeExpression(unaryOperator.getOperand());
        }
        if (expression instanceof CtBinaryOperator) {
            CtBinaryOperator ctBinaryOperator = (CtBinaryOperator)expression;
            if (ctBinaryOperator.getKind() == BinaryOperatorKind.INSTANCEOF) {
                return false;
            }
            return this.isCompileTimeExpression(ctBinaryOperator.getRightHandOperand()) && this.isCompileTimeExpression(ctBinaryOperator.getLeftHandOperand());
        }
        if (expression instanceof CtConditional) {
            CtConditional ctConditional = (CtConditional)expression;
            return this.isCompileTimeExpression(ctConditional.getCondition()) && this.isCompileTimeExpression(ctConditional.getThenExpression()) && this.isCompileTimeExpression(ctConditional.getElseExpression());
        }
        if (expression instanceof CtFieldRead) {
            CtFieldReference ctField = ((CtFieldRead)expression).getVariable();
            return ctField.isStatic() && ctField.isFinal();
        }
        return expression instanceof CtLiteral;
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        if (ctClass.getSuperclass() == null || ctClass.isAnonymous()) {
            return;
        }
        CtType superCtClass = ctClass.getSuperclass().getDeclaration();
        if (!(superCtClass instanceof CtClass)) {
            return;
        }
        HashSet<CtConstructor> parentCtrs = new HashSet<CtConstructor>();
        ctClass.getConstructors().forEach(ctr -> this.getParentCtrs((CtConstructor<?>)ctr, (Set<CtConstructor<?>>)parentCtrs, (CtClass<?>)((CtClass)superCtClass), new HashSet()));
        List listFields = ctClass.getFields().stream().filter(arg -> !arg.isStatic()).filter(arg -> !arg.isFinal() || !RulesUtils.isPrimitive(arg) && !arg.getType().getQualifiedName().equals("java.lang.String") || !this.isCompileTimeExpression(arg.getAssignment())).collect(Collectors.toList());
        if (ctClass.getConstructors().stream().allMatch(CtElement::isImplicit)) {
            parentCtrs.removeIf(e -> !e.getParameters().isEmpty());
        }
        for (CtConstructor ctr2 : parentCtrs) {
            List childMethods;
            List allInv = ctr2.getBody().getElements((Filter)new TypeFilter(CtInvocation.class)).stream().filter(arg -> arg.getTarget() instanceof CtThisAccess).filter(arg -> arg.getExecutable() != null).filter(arg -> arg.getExecutable().getDeclaration() != null).filter(arg -> arg.getExecutable().getDeclaration().getBody() != null).filter(arg -> !arg.getExecutable().getDeclaration().getBody().getStatements().isEmpty()).filter(arg -> arg.getParent((Filter)new TypeFilter(CtLambda.class)) == null).filter(arg -> arg.getParent((Filter)new TypeFilter(CtMethod.class)) == null).collect(Collectors.toList());
            allInv.addAll(allInv.stream().flatMap(inv -> inv.getExecutable().getDeclaration().getBody().getElements((Filter)new TypeFilter(CtInvocation.class)).stream().filter(arg -> arg.getTarget() instanceof CtThisAccess).filter(arg -> arg.getExecutable() != null).filter(arg -> arg.getExecutable().getDeclaration() != null).filter(arg -> arg.getExecutable().getDeclaration().getBody() != null).filter(arg -> !arg.getExecutable().getDeclaration().getBody().getStatements().isEmpty()).filter(arg -> arg.getParent((Filter)new TypeFilter(CtLambda.class)) == null).filter(arg -> arg.getParent((Filter)new TypeFilter(CtMethod.class)) != null && ((CtMethod)arg.getParent((Filter)new TypeFilter(CtMethod.class))).getDeclaringType() != null && ((CtMethod)arg.getParent((Filter)new TypeFilter(CtMethod.class))).getDeclaringType().getReference() != null && !((CtMethod)arg.getParent((Filter)new TypeFilter(CtMethod.class))).getDeclaringType().getReference().isAnonymous())).collect(Collectors.toList()));
            Set parentMethods = superCtClass.getMethods().stream().filter(met -> allInv.stream().anyMatch(arg -> arg.getExecutable().getDeclaration() == met)).collect(Collectors.toSet());
            if (parentMethods.isEmpty() || (childMethods = ctClass.getMethods().stream().filter(arg -> parentMethods.stream().anyMatch(arg_0 -> ((CtMethod)arg).isOverriding(arg_0))).collect(Collectors.toList())).isEmpty()) continue;
            block1: for (CtMethod method : childMethods) {
                CtExpression expression;
                CtStatement statement;
                if (method.getBody() == null || method.getBody().getStatements().size() == 1 && (statement = method.getBody().getStatement(0)) instanceof CtReturn && ((expression = ((CtReturn)statement).getReturnedExpression()) instanceof CtLiteral || expression instanceof CtConstructorCall)) continue;
                HashSet fieldsReadOfMethod = new HashSet(method.getBody().getElements((Filter)new TypeFilter(CtFieldRead.class)));
                HashSet fieldsWriteOfMethod = new HashSet(method.getBody().getElements((Filter)new TypeFilter(CtFieldWrite.class)));
                for (CtFieldRead f : fieldsReadOfMethod) {
                    if (!listFields.stream().anyMatch(field -> field == f.getVariable().getDeclaration()) || !fieldsWriteOfMethod.stream().noneMatch(arg -> arg.getVariable().getDeclaration() == f.getVariable().getDeclaration())) continue;
                    this.ruleField.add((CtElement)method, method.getSimpleName(), superCtClass.getSimpleName(), f.getVariable().getDeclaration().getSimpleName()).addSourcePosition((CtElement)ctr2, this.getModule());
                    continue block1;
                }
            }
        }
    }
}

