/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.List;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6051
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("The use of the '%s' statement in the 'finally' block can lead to the loss of unhandled exceptions.").setCwe(584).setSastId("CERT-ERR04-J").build();

    public void visitCtTry(CtTry tryStatement) {
        if (tryStatement.getFinalizer() == null) {
            return;
        }
        CtBlock bodyFinal = tryStatement.getFinalizer();
        if (!bodyFinal.getElements(CtTry.class::isInstance).isEmpty()) {
            return;
        }
        ArrayList elements = new ArrayList(bodyFinal.getElements(e -> e instanceof CtReturn || e instanceof CtBreak || e instanceof CtContinue));
        if (elements.isEmpty()) {
            return;
        }
        List listCatchers = tryStatement.getCatchers();
        boolean isCatchThrow = listCatchers.stream().anyMatch(ctCatch -> !ctCatch.getElements(CtThrow.class::isInstance).isEmpty());
        if (!isCatchThrow) {
            CtExecutable ctExec = (CtExecutable)tryStatement.getParent((Filter)new TypeFilter(CtExecutable.class));
            if (ctExec == null) {
                return;
            }
            if (ctExec.getThrownTypes().isEmpty()) {
                return;
            }
            boolean isCatchException = listCatchers.stream().anyMatch(ctCatch -> ctCatch.getParameter().getReferencedTypes().stream().anyMatch(param -> param.getSimpleName().equals("Exception")));
            if (isCatchException) {
                return;
            }
        }
        for (CtElement element : elements) {
            if (element instanceof CtBreak || element instanceof CtContinue) {
                List listLoop = bodyFinal.getElements((Filter)new TypeFilter(CtLoop.class));
                List listSwitch = bodyFinal.getElements((Filter)new TypeFilter(CtSwitch.class));
                CtLoop parentLoop = (CtLoop)element.getParent((Filter)new TypeFilter(CtLoop.class));
                CtSwitch parentSwitch = (CtSwitch)element.getParent((Filter)new TypeFilter(CtSwitch.class));
                if (listLoop.stream().anyMatch(loop -> parentLoop == loop) || listSwitch.stream().anyMatch(ctSwitch -> parentSwitch == ctSwitch)) continue;
            }
            WarningLevel level = WarningLevel.LEVEL_1;
            if (element.getParent() != null && element.getParent().getParent() instanceof CtIf) {
                level = level.decrease();
            }
            if (RulesUtils.getParentBounded(element, (CtElement)tryStatement, CtLambda.class) != null || RulesUtils.getParentBounded(element, (CtElement)tryStatement, CtNewClass.class) != null) continue;
            String operator = element instanceof CtReturn ? "return" : (element instanceof CtBreak ? "break" : "continue");
            this.rule.add(element, operator).setLevel(level);
        }
    }
}

