/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.reflect.declaration.CtAnonymousExecutableImpl;

public class V6050
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder(this).setCwe(665).setSastId("CERT-DCL00-J");
    private final PvsStudioRule.Pattern rule = this.ruleBuilder.setMessage("Class initialization cycle is present. Initialization of '%s' appears before the initialization of '%s'.").build();
    private final PvsStudioRule.Pattern ruleInter = this.ruleBuilder.setMessage("Class initialization cycle is present. Initializers of '%s.%s' and '%s.%s' fields are interdependent.").build();
    private final PvsStudioRule.Pattern ruleMethod = this.ruleBuilder.setMessage("Class initialization cycle is present. A call of '%s.%s' method inside '%s.%s' field initializer creates interclass dependence.").build();
    private static final List<CtField<?>> ignoredFields = Lists.newArrayList();

    private void checkIntraClassCycle(CtClass<?> ctClass, List<InitWrapper> inits) {
        ArrayList interestCtors = Lists.newArrayList();
        InitWrapper cycleField = null;
        block0: for (InitWrapper curField : inits) {
            if (curField.getField().getType().getQualifiedName().equals(ctClass.getQualifiedName()) && curField.getDefaultExpression() instanceof CtConstructorCall) {
                CtExecutable ctor = ((CtConstructorCall)curField.getDefaultExpression()).getExecutable().getDeclaration();
                if (ctor instanceof CtConstructor) {
                    interestCtors.add((CtConstructor)ctor);
                } else assert (false) : "CtConstructorCall doesn't call constructor";
                cycleField = curField;
                continue;
            }
            for (CtConstructor ctor : interestCtors) {
                Optional<CtFieldRead> first = ctor.getBody().getElements((Filter)new TypeFilter(CtFieldRead.class)).stream().filter(arg -> arg.getVariable().getSimpleName().equals(curField.getSimpleName())).findFirst();
                if (!first.isPresent()) continue;
                this.rule.add((CtElement)cycleField.getDefaultExpression(), cycleField.getSimpleName(), curField.getSimpleName()).addSourcePosition((CtElement)first.get(), this.getModule()).addSourcePosition((CtElement)curField.getField(), this.getModule());
                continue block0;
            }
        }
    }

    private void checkInterClassCycle(CtClass<?> ctClass, List<InitWrapper> inits) {
        for (InitWrapper curField : inits) {
            List currentAssignmentVars = curField.getDefaultExpression().getElements((Filter)new TypeFilter(CtFieldRead.class)).stream().filter(r -> V6050.isFieldNotInLambda(r, curField.getDefaultExpression())).map(CtFieldAccess::getVariable).filter(CtFieldReference::isStatic).map(CtFieldReference::getDeclaration).filter(Objects::nonNull).filter(arg -> !RulesUtils.equals((CtElement)arg, curField.getField())).filter(arg -> arg.getDefaultExpression() != null).filter(arg -> arg.getDefaultExpression().getElements((Filter)new TypeFilter(CtMethod.class)).isEmpty()).filter(arg -> !this.isConstantExpression(arg.getDefaultExpression())).collect(Collectors.toList());
            for (CtField useField : currentAssignmentVars) {
                if (!(useField.getParent() instanceof CtClass)) continue;
                useField.getDefaultExpression().getElements((Filter)new TypeFilter(CtFieldRead.class)).stream().filter(r -> V6050.isFieldNotInLambda(r, curField.getDefaultExpression())).map(CtFieldAccess::getVariable).filter(CtFieldReference::isStatic).map(CtFieldReference::getDeclaration).filter(Objects::nonNull).filter(arg -> RulesUtils.equals((CtElement)arg, curField.getField())).findFirst().ifPresent(arg -> {
                    if (ignoredFields.stream().noneMatch(f -> RulesUtils.equals((CtElement)f, (CtElement)arg))) {
                        this.ruleInter.add((CtElement)curField.getDefaultExpression(), ctClass.getSimpleName(), curField.getSimpleName(), ((CtClass)useField.getParent()).getSimpleName(), useField.getSimpleName()).addSourcePosition((CtElement)useField, this.getModule());
                        ignoredFields.add(useField);
                    }
                });
            }
        }
    }

    private void checkMethodCycle(CtClass<?> ctClass, List<InitWrapper> inits) {
        for (InitWrapper curField : inits) {
            List interestMethods = curField.getDefaultExpression().getElements((Filter)new TypeFilter(CtInvocation.class)).stream().map(CtAbstractInvocation::getExecutable).filter(CtExecutableReference::isStatic).filter(arg -> arg.getDeclaringType() != null).filter(arg -> !arg.getDeclaringType().getQualifiedName().equals(ctClass.getQualifiedName())).map(CtExecutableReference::getDeclaration).filter(Objects::nonNull).filter(arg -> arg.getBody() != null).collect(Collectors.toList());
            for (CtExecutable impl : interestMethods) {
                if (!(impl.getParent() instanceof CtClass)) continue;
                impl.getBody().getElements((Filter)new TypeFilter(CtInvocation.class)).stream().filter(arg -> arg.getExecutable().getDeclaringType() != null).filter(arg -> arg.getExecutable().getDeclaringType().getQualifiedName().equals(ctClass.getQualifiedName())).findFirst().ifPresent(arg -> this.ruleMethod.add((CtElement)curField.getDefaultExpression(), ((CtClass)impl.getParent()).getSimpleName(), impl.getSimpleName(), ctClass.getSimpleName(), curField.getSimpleName()).addSourcePosition((CtElement)arg, this.getModule()));
                impl.getBody().getElements((Filter)new TypeFilter(CtFieldRead.class)).stream().filter(arg -> !arg.getVariable().getSimpleName().equals("class")).filter(arg -> arg.getVariable().getDeclaringType() != null).filter(arg -> arg.getVariable().getDeclaringType().getQualifiedName().equals(ctClass.getQualifiedName())).filter(arg -> arg.getVariable().getDeclaration() != null && arg.getVariable().getDeclaration().getDefaultExpression() != null).filter(arg -> !this.isConstantExpression(arg.getVariable().getDeclaration().getDefaultExpression())).findFirst().ifPresent(arg -> this.ruleMethod.add((CtElement)curField.getDefaultExpression(), ((CtClass)impl.getParent()).getSimpleName(), impl.getSimpleName(), ctClass.getSimpleName(), curField.getSimpleName()).addSourcePosition((CtElement)arg, this.getModule()));
            }
        }
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        ArrayList inits = Lists.newArrayList();
        ctClass.getTypeMembers().stream().filter(CtModifiable::isStatic).collect(Collectors.toList()).forEach(member -> {
            CtField field;
            if (member instanceof CtField && (field = (CtField)member).getDefaultExpression() != null && field.getDefaultExpression().getElements((Filter)new TypeFilter(CtMethod.class)).isEmpty() && !this.isConstantExpression(field.getDefaultExpression())) {
                inits.add(new InitWrapper(field));
            }
            if (member instanceof CtAnonymousExecutableImpl) {
                List assignments = ((CtAnonymousExecutableImpl)member).getBody().getStatements().stream().filter(statement -> statement instanceof CtAssignment).map(statement -> (CtAssignment)statement).collect(Collectors.toList());
                assignments.stream().filter(assignment -> assignment.getAssigned() instanceof CtFieldWrite).forEach(assignment -> {
                    CtField field = (CtField)this.getDataFlow().getVariablesCache().resolve((CtVariableReference<?>)((CtFieldWrite)assignment.getAssigned()).getVariable());
                    if (field != null) {
                        inits.add(new InitWrapper((CtField<?>)field, (CtAssignment<?, ?>)assignment));
                    }
                });
            }
        });
        this.checkIntraClassCycle(ctClass, inits);
        this.checkInterClassCycle(ctClass, inits);
        this.checkMethodCycle(ctClass, inits);
    }

    private static boolean isFieldNotInLambda(CtFieldRead<?> fieldRead, CtExpression<?> expression) {
        return RulesUtils.getParentBounded(fieldRead, expression, CtLambda.class) == null;
    }

    private static class InitWrapper {
        private final CtField<?> field;
        private final CtExpression<?> expression;

        protected InitWrapper(@NotNull CtField<?> field) {
            this(field, null);
        }

        protected InitWrapper(@NotNull CtField<?> field, @Nullable CtAssignment<?, ?> expression) {
            this.field = field;
            this.expression = expression != null ? expression.getAssignment() : null;
        }

        @NotNull
        public String getSimpleName() {
            return this.field.getSimpleName();
        }

        @NotNull
        public CtField<?> getField() {
            return this.field;
        }

        public CtExpression<?> getDefaultExpression() {
            if (this.field.getDefaultExpression() != null) {
                return this.field.getDefaultExpression();
            }
            return this.expression;
        }
    }
}

