/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.stream.Collectors;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;

public class V6049
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Classes that define '%s' method must also define '%s' method. Class: '%s'.").setLevel(WarningLevel.LEVEL_3).setSastId("CERT-MET09-J").build();

    private boolean isCompare(CtExpression<?> left, CtExpression<?> right, CtParameter<?> parameter) {
        return left instanceof CtThisAccess && right instanceof CtVariableAccess && parameter.getSimpleName().equals(((CtVariableAccess)right).getVariable().getSimpleName());
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        String nameFunc2;
        if (ctClass.getSuperclass() != null) {
            return;
        }
        List methods = ctClass.getMethods().stream().filter(arg -> arg.isPublic() && (arg.getSimpleName().equals("equals") && arg.getParameters().size() == 1 || arg.getSimpleName().equals("hashCode") && arg.getParameters().isEmpty())).collect(Collectors.toList());
        if (methods.size() != 1) {
            return;
        }
        CtMethod curMethod = (CtMethod)methods.get(0);
        String nameFunc1 = curMethod.getSimpleName();
        if (nameFunc1.equals("equals")) {
            CtStatement statement;
            if (curMethod.getBody() != null && curMethod.getBody().getStatements().size() == 1 && (statement = (CtStatement)curMethod.getBody().getStatements().get(0)) instanceof CtReturn) {
                CtInvocation invocation;
                CtExpression returnedExpression = ((CtReturn)statement).getReturnedExpression();
                if (returnedExpression instanceof CtBinaryOperator) {
                    CtBinaryOperator binOp = (CtBinaryOperator)returnedExpression;
                    CtExpression left = binOp.getLeftHandOperand();
                    CtExpression right = binOp.getRightHandOperand();
                    CtParameter parameter0 = (CtParameter)curMethod.getParameters().get(0);
                    if (binOp.getKind() == BinaryOperatorKind.EQ && (this.isCompare(left, right, parameter0) || this.isCompare(right, left, parameter0))) {
                        return;
                    }
                } else if (returnedExpression instanceof CtInvocation && (invocation = (CtInvocation)returnedExpression).getTarget() instanceof CtSuperAccess && invocation.getExecutable().getSimpleName().equals("equals")) {
                    return;
                }
            }
            nameFunc2 = "hashCode";
        } else {
            nameFunc2 = "equals";
        }
        this.rule.add((CtElement)ctClass, nameFunc1, nameFunc2, ctClass.getSimpleName());
    }
}

