/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.Lazy;
import com.pvsstudio.core.OptionalInt;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;

public class V6048
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("This expression can be simplified. One of the operands in the operation equals %2$s.").setExtendedMessage("This expression can be simplified. Operand '%s' in the operation equals %s.").setLevel(WarningLevel.LEVEL_2).setCwe(480).build();
    private static final Operand[] OPERANDS = new Operand[]{new Operand(BinaryOperatorKind.PLUS, 0), new Operand(BinaryOperatorKind.MINUS, 0), new Operand(BinaryOperatorKind.MUL, 1), new Operand(BinaryOperatorKind.MUL, 0), new Operand(BinaryOperatorKind.DIV, 1), new Operand(BinaryOperatorKind.DIV, 0), new Operand(BinaryOperatorKind.MOD, 1), new Operand(BinaryOperatorKind.MOD, 0), new Operand(BinaryOperatorKind.BITAND, 0), new Operand(BinaryOperatorKind.BITOR, 0), new Operand(BinaryOperatorKind.SL, 0), new Operand(BinaryOperatorKind.SR, 0), new Operand(BinaryOperatorKind.USR, 0)};

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        Lazy<OptionalInt> lhs = Lazy.of(() -> this.getValue((CtElement)operator.getLeftHandOperand()).toInt());
        Lazy<OptionalInt> rhs = Lazy.of(() -> this.getValue((CtElement)operator.getRightHandOperand()).toInt());
        for (Operand operand : OPERANDS) {
            CtExpression expression;
            if (operand.operator != operator.getKind()) continue;
            if (lhs.get().isPresent() && lhs.get().get() == operand.value) {
                expression = operator.getLeftHandOperand();
            } else {
                if (!rhs.get().isPresent() || rhs.get().get() != operand.value) continue;
                expression = operator.getRightHandOperand();
            }
            if (!RulesUtils.isPrimitive(operator.getLeftHandOperand()) || !RulesUtils.isPrimitive(operator.getRightHandOperand())) {
                return;
            }
            if (operator.getKind() == BinaryOperatorKind.DIV || operator.getKind() == BinaryOperatorKind.MOD) {
                if (expression == operator.getRightHandOperand() && operand.value == 0) {
                    return;
                }
                if (RulesUtils.isRealType(operator.getLeftHandOperand()) || RulesUtils.isRealType(operator.getRightHandOperand())) {
                    return;
                }
            }
            if (this.isConstantExpression(expression)) {
                return;
            }
            CtStatement parent = (CtStatement)expression.getParent(CtStatement.class);
            if (parent instanceof CtAssignment && this.isTheSameVariables((CtVariableWrite)((CtAssignment)parent).getAssigned(), expression)) {
                return;
            }
            this.rule.add((CtElement)operator, expression, operand.value);
        }
    }

    private boolean isTheSameVariables(CtVariableWrite<?> assigned, CtExpression<?> expression) {
        if (expression instanceof CtVariableRead) {
            return RulesUtils.equals(assigned, expression);
        }
        if (expression instanceof CtBinaryOperator) {
            CtBinaryOperator binExpression = (CtBinaryOperator)expression;
            CtExpression rhs = binExpression.getRightHandOperand();
            CtExpression lhs = binExpression.getLeftHandOperand();
            return this.isTheSameVariables(assigned, rhs) || this.isTheSameVariables(assigned, lhs);
        }
        return false;
    }

    private static class Operand {
        public final BinaryOperatorKind operator;
        public final int value;

        public Operand(BinaryOperatorKind k, int v) {
            this.operator = k;
            this.value = v;
        }
    }
}

