/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.FormatterStyle;
import com.pvsstudio.core.OptionalStringView;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.SpoonClassNotFoundException;

public class V6046
extends PvsStudioRule {
    private final PvsStudioRule.Pattern missingRule = new PvsStudioRule.PatternBuilder().setMessage("Incorrect format. A different number of format items is expected. Missing arguments: %s.").setCwe(685).build();
    private final PvsStudioRule.Pattern unusedArgumentsRule = new PvsStudioRule.PatternBuilder().setMessage("Incorrect format. A different number of format items is expected. Arguments not used: %s.").setLevel(WarningLevel.LEVEL_2).setCwe(685).build();
    private final PvsStudioRule.Pattern invalidTypeRule = new PvsStudioRule.PatternBuilder().setMessage("Incorrect format. Incompatible types for argument %1$s: '%3$s' is required.").setExtendedMessage("Incorrect format. Incompatible types for argument '%2$s': '%3$s' is required.").setCwe(686).build();
    private final PvsStudioRule.Pattern invalidSpecifier = new PvsStudioRule.PatternBuilder().setMessage("Illegal format specifier: '%s'.").setCwe(628).build();
    private static final Pattern FORMAT_SPECIFIER = Pattern.compile("%((?<index>\\d+)\\$)?(?<flags>[-#+ 0,(<]*)?(?<width>\\d+)?(\\.(?<precision>\\d+))?(?<time>[tT])?(?<type>[a-zA-Z%])");
    private static final Pattern ANCHOR_SPECIFIER = Pattern.compile("\\{}");

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        OptionalStringView formatView;
        int formatIndex = this.getMethodAnnotation((CtAbstractInvocation<?>)invocation).getFormatArgument().getIndex();
        if (formatIndex < 0 || formatIndex >= invocation.getArguments().size()) {
            return;
        }
        List<Object> arguments = invocation.getArguments().subList(formatIndex + 1, invocation.getArguments().size());
        int argumentsNumber = arguments.size();
        boolean isArrayArgs = false;
        if (argumentsNumber == 1 && ((CtExpression)arguments.get(0)).getType() instanceof CtArrayTypeReference) {
            isArrayArgs = true;
            try {
                argumentsNumber = this.getValue((CtElement)arguments.get(0)).toPointer().getLength().get().singletonValue().get().toInt().get();
                arguments = Collections.emptyList();
            }
            catch (Exception e) {
                return;
            }
        }
        if (!(formatView = this.getValue((CtElement)invocation.getArguments().get(formatIndex)).getVirtualValue().getSingletonString()).isPresent()) {
            return;
        }
        int maxIndex = 0;
        Set unusedArguments = IntStream.range(1, argumentsNumber + 1).boxed().collect(Collectors.toSet());
        FormatterStyle formatterStyle = this.getMethodAnnotation((CtAbstractInvocation<?>)invocation).getFormatArgument().getStyle();
        switch (formatterStyle) {
            case Printf: {
                for (FormatSpecifier specifier : V6046.parse(formatView.get())) {
                    if (!specifier.isSpecifier()) continue;
                    maxIndex = Math.max(specifier.index, maxIndex);
                    if (specifier.needsArgument()) {
                        if (specifier.index == 0) {
                            this.missingRule.add((CtElement)invocation, 0);
                        }
                        unusedArguments.remove(specifier.index);
                    }
                    if (specifier.flags.contains("-") && specifier.width.isEmpty()) {
                        this.invalidSpecifier.add((CtElement)invocation, specifier.text);
                    }
                    CtExpression argument = null;
                    if (specifier.index > 0 && specifier.index <= arguments.size()) {
                        argument = (CtExpression)arguments.get(specifier.index - 1);
                    }
                    try {
                        if (!specifier.time.isEmpty()) continue;
                        this.checkTypes(invocation, argument, specifier);
                    }
                    catch (SpoonClassNotFoundException spoonClassNotFoundException) {}
                }
                break;
            }
            case Anchor: {
                CtVariable ctVariable;
                Matcher m = ANCHOR_SPECIFIER.matcher(formatView.get());
                Iterator iterator = unusedArguments.iterator();
                while (m.find()) {
                    if (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                    ++maxIndex;
                }
                if (unusedArguments.isEmpty()) break;
                CtExpression lastArgument = (CtExpression)invocation.getArguments().get(invocation.getArguments().size() - 1);
                if (isArrayArgs) {
                    CtExpression argExpression = (CtExpression)invocation.getArguments().get(formatIndex + 1);
                    if (argExpression instanceof CtNewArray) {
                        CtNewArray argsArray = (CtNewArray)argExpression;
                        lastArgument = (CtExpression)argsArray.getElements().get(argsArray.getElements().size() - 1);
                    } else if (argExpression instanceof CtVariableRead) {
                        CtVariable arrayVariable = ((CtVariableRead)argExpression).getVariable().getDeclaration();
                        CtExpression defaultExpression = arrayVariable.getDefaultExpression();
                        if (defaultExpression instanceof CtNewArray) {
                            List elementsOfArray = ((CtNewArray)defaultExpression).getElements();
                            lastArgument = elementsOfArray.isEmpty() ? null : (CtExpression)elementsOfArray.get(elementsOfArray.size() - 1);
                        } else {
                            return;
                        }
                    }
                }
                if (lastArgument instanceof CtVariableRead && (ctVariable = ((CtVariableRead)lastArgument).getVariable().getDeclaration()) != null && (ctVariable.getType().getTypeDeclaration() == null || this.superClassIsThrowable(ctVariable.getType()))) {
                    Integer indexThrowable = argumentsNumber;
                    unusedArguments.removeIf(el -> el.equals(indexThrowable));
                }
                if (!RulesUtils.isSubtypeOf(lastArgument, "java.lang.Throwable")) break;
                Integer indexThrowable = argumentsNumber;
                unusedArguments.removeIf(el -> el.equals(indexThrowable));
                break;
            }
            default: {
                return;
            }
        }
        if (!unusedArguments.isEmpty()) {
            this.unusedArgumentsRule.add((CtElement)invocation, unusedArguments.stream().map(Object::toString).collect(Collectors.joining(", ")));
        }
        if (maxIndex > argumentsNumber) {
            this.missingRule.add((CtElement)invocation, maxIndex);
        }
    }

    public static List<FormatSpecifier> parse(String format) {
        Matcher m = FORMAT_SPECIFIER.matcher(format);
        ArrayList<FormatSpecifier> list = new ArrayList<FormatSpecifier>();
        int prevOrdinaryIndex = 0;
        int prevIndex = 0;
        int start = 0;
        while (m.find()) {
            if (m.start() > start) {
                list.add(new FormatSpecifier(format.substring(start, m.start())));
            }
            start = m.end();
            FormatSpecifier specifier = new FormatSpecifier(m);
            list.add(specifier);
            if (specifier.time.isEmpty() && (specifier.type.equals("%") || specifier.type.equals("n"))) {
                specifier.kind = FormatSpecifier.Kind.SPECIFIER_WITHOUT_ARGUMENT;
                continue;
            }
            if (specifier.flags.contains("<")) {
                specifier.index = prevIndex;
            } else if (specifier.explicitIndex.isEmpty()) {
                prevOrdinaryIndex = specifier.index = prevOrdinaryIndex + 1;
            } else {
                specifier.index = Integer.valueOf(specifier.explicitIndex);
            }
            prevIndex = specifier.index;
        }
        if (format.length() > start) {
            list.add(new FormatSpecifier(format.substring(start)));
        }
        return list;
    }

    private void typeConstraint(FormatSpecifier specifier, CtExpression<?> argument, String ... types) {
        try {
            boolean isCharacter = specifier.type.equals("c");
            if (argument == null || RulesUtils.getTypeName(argument).isEmpty()) {
                return;
            }
            if (isCharacter && !RulesUtils.isIntegerType(argument) && !RulesUtils.isBoxedIntegerType(argument)) {
                this.invalidTypeRule.add((CtElement)argument, specifier.index, argument, specifier.text);
            }
            if (!isCharacter && !RulesUtils.isSubtypeOf(argument, types)) {
                this.invalidTypeRule.add((CtElement)argument, specifier.index, argument, specifier.text);
            }
        }
        catch (NullPointerException | SpoonClassNotFoundException throwable) {
            // empty catch block
        }
    }

    private void checkTypes(CtInvocation<?> invocation, CtExpression<?> argument, FormatSpecifier specifier) {
        Consumer<Boolean> specifierConstraint = condition -> {
            if (!condition.booleanValue()) {
                this.invalidSpecifier.add((CtElement)invocation, specifier.text);
            }
        };
        switch (specifier.type.toLowerCase()) {
            case "b": {
                this.typeConstraint(specifier, argument, "java.lang.Boolean");
                specifierConstraint.accept(!specifier.flags.contains("#"));
                break;
            }
            case "x": 
            case "o": 
            case "d": {
                this.typeConstraint(specifier, argument, "java.lang.Number");
                specifierConstraint.accept(!(specifier.flags.contains("+") && specifier.flags.contains(" ") || specifier.flags.contains("-") && specifier.flags.contains("0") || !specifier.precision.isEmpty()));
                if (specifier.type.equalsIgnoreCase("d")) break;
                specifierConstraint.accept(!specifier.flags.contains(" ") && !specifier.flags.contains(",") && !specifier.flags.contains("+") && !specifier.flags.contains("("));
                break;
            }
            case "e": {
                this.typeConstraint(specifier, argument, "java.lang.Float", "java.lang.Double");
                specifierConstraint.accept(!specifier.flags.contains(","));
                break;
            }
            case "g": {
                this.typeConstraint(specifier, argument, "java.lang.Float", "java.lang.Double");
                specifierConstraint.accept(!specifier.flags.contains("#"));
                break;
            }
            case "f": {
                this.typeConstraint(specifier, argument, "java.lang.Float", "java.lang.Double");
                break;
            }
            case "a": {
                this.typeConstraint(specifier, argument, "java.lang.Float", "java.lang.Double");
                specifierConstraint.accept(!specifier.flags.contains("(") && !specifier.flags.contains(","));
                break;
            }
            case "h": {
                specifierConstraint.accept(!specifier.flags.contains("#"));
                break;
            }
            case "c": {
                this.typeConstraint(specifier, argument, new String[0]);
                specifierConstraint.accept(!specifier.flags.contains("#"));
                break;
            }
            case "s": {
                break;
            }
            case "%": {
                specifierConstraint.accept((specifier.flags.isEmpty() || specifier.flags.equals("-")) && specifier.precision.isEmpty());
                break;
            }
            case "n": {
                specifierConstraint.accept(specifier.flags.isEmpty() && specifier.width.isEmpty() && specifier.precision.isEmpty());
                break;
            }
            default: {
                this.invalidSpecifier.add((CtElement)invocation, specifier.text);
            }
        }
    }

    private boolean superClassIsThrowable(@NotNull CtTypeReference<?> ctTypeReference) {
        CtTypeReference superClass;
        for (superClass = ctTypeReference.getSuperclass(); superClass != null && superClass.getSuperclass() != null; superClass = superClass.getSuperclass()) {
        }
        return superClass != null && Objects.equals(superClass.getQualifiedName(), "java.lang.Throwable");
    }

    public static class FormatSpecifier {
        @NotNull
        public final String explicitIndex;
        @NotNull
        public final String text;
        @NotNull
        public final String flags;
        @NotNull
        public final String width;
        @NotNull
        public final String time;
        @NotNull
        public final String type;
        @NotNull
        public final String precision;
        @NotNull
        public Kind kind = Kind.SPECIFIER;
        public int index = 0;

        private String nonNull(String s) {
            return s == null ? "" : s;
        }

        public FormatSpecifier(Matcher m) {
            this.text = m.group();
            this.explicitIndex = this.nonNull(m.group("index"));
            this.type = this.nonNull(m.group("type"));
            this.time = this.nonNull(m.group("time"));
            this.flags = this.nonNull(m.group("flags"));
            this.width = this.nonNull(m.group("width"));
            this.precision = this.nonNull(m.group("precision"));
        }

        public FormatSpecifier(@NotNull String s) {
            this.text = s;
            this.explicitIndex = "";
            this.flags = "";
            this.width = "";
            this.time = "";
            this.type = "";
            this.precision = "";
            this.kind = Kind.TEXT;
        }

        public boolean isSpecifier() {
            return this.kind != Kind.TEXT;
        }

        public boolean needsArgument() {
            return this.kind == Kind.SPECIFIER;
        }

        public String toString() {
            return this.text;
        }

        static enum Kind {
            TEXT,
            SPECIFIER,
            SPECIFIER_WITHOUT_ARGUMENT;

        }
    }
}

