/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;

public class V6045
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Possible misprint in expression.").setExtendedMessage("Possible misprint in expression '%s'.").setLevel(WarningLevel.LEVEL_2).build();

    @Nullable
    private Expression getExpression(CtExpression<?> e) {
        CtInvocation invocation;
        if (e instanceof CtFieldAccess) {
            if (((CtFieldAccess)e).getTarget() != null) {
                return new Expression(((CtFieldAccess)e).getTarget(), ((CtFieldAccess)e).getVariable().getSimpleName(), true);
            }
        } else if (e instanceof CtInvocation && (invocation = (CtInvocation)e).getTarget() != null && invocation.getArguments().isEmpty()) {
            return new Expression(invocation.getTarget(), invocation.getExecutable().getSimpleName(), false);
        }
        return null;
    }

    @Nullable
    private Comparison getComparison(CtExpression<?> e) {
        if (e instanceof CtUnaryOperator) {
            if (((CtUnaryOperator)e).getKind() == UnaryOperatorKind.NOT) {
                return this.getComparison(((CtUnaryOperator)e).getOperand());
            }
        } else {
            CtInvocation invocation;
            if (e instanceof CtBinaryOperator) {
                CtBinaryOperator operator = (CtBinaryOperator)e;
                if (operator.getKind() != BinaryOperatorKind.LT && operator.getKind() != BinaryOperatorKind.LE && operator.getKind() != BinaryOperatorKind.GT && operator.getKind() != BinaryOperatorKind.GE && operator.getKind() != BinaryOperatorKind.EQ && operator.getKind() != BinaryOperatorKind.NE) {
                    return null;
                }
                return new Comparison(this.getExpression(operator.getLeftHandOperand()), this.getExpression(operator.getRightHandOperand()), e);
            }
            if (e instanceof CtInvocation && (invocation = (CtInvocation)e).getTarget() != null && invocation.getArguments().size() == 1 && invocation.getExecutable().getSimpleName().equals("equals")) {
                return new Comparison(this.getExpression(invocation.getTarget()), this.getExpression((CtExpression)invocation.getArguments().get(0)), e);
            }
        }
        return null;
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (operator.getKind() != BinaryOperatorKind.AND && operator.getKind() != BinaryOperatorKind.OR) {
            return;
        }
        List comparisons = RulesUtils.getSubExpressions(operator.getKind(), operator).stream().map(this::getComparison).filter(Objects::nonNull).filter(cmp -> cmp.left != null).filter(cmp -> cmp.right != null).collect(Collectors.toList());
        if (comparisons.size() < 3) {
            return;
        }
        Comparison first = (Comparison)comparisons.get(0);
        if ((comparisons = comparisons.stream().filter(cmp -> cmp.left.isField == first.left.isField).filter(cmp -> cmp.right.isField == first.right.isField).filter(cmp -> RulesUtils.equals(cmp.left.target, first.left.target)).filter(cmp -> RulesUtils.equals(cmp.right.target, first.right.target)).collect(Collectors.toList())).size() < 3) {
            return;
        }
        List anomalies = comparisons.stream().filter(Comparison::isAbnormal).collect(Collectors.toList());
        if (anomalies.size() != 1) {
            return;
        }
        Comparison anomaly = (Comparison)anomalies.get(0);
        if (anomaly.left.isField != anomaly.right.isField) {
            return;
        }
        this.rule.add((CtElement)anomaly.expression, anomaly.expression);
    }

    private static class Expression {
        public final CtExpression<?> target;
        public final String field;
        public final boolean isField;

        Expression(CtExpression<?> t, String f, boolean isF) {
            this.target = t;
            this.field = f;
            this.isField = isF;
        }
    }

    private static class Comparison {
        public final Expression left;
        public final Expression right;
        public final CtExpression<?> expression;

        Comparison(Expression l, Expression r, CtExpression<?> e) {
            this.left = l;
            this.right = r;
            this.expression = e;
        }

        boolean isAbnormal() {
            return !this.left.field.equals(this.right.field);
        }

        public String toString() {
            return this.expression.toString();
        }
    }
}

